/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.parquet;

import apoc.export.parquet.ParquetConfig;
import apoc.export.parquet.ParquetUtil;
import apoc.util.Util;
import apoc.util.collection.Iterables;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Types;
import org.neo4j.cypher.export.SubGraph;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.ResultTransformer;

public interface ParquetExportType<TYPE, ROW> {
    public MessageType schemaFor(GraphDatabaseService var1, List<Map<String, Object>> var2);

    public Group toRecord(MessageType var1, ROW var2);

    public List<Map<String, Object>> createConfig(List<ROW> var1, TYPE var2, ParquetConfig var3);

    public static class ResultType
    implements ParquetExportType<Result, Map<String, Object>> {
        @Override
        public MessageType schemaFor(GraphDatabaseService db, List<Map<String, Object>> type) {
            Types.MessageTypeBuilder messageTypeBuilder = Types.buildMessage();
            type.stream().flatMap(m -> m.entrySet().stream()).map(e -> new AbstractMap.SimpleEntry<String, String>((String)e.getKey(), ParquetUtil.fromMetaType(apoc.meta.Types.of(e.getValue())))).collect(Collectors.groupingBy(AbstractMap.SimpleEntry::getKey, Collectors.mapping(AbstractMap.SimpleEntry::getValue, Collectors.toSet()))).forEach((arg_0, arg_1) -> ResultType.lambda$schemaFor$2((Types.GroupBuilder)messageTypeBuilder, arg_0, arg_1));
            return (MessageType)messageTypeBuilder.named("apocExport");
        }

        @Override
        public Group toRecord(MessageType schema, Map<String, Object> map) {
            return ParquetUtil.mapToRecord(schema, map);
        }

        @Override
        public List<Map<String, Object>> createConfig(List<Map<String, Object>> row, Result data, ParquetConfig config) {
            return row;
        }

        private static /* synthetic */ void lambda$schemaFor$2(Types.GroupBuilder messageTypeBuilder, String key, Set value) {
            ParquetUtil.toField(key, value, messageTypeBuilder);
        }
    }

    public static class GraphType
    implements ParquetExportType<SubGraph, Entity> {
        private MessageType schema;
        private List<Map<String, Object>> config;

        @Override
        public MessageType schemaFor(GraphDatabaseService db, List<Map<String, Object>> type) {
            if (this.schema != null) {
                return this.schema;
            }
            Types.MessageTypeBuilder messageTypeBuilder = Types.buildMessage();
            Predicate<Map> filterStream = m -> m.get("propertyName") != null;
            ResultTransformer parsePropertiesResult = arg_0 -> GraphType.lambda$schemaFor$2(filterStream, (Types.GroupBuilder)messageTypeBuilder, arg_0);
            Map<String, Object> confMap = type.get(0);
            Map<String, Map<String, Object>> parameters = Map.of("config", confMap);
            String query = "CALL apoc.meta.%s($config) YIELD propertyName, propertyTypes RETURN propertyName, collect(propertyTypes) as types";
            db.executeTransactionally(String.format(query, "nodeTypeProperties"), parameters, parsePropertiesResult);
            ParquetUtil.getField((Types.GroupBuilder)messageTypeBuilder, PrimitiveType.PrimitiveTypeName.INT64, ParquetUtil.FIELD_ID);
            ParquetUtil.addListItem(ParquetUtil.FIELD_LABELS, (Types.GroupBuilder)messageTypeBuilder);
            if (confMap.containsKey("includeRels")) {
                db.executeTransactionally(String.format(query, "relTypeProperties"), parameters, parsePropertiesResult);
                ParquetUtil.getField((Types.GroupBuilder)messageTypeBuilder, PrimitiveType.PrimitiveTypeName.INT64, ParquetUtil.FIELD_SOURCE_ID);
                ParquetUtil.getField((Types.GroupBuilder)messageTypeBuilder, PrimitiveType.PrimitiveTypeName.INT64, ParquetUtil.FIELD_TARGET_ID);
                ParquetUtil.getField((Types.GroupBuilder)messageTypeBuilder, PrimitiveType.PrimitiveTypeName.BINARY, ParquetUtil.FIELD_TYPE);
            }
            this.schema = (MessageType)messageTypeBuilder.named("apocExport");
            return this.schema;
        }

        @Override
        public Group toRecord(MessageType schema, Entity entity) {
            Group group = ParquetUtil.mapToRecord(schema, entity.getAllProperties());
            if (entity instanceof Node) {
                group.append(ParquetUtil.FIELD_ID, entity.getId());
                ParquetUtil.appendList(group, ParquetUtil.FIELD_LABELS, Util.labelStrings((Node)((Node)entity)));
            } else {
                Relationship rel = (Relationship)entity;
                group.append(ParquetUtil.FIELD_TYPE, rel.getType().name());
                group.append(ParquetUtil.FIELD_SOURCE_ID, rel.getStartNodeId());
                group.append(ParquetUtil.FIELD_TARGET_ID, rel.getEndNodeId());
            }
            return group;
        }

        @Override
        public List<Map<String, Object>> createConfig(List<Entity> entity, SubGraph data, ParquetConfig config) {
            if (this.config != null) {
                return this.config;
            }
            List allLabelsInUse = Iterables.stream((Iterable)data.getAllLabelsInUse()).map(Label::name).collect(Collectors.toList());
            List allRelationshipTypesInUse = Iterables.stream((Iterable)data.getAllRelationshipTypesInUse()).map(RelationshipType::name).collect(Collectors.toList());
            HashMap<String, Object> configMap = new HashMap<String, Object>();
            configMap.put("includeLabels", allLabelsInUse);
            if (!allRelationshipTypesInUse.isEmpty()) {
                configMap.put("includeRels", allRelationshipTypesInUse);
            }
            configMap.putAll(config.getConfig());
            this.config = List.of(configMap);
            return this.config;
        }

        private static /* synthetic */ Void lambda$schemaFor$2(Predicate filterStream, Types.GroupBuilder messageTypeBuilder, Result result) {
            result.stream().filter(filterStream).forEach(m -> {
                String propertyName = (String)m.get("propertyName");
                List propertyTypes = ((List)m.get("types")).stream().flatMap(Collection::stream).collect(Collectors.toList());
                ParquetUtil.toField(propertyName, new HashSet<String>(propertyTypes), messageTypeBuilder);
            });
            return null;
        }
    }

    public static enum Type {
        RESULT(new ResultType()),
        GRAPH(new GraphType());

        private final ParquetExportType graphType;

        private Type(ParquetExportType graphType) {
            this.graphType = graphType;
        }

        public static ParquetExportType from(Object data) {
            Type type = data instanceof Result ? RESULT : GRAPH;
            return type.graphType;
        }
    }
}

