/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.parquet;

import apoc.Extended;
import apoc.Pools;
import apoc.export.parquet.ApocParquetReader;
import apoc.export.parquet.ParquetConfig;
import apoc.export.parquet.ParquetReadUtil;
import apoc.export.parquet.ParquetUtil;
import apoc.export.util.BatchTransaction;
import apoc.export.util.ProgressReporter;
import apoc.export.util.Reporter;
import apoc.result.ImportProgressInfo;
import apoc.result.ProgressInfo;
import apoc.util.Util;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.security.URLAccessChecker;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.values.storable.Value;

@Extended
public class ImportParquet {
    @Context
    public GraphDatabaseService db;
    @Context
    public Pools pools;
    @Context
    public Log log;
    @Context
    public URLAccessChecker urlAccessChecker;

    @Procedure(name="apoc.import.parquet", mode=Mode.WRITE)
    @Description(value="Imports parquet from the provided file or binary")
    public Stream<ImportProgressInfo> importParquet(@Name(value="input") Object input, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        ImportProgressInfo result = (ImportProgressInfo)Util.inThread((Pools)this.pools, () -> {
            String file = null;
            String sourceInfo = "binary";
            if (input instanceof String) {
                file = (String)input;
                sourceInfo = "file";
            }
            ParquetConfig conf = new ParquetConfig(config);
            HashMap<Long, Long> idMapping = new HashMap<Long, Long>();
            try (ApocParquetReader reader = ParquetReadUtil.getReader(input, conf, this.urlAccessChecker);){
                ProgressReporter reporter = new ProgressReporter(null, null, (ProgressInfo)new ImportProgressInfo(file, sourceInfo, "parquet"));
                try (BatchTransaction btx = new BatchTransaction(this.db, conf.getBatchSize(), (Reporter)reporter);){
                    Map<String, Object> recordMap;
                    while ((recordMap = reader.getRecord()) != null) {
                        String relType = (String)recordMap.remove(ParquetUtil.FIELD_TYPE);
                        if (relType == null) {
                            Object[] stringLabels = (Object[])recordMap.remove(ParquetUtil.FIELD_LABELS);
                            Label[] labels = Optional.ofNullable(stringLabels).map(l -> (Label[])Arrays.stream(l).map(Object::toString).map(Label::label).toArray(Label[]::new)).orElse(new Label[0]);
                            Node node = btx.getTransaction().createNode(labels);
                            long id = (Long)recordMap.remove(ParquetUtil.FIELD_ID);
                            idMapping.put(id, node.getId());
                            this.addProps(recordMap, (Entity)node);
                            reporter.update(1L, 0L, (long)recordMap.size());
                        } else {
                            long sourceId = (Long)recordMap.remove(ParquetUtil.FIELD_SOURCE_ID);
                            Long idSource = (Long)idMapping.get(sourceId);
                            Node source = btx.getTransaction().getNodeById(idSource.longValue());
                            long targetId = (Long)recordMap.remove(ParquetUtil.FIELD_TARGET_ID);
                            Long idTarget = (Long)idMapping.get(targetId);
                            Node target = btx.getTransaction().getNodeById(idTarget.longValue());
                            Relationship rel = source.createRelationshipTo(target, RelationshipType.withName((String)relType));
                            this.addProps(recordMap, (Entity)rel);
                            reporter.update(0L, 1L, (long)recordMap.size());
                        }
                        btx.increment();
                    }
                    btx.doCommit();
                }
                ImportProgressInfo importProgressInfo = (ImportProgressInfo)reporter.getTotal();
                return importProgressInfo;
            }
        });
        return Stream.of(result);
    }

    private void addProps(Map<String, Object> recordMap, Entity rel) {
        recordMap.forEach((k, v) -> {
            Object value = this.getNeo4jObject(v);
            rel.setProperty(k, value);
        });
    }

    private Object getNeo4jObject(Object object) {
        if (object instanceof Value) {
            return ((Value)object).asObject();
        }
        if (object instanceof Collection) {
            return ((Collection)object).stream().map(Object::toString).toArray(String[]::new);
        }
        return object;
    }
}

