/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.arrow;

import apoc.Pools;
import apoc.export.arrow.ExportArrowFileStrategy;
import apoc.export.arrow.ExportResultStrategy;
import apoc.export.util.ProgressReporter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.types.pojo.Schema;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Result;
import org.neo4j.logging.Log;
import org.neo4j.procedure.TerminationGuard;

public class ExportResultFileStrategy
implements ExportArrowFileStrategy<Result>,
ExportResultStrategy {
    private final String fileName;
    private final GraphDatabaseService db;
    private final Pools pools;
    private final TerminationGuard terminationGuard;
    private final Log logger;
    private final RootAllocator bufferAllocator;
    private Schema schema;

    public ExportResultFileStrategy(String fileName, GraphDatabaseService db, Pools pools, TerminationGuard terminationGuard, Log logger) {
        this.fileName = fileName;
        this.db = db;
        this.pools = pools;
        this.terminationGuard = terminationGuard;
        this.logger = logger;
        this.bufferAllocator = new RootAllocator();
    }

    @Override
    public Iterator<Map<String, Object>> toIterator(ProgressReporter reporter, Result data) {
        return data.stream().map(row -> {
            row.forEach((key, val) -> {
                boolean notNodeNorRelationship = !(val instanceof Node) && !(val instanceof Relationship);
                reporter.update(val instanceof Node ? 1L : 0L, val instanceof Relationship ? 1L : 0L, notNodeNorRelationship ? 1L : 0L);
                if (notNodeNorRelationship) {
                    reporter.nextRow();
                }
            });
            return row;
        }).iterator();
    }

    @Override
    public String getSource(Result result) {
        return String.format("statement: cols(%d)", result.columns().size());
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public TerminationGuard getTerminationGuard() {
        return this.terminationGuard;
    }

    @Override
    public BufferAllocator getBufferAllocator() {
        return this.bufferAllocator;
    }

    @Override
    public GraphDatabaseService getGraphDatabaseApi() {
        return this.db;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.pools.getDefaultExecutorService();
    }

    @Override
    public Log getLogger() {
        return this.logger;
    }

    @Override
    public synchronized Schema schemaFor(List<Map<String, Object>> records) {
        if (this.schema == null) {
            this.schema = this.schemaFor(this.getGraphDatabaseApi(), records);
        }
        return this.schema;
    }
}

