/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.arrow;

import apoc.export.arrow.ArrowConfig;
import apoc.export.arrow.ArrowUtils;
import apoc.export.arrow.ExportArrowStrategy;
import apoc.util.Util;
import apoc.util.collection.Iterables;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;
import org.neo4j.cypher.export.SubGraph;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResultTransformer;

public interface ExportGraphStrategy {
    default public Schema schemaFor(GraphDatabaseService db, List<Map<String, Object>> records) {
        Function<Map, Stream> flatMapStream = m -> {
            String propertyName = (String)m.get("propertyName");
            List propertyTypes = (List)m.get("propertyTypes");
            return propertyTypes.stream().map(propertyType -> ExportArrowStrategy.toField(propertyName, new HashSet<String>(propertyTypes)));
        };
        Predicate<Map> filterStream = m -> m.get("propertyName") != null;
        ResultTransformer parsePropertiesResult = result -> result.stream().filter(filterStream).flatMap(flatMapStream).collect(Collectors.toSet());
        Map<String, Object> cfg = records.get(0);
        Map<String, Map<String, Object>> parameters = Map.of("config", cfg);
        HashSet<Field> allFields = new HashSet<Field>();
        Set nodeFields = (Set)db.executeTransactionally("CALL apoc.meta.nodeTypeProperties($config)", parameters, parsePropertiesResult);
        allFields.add(ArrowUtils.FIELD_ID);
        allFields.add(ArrowUtils.FIELD_LABELS);
        allFields.addAll(nodeFields);
        if (cfg.containsKey("includeRels")) {
            Set relFields = (Set)db.executeTransactionally("CALL apoc.meta.relTypeProperties($config)", parameters, parsePropertiesResult);
            allFields.add(ArrowUtils.FIELD_SOURCE_ID);
            allFields.add(ArrowUtils.FIELD_TARGET_ID);
            allFields.add(ArrowUtils.FIELD_TYPE);
            allFields.addAll(relFields);
        }
        return new Schema(allFields);
    }

    default public Map<String, Object> entityToMap(Entity entity) {
        HashMap<String, Object> flattened = new HashMap<String, Object>();
        flattened.put(ArrowUtils.FIELD_ID.getName(), entity.getId());
        if (entity instanceof Node) {
            flattened.put(ArrowUtils.FIELD_LABELS.getName(), Util.labelStrings((Node)((Node)entity)));
        } else {
            Relationship rel = (Relationship)entity;
            flattened.put(ArrowUtils.FIELD_TYPE.getName(), rel.getType().name());
            flattened.put(ArrowUtils.FIELD_SOURCE_ID.getName(), rel.getStartNodeId());
            flattened.put(ArrowUtils.FIELD_TARGET_ID.getName(), rel.getEndNodeId());
        }
        flattened.putAll(entity.getAllProperties());
        return flattened;
    }

    default public Map<String, Object> createConfigMap(SubGraph subGraph, ArrowConfig config) {
        List allLabelsInUse = Iterables.stream((Iterable)subGraph.getAllLabelsInUse()).map(Label::name).collect(Collectors.toList());
        List allRelationshipTypesInUse = Iterables.stream((Iterable)subGraph.getAllRelationshipTypesInUse()).map(RelationshipType::name).collect(Collectors.toList());
        HashMap<String, Object> configMap = new HashMap<String, Object>();
        configMap.put("includeLabels", allLabelsInUse);
        if (!allRelationshipTypesInUse.isEmpty()) {
            configMap.put("includeRels", allRelationshipTypesInUse);
        }
        configMap.putAll(config.getConfig());
        return configMap;
    }
}

