/*
 * Decompiled with CFR 0.152.
 */
package apoc.es;

import apoc.util.UrlResolver;
import apoc.util.Util;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public abstract class ElasticSearchHandler {
    private static final Pattern KEY_VALUE = Pattern.compile("(.*)(:|=)(.*)");

    protected String getElasticSearchUrl(String hostOrKey) {
        return new UrlResolver("http", "localhost", 9200).getUrl("es", hostOrKey);
    }

    protected String toQueryParams(Object query) {
        if (query == null) {
            return "";
        }
        if (query instanceof Map) {
            Map map = (Map)query;
            if (map.isEmpty()) {
                return "";
            }
            return map.entrySet().stream().map(e -> (String)e.getKey() + "=" + Util.encodeUrlComponent((String)e.getValue().toString())).collect(Collectors.joining("&"));
        }
        return Pattern.compile("&").splitAsStream(query.toString()).map(KEY_VALUE::matcher).filter(Matcher::matches).map(matcher -> matcher.group(1) + matcher.group(2) + Util.encodeUrlComponent((String)matcher.group(3))).collect(Collectors.joining("&"));
    }

    protected String getQueryUrl(String hostOrKey, String index, String type, String id, Object query) {
        return this.getElasticSearchUrl(hostOrKey) + this.formatQueryUrl(index, type, id, query);
    }

    protected String getSearchQueryUrl(String hostOrKey, String index, String type, Object query) {
        return this.getElasticSearchUrl(hostOrKey) + this.formatSearchQueryUrl(index, type, query);
    }

    protected abstract String formatSearchQueryUrl(String var1, String var2, Object var3);

    protected abstract String formatQueryUrl(String var1, String var2, String var3, Object var4);

    @NotNull
    private static String removeTerminalQuote(String queryUrl) {
        return queryUrl.endsWith("?") ? queryUrl.substring(0, queryUrl.length() - 1) : queryUrl;
    }

    static class Default
    extends ElasticSearchHandler {
        private final String fullQueryTemplate = "/%s/%s/%s?%s";
        private final String fullQuerySearchTemplate = "/%s/%s/_search?%s";

        Default() {
        }

        @Override
        protected String formatSearchQueryUrl(String index, String type, Object query) {
            String queryUrl = String.format("/%s/%s/_search?%s", index == null ? "_all" : index, type == null ? "_all" : type, this.toQueryParams(query));
            return ElasticSearchHandler.removeTerminalQuote(queryUrl);
        }

        @Override
        protected String formatQueryUrl(String index, String type, String id, Object query) {
            String queryUrl = String.format("/%s/%s/%s?%s", index == null ? "_all" : index, type == null ? "_all" : type, id == null ? "" : id, this.toQueryParams(query));
            return ElasticSearchHandler.removeTerminalQuote(queryUrl);
        }
    }

    static class Eight
    extends ElasticSearchHandler {
        Eight() {
        }

        @Override
        protected String formatSearchQueryUrl(String index, String type, Object query) {
            String queryUrl = String.format("/%s/_search?%s", index == null ? "_all" : index, this.toQueryParams(query));
            return ElasticSearchHandler.removeTerminalQuote(queryUrl);
        }

        @Override
        protected String formatQueryUrl(String index, String type, String id, Object query) {
            String queryUrl = Arrays.asList(index, type, id).stream().filter(StringUtils::isNotBlank).collect(Collectors.joining("/"));
            Object queryParams = this.toQueryParams(query);
            queryParams = "".equals(queryParams) ? "" : "?" + (String)queryParams;
            return "/" + queryUrl + (String)queryParams;
        }
    }

    static enum Version {
        EIGHT(new Eight()),
        DEFAULT(new Default());

        private final ElasticSearchHandler handler;

        private Version(ElasticSearchHandler handler) {
            this.handler = handler;
        }

        public ElasticSearchHandler get() {
            return this.handler;
        }
    }
}

