/*
 * Decompiled with CFR 0.152.
 */
package apoc.es;

import apoc.es.ElasticSearchHandler;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ElasticSearchConfig {
    public static final String HEADERS_KEY = "headers";
    public static final String VERSION_KEY = "version";
    private final Map<String, Object> headers;
    private final ElasticSearchHandler version;

    public ElasticSearchConfig(Map<String, Object> config) {
        this(config, null);
    }

    public ElasticSearchConfig(Map<String, Object> config, String httpMethod) {
        if (config == null) {
            config = Collections.emptyMap();
        }
        Map headerConf = config.getOrDefault(HEADERS_KEY, new HashMap());
        headerConf.putIfAbsent("content-type", "application/json");
        if (httpMethod != null) {
            headerConf.putIfAbsent("method", httpMethod);
        }
        this.headers = headerConf;
        String versionConf = (String)config.getOrDefault(VERSION_KEY, ElasticSearchHandler.Version.DEFAULT.name());
        this.version = ElasticSearchHandler.Version.valueOf(versionConf).get();
    }

    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    public ElasticSearchHandler getVersion() {
        return this.version;
    }
}

