/*
 * Decompiled with CFR 0.152.
 */
package apoc.dv;

import apoc.ApocConfig;
import apoc.Extended;
import apoc.dv.DataVirtualizationCatalogHandler;
import apoc.dv.VirtualizedResource;
import apoc.result.NodeResult;
import apoc.result.PathResult;
import apoc.result.VirtualPath;
import apoc.result.VirtualRelationship;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@Extended
public class DataVirtualizationCatalog {
    public static final String DIRECTION_CONF_KEY = "direction";
    @Context
    public Transaction tx;
    @Context
    public Log log;
    @Context
    public GraphDatabaseService db;
    @Context
    public ApocConfig apocConfig;

    @Deprecated
    @Procedure(name="apoc.dv.catalog.add", mode=Mode.WRITE, deprecatedBy="apoc.dv.catalog.install")
    @Description(value="Add a virtualized resource configuration")
    public Stream<VirtualizedResource.VirtualizedResourceDTO> add(@Name(value="name") String name, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        return Stream.of(new DataVirtualizationCatalogHandler(this.db, this.apocConfig.getSystemDb(), this.log).add(VirtualizedResource.from(name, config))).map(VirtualizedResource::toDTO);
    }

    @Deprecated
    @Procedure(name="apoc.dv.catalog.remove", mode=Mode.WRITE, deprecatedBy="apoc.dv.catalog.drop")
    @Description(value="Remove a virtualized resource config by name")
    public Stream<VirtualizedResource.VirtualizedResourceDTO> remove(@Name(value="name") String name) {
        return new DataVirtualizationCatalogHandler(this.db, this.apocConfig.getSystemDb(), this.log).remove(name).map(VirtualizedResource::toDTO);
    }

    @Deprecated
    @Procedure(name="apoc.dv.catalog.list", mode=Mode.READ, deprecatedBy="apoc.dv.catalog.show")
    @Description(value="List all virtualized resource configuration")
    public Stream<VirtualizedResource.VirtualizedResourceDTO> list() {
        return new DataVirtualizationCatalogHandler(this.db, this.apocConfig.getSystemDb(), this.log).list().map(VirtualizedResource::toDTO);
    }

    @Procedure(name="apoc.dv.query", mode=Mode.READ)
    @Description(value="Query a virtualized resource by name and return virtual nodes")
    public Stream<NodeResult> query(@Name(value="name") String name, @Name(value="params", defaultValue="{}") Object params, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        VirtualizedResource vr = new DataVirtualizationCatalogHandler(this.db, this.apocConfig.getSystemDb(), this.log).get(name);
        Pair<String, Map<String, Object>> procedureCallWithParams = vr.getProcedureCallWithParams(params, config);
        return this.tx.execute((String)procedureCallWithParams.getLeft(), (Map)procedureCallWithParams.getRight()).stream().map(m -> (Node)m.get("node")).map(NodeResult::new);
    }

    @Procedure(name="apoc.dv.queryAndLink", mode=Mode.READ)
    @Description(value="Query a virtualized resource by name and return virtual nodes linked using virtual rels to the node passed as first param")
    public Stream<PathResult> queryAndLink(@Name(value="node") Node node, @Name(value="relName") String relName, @Name(value="name") String name, @Name(value="params", defaultValue="{}") Object params, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        VirtualizedResource vr = new DataVirtualizationCatalogHandler(this.db, this.apocConfig.getSystemDb(), null).get(name);
        RelationshipType relationshipType = RelationshipType.withName((String)relName);
        Pair<String, Map<String, Object>> procedureCallWithParams = vr.getProcedureCallWithParams(params, config);
        String direction = (String)config.getOrDefault(DIRECTION_CONF_KEY, Direction.OUT.name());
        return this.tx.execute((String)procedureCallWithParams.getLeft(), (Map)procedureCallWithParams.getRight()).stream().map(m -> (Node)m.get("node")).map(n -> this.getVirtualRelationship(node, (Node)n, direction, relationshipType)).map(r -> {
            VirtualPath virtualPath = new VirtualPath(r.getStartNode());
            virtualPath.addRel((Relationship)r);
            return virtualPath;
        }).map(PathResult::new);
    }

    private VirtualRelationship getVirtualRelationship(Node node, Node n, String direction, RelationshipType relationshipType) {
        if (Objects.equals(direction.toUpperCase(), Direction.OUT.name())) {
            return new VirtualRelationship(node, n, relationshipType);
        }
        return new VirtualRelationship(n, node, relationshipType);
    }

    static enum Direction {
        IN,
        OUT;

    }
}

