/*
 * Decompiled with CFR 0.152.
 */
package apoc.custom;

import apoc.ExtendedSystemPropertyKeys;
import apoc.SystemPropertyKeys;
import apoc.custom.CustomProcedureInfo;
import apoc.custom.Signatures;
import apoc.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.neo4j.graphdb.Node;
import org.neo4j.internal.kernel.api.procs.DefaultParameterValue;
import org.neo4j.internal.kernel.api.procs.FieldSignature;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.internal.kernel.api.procs.UserFunctionSignature;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;

public class CypherProceduresUtil {
    public static final String MAP_RESULT_TYPE = "MAPRESULT";

    public static QualifiedName qualifiedName(@Name(value="name") String name) {
        String[] names = name.split("\\.");
        ArrayList<String> namespaceList = new ArrayList<String>(names.length);
        namespaceList.add("custom");
        namespaceList.addAll(Arrays.asList(names));
        String[] namespace = (String[])namespaceList.subList(0, namespaceList.size() - 1).toArray(String[]::new);
        return new QualifiedName(namespace, names[names.length - 1]);
    }

    public static Mode mode(String s) {
        return s == null ? Mode.READ : Mode.valueOf((String)s.toUpperCase());
    }

    public static CustomProcedureInfo getFunctionInfo(Node node) {
        String statement = (String)node.getProperty(SystemPropertyKeys.statement.name());
        boolean forceSingle = (Boolean)node.getProperty(ExtendedSystemPropertyKeys.forceSingle.name(), (Object)false);
        UserFunctionSignature signature = CypherProceduresUtil.getUserFunctionSignature(node);
        return CustomProcedureInfo.getCustomFunctionInfo(signature, forceSingle, statement);
    }

    public static CustomProcedureInfo getProcedureInfo(Node node) {
        String statement = (String)node.getProperty(SystemPropertyKeys.statement.name());
        ProcedureSignature signature = CypherProceduresUtil.getProcedureSignature(node);
        return CustomProcedureInfo.getCustomProcedureInfo(signature, statement);
    }

    public static UserFunctionSignature getUserFunctionSignature(Node node) {
        String name = (String)node.getProperty(SystemPropertyKeys.name.name());
        String description = (String)node.getProperty(ExtendedSystemPropertyKeys.description.name(), null);
        String[] prefix = (String[])node.getProperty(ExtendedSystemPropertyKeys.prefix.name(), (Object)new String[]{"custom"});
        String property = (String)node.getProperty(ExtendedSystemPropertyKeys.inputs.name());
        List<FieldSignature> inputs = CypherProceduresUtil.deserializeSignatures(property);
        return new UserFunctionSignature(new QualifiedName(prefix, name), inputs, CypherProceduresUtil.typeof((String)node.getProperty(ExtendedSystemPropertyKeys.output.name())), null, description, "apoc.custom", false, false, false, false);
    }

    public static ProcedureSignature getProcedureSignature(Node node) {
        String name = (String)node.getProperty(SystemPropertyKeys.name.name());
        String description = (String)node.getProperty(ExtendedSystemPropertyKeys.description.name(), null);
        String[] prefix = (String[])node.getProperty(ExtendedSystemPropertyKeys.prefix.name(), (Object)new String[]{"custom"});
        String property = (String)node.getProperty(ExtendedSystemPropertyKeys.inputs.name());
        List<FieldSignature> inputs = CypherProceduresUtil.deserializeSignatures(property);
        List<FieldSignature> outputSignature = CypherProceduresUtil.deserializeSignatures((String)node.getProperty(ExtendedSystemPropertyKeys.outputs.name()));
        return Signatures.createProcedureSignature(new QualifiedName(prefix, name), inputs, outputSignature, Mode.valueOf((String)((String)node.getProperty(ExtendedSystemPropertyKeys.mode.name()))), false, null, description, null, false, false, false, false, false, false);
    }

    public static List<FieldSignature> deserializeSignatures(String s) {
        List mapped = (List)Util.fromJson((String)s, List.class);
        if (mapped.isEmpty()) {
            return ProcedureSignature.VOID;
        }
        return mapped.stream().map(map -> {
            String typeString = (String)map.get("type");
            if (typeString.endsWith("?")) {
                typeString = typeString.substring(0, typeString.length() - 1);
            }
            Neo4jTypes.AnyType type = CypherProceduresUtil.typeof(typeString);
            if (map.containsKey("default")) {
                return FieldSignature.inputField((String)((String)map.get("name")), (Neo4jTypes.AnyType)type, (DefaultParameterValue)new DefaultParameterValue(map.get("default"), type));
            }
            return FieldSignature.inputField((String)((String)map.get("name")), (Neo4jTypes.AnyType)type);
        }).collect(Collectors.toList());
    }

    public static Neo4jTypes.AnyType typeof(String typeName) {
        typeName = typeName.replaceAll("\\?", "");
        if ((typeName = typeName.toUpperCase()).startsWith("LIST OF ")) {
            return Neo4jTypes.NTList((Neo4jTypes.AnyType)CypherProceduresUtil.typeof(typeName.substring(8)));
        }
        if (typeName.startsWith("LIST ")) {
            return Neo4jTypes.NTList((Neo4jTypes.AnyType)CypherProceduresUtil.typeof(typeName.substring(5)));
        }
        if (typeName.startsWith("LIST<") && typeName.endsWith(">")) {
            Neo4jTypes.AnyType typeof = CypherProceduresUtil.typeof(typeName.substring(5, typeName.length() - 1));
            return Neo4jTypes.NTList((Neo4jTypes.AnyType)typeof);
        }
        return CypherProceduresUtil.getBaseType(typeName);
    }

    public static Neo4jTypes.AnyType getBaseType(String typeName) {
        return switch (typeName) {
            case "ANY" -> Neo4jTypes.NTAny;
            case "MAP", MAP_RESULT_TYPE -> Neo4jTypes.NTMap;
            case "NODE" -> Neo4jTypes.NTNode;
            case "REL", "RELATIONSHIP", "EDGE" -> Neo4jTypes.NTRelationship;
            case "PATH" -> Neo4jTypes.NTPath;
            case "NUMBER", "INTEGER | FLOAT" -> Neo4jTypes.NTNumber;
            case "LONG", "INT", "INTEGER" -> Neo4jTypes.NTInteger;
            case "FLOAT", "DOUBLE" -> Neo4jTypes.NTFloat;
            case "BOOL", "BOOLEAN" -> Neo4jTypes.NTBoolean;
            case "DATE" -> Neo4jTypes.NTDate;
            case "TIME", "ZONED TIME" -> Neo4jTypes.NTTime;
            case "LOCALTIME", "LOCAL TIME" -> Neo4jTypes.NTLocalTime;
            case "DATETIME", "ZONED DATETIME" -> Neo4jTypes.NTDateTime;
            case "LOCALDATETIME", "LOCAL DATETIME" -> Neo4jTypes.NTLocalDateTime;
            case "DURATION" -> Neo4jTypes.NTDuration;
            case "POINT" -> Neo4jTypes.NTPoint;
            case "GEO", "GEOMETRY" -> Neo4jTypes.NTGeometry;
            default -> Neo4jTypes.NTString;
        };
    }
}

