/*
 * Decompiled with CFR 0.152.
 */
package apoc.couchbase;

import apoc.couchbase.CouchbaseConfig;
import apoc.couchbase.CouchbaseManager;
import apoc.couchbase.document.CouchbaseByteArrayDocument;
import apoc.couchbase.document.CouchbaseJsonDocument;
import apoc.couchbase.document.CouchbaseQueryResult;
import apoc.couchbase.document.CouchbaseUtils;
import com.couchbase.client.core.env.Authenticator;
import com.couchbase.client.core.env.PasswordAuthenticator;
import com.couchbase.client.core.env.SeedNode;
import com.couchbase.client.core.error.DocumentNotFoundException;
import com.couchbase.client.java.BinaryCollection;
import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.ClusterOptions;
import com.couchbase.client.java.Collection;
import com.couchbase.client.java.codec.RawBinaryTranscoder;
import com.couchbase.client.java.codec.Transcoder;
import com.couchbase.client.java.env.ClusterEnvironment;
import com.couchbase.client.java.json.JsonArray;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.kv.GetOptions;
import com.couchbase.client.java.kv.GetResult;
import com.couchbase.client.java.kv.MutationResult;
import com.couchbase.client.java.query.QueryOptions;
import com.couchbase.client.java.query.QueryResult;
import java.net.URI;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.configuration2.Configuration;

public class CouchbaseConnection
implements AutoCloseable {
    private static final String SPLIT_URI_KEY = ",";
    private Cluster cluster;
    private Bucket bucket;
    private Collection collection;
    private BinaryCollection binaryCollection;
    private ClusterEnvironment env;

    protected CouchbaseConnection(String hostOrKey, PasswordAuthenticator authenticator, String bucketName, CouchbaseConfig config) {
        Set<Object> seedNodes;
        URI singleHostURI = CouchbaseManager.checkAndGetURI(hostOrKey);
        if (singleHostURI == null || singleHostURI.getScheme() == null) {
            Configuration couchbaseConfig = CouchbaseManager.getKeyMap(hostOrKey);
            int port = couchbaseConfig.getInt("port", -1);
            String url = couchbaseConfig.getString("uri", null);
            if (url == null) {
                throw new RuntimeException("Please check you 'apoc.couchbase." + hostOrKey + "' configuration, url is missing");
            }
            List<String> splitUrl = Arrays.asList(url.split(SPLIT_URI_KEY));
            seedNodes = splitUrl.stream().map(singleUri -> SeedNode.create((String)singleUri, Optional.empty(), port != -1 ? Optional.of(port) : Optional.empty())).collect(Collectors.toSet());
        } else {
            String url = singleHostURI.getHost();
            int port = singleHostURI.getPort();
            seedNodes = Set.of(SeedNode.create((String)url, Optional.empty(), port != -1 ? Optional.of(port) : Optional.empty()));
        }
        this.env = config.getEnv();
        this.cluster = Cluster.connect(seedNodes, (ClusterOptions)ClusterOptions.clusterOptions((Authenticator)authenticator).environment(this.env));
        try {
            this.bucket = this.cluster.bucket(bucketName);
            if (config.getWaitUntilReady() != null) {
                this.bucket.waitUntilReady(Duration.ofMillis(config.getWaitUntilReady()));
            }
            this.collection = this.bucket.scope(config.getScope()).collection(config.getCollection());
            this.binaryCollection = this.collection.binary();
        }
        catch (Exception e) {
            this.close();
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        try {
            this.cluster.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.env.shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Collection getCollection() {
        return this.collection;
    }

    public CouchbaseJsonDocument get(String documentId) {
        GetResult getResult = this.getResult(documentId);
        if (getResult == null) {
            return null;
        }
        return new CouchbaseJsonDocument(getResult, documentId);
    }

    private GetResult getResult(String documentId) {
        try {
            return this.collection.get(documentId, GetOptions.getOptions().withExpiry(true));
        }
        catch (DocumentNotFoundException e) {
            return null;
        }
    }

    public GetResult getBinary(String documentId) {
        try {
            return this.collection.get(documentId, GetOptions.getOptions().transcoder((Transcoder)RawBinaryTranscoder.INSTANCE).withExpiry(true));
        }
        catch (DocumentNotFoundException e) {
            return null;
        }
    }

    public boolean exists(String documentId) {
        return this.collection.exists(documentId).exists();
    }

    public CouchbaseJsonDocument insert(String documentId, String json) {
        MutationResult insert = this.collection.insert(documentId, (Object)JsonObject.fromJson((String)json));
        GetResult getResult = this.getResult(documentId);
        return new CouchbaseJsonDocument(getResult, documentId, insert.mutationToken().orElse(null));
    }

    public CouchbaseJsonDocument upsert(String documentId, String json) {
        MutationResult upsertResult = this.collection.upsert(documentId, (Object)JsonObject.fromJson((String)json));
        GetResult getResult = this.getResult(documentId);
        return new CouchbaseJsonDocument(getResult, documentId, upsertResult.mutationToken().orElse(null));
    }

    public CouchbaseByteArrayDocument append(String documentId, byte[] content) {
        MutationResult appendResult = this.binaryCollection.append(documentId, content);
        GetResult getResult = this.getBinary(documentId);
        return new CouchbaseByteArrayDocument(getResult, documentId, appendResult.mutationToken().orElse(null));
    }

    public CouchbaseByteArrayDocument prepend(String documentId, byte[] content) {
        MutationResult prependResult = this.binaryCollection.prepend(documentId, content);
        GetResult binaryResult = this.getBinary(documentId);
        return new CouchbaseByteArrayDocument(binaryResult, documentId, prependResult.mutationToken().orElse(null));
    }

    public CouchbaseJsonDocument remove(String documentId) {
        GetResult getResult = this.getResult(documentId);
        MutationResult removeResult = this.collection.remove(documentId);
        return new CouchbaseJsonDocument(getResult, documentId, removeResult.mutationToken().orElse(null));
    }

    public CouchbaseJsonDocument replace(String documentId, String json) {
        MutationResult replaceResult = this.collection.replace(documentId, (Object)JsonObject.fromJson((String)json));
        GetResult getResult = this.getResult(documentId);
        return new CouchbaseJsonDocument(getResult, documentId, replaceResult.mutationToken().orElse(null));
    }

    public CouchbaseQueryResult executeStatement(String statement) {
        List statementResult = this.cluster.query(statement).rowsAsObject();
        return CouchbaseUtils.convertToCouchbaseQueryResult(statementResult);
    }

    public CouchbaseQueryResult executeParameterizedStatement(String statement, List<Object> parameters) {
        JsonArray positionalParams = JsonArray.from(parameters);
        QueryResult queryResult = this.cluster.query(statement, QueryOptions.queryOptions().parameters(positionalParams));
        List statementResult = queryResult.rowsAsObject();
        return CouchbaseUtils.convertToCouchbaseQueryResult(statementResult);
    }

    public CouchbaseQueryResult executeParameterizedStatement(String statement, List<String> parameterNames, List<Object> parameterValues) {
        JsonObject namedParams = JsonObject.create();
        for (int param = 0; param < parameterNames.size(); ++param) {
            namedParams.put(parameterNames.get(param), parameterValues.get(param));
        }
        QueryResult queryResult = this.cluster.query(statement, QueryOptions.queryOptions().parameters(namedParams));
        List statementResult = queryResult.rowsAsObject();
        return CouchbaseUtils.convertToCouchbaseQueryResult(statementResult);
    }
}

