/*
 * Decompiled with CFR 0.152.
 */
package apoc.couchbase;

import apoc.Extended;
import apoc.couchbase.CouchbaseConfig;
import apoc.couchbase.CouchbaseConnection;
import apoc.couchbase.CouchbaseManager;
import apoc.couchbase.document.CouchbaseByteArrayDocument;
import apoc.couchbase.document.CouchbaseJsonDocument;
import apoc.couchbase.document.CouchbaseQueryResult;
import apoc.result.BooleanResult;
import apoc.util.MissingDependencyException;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@Extended
public class Couchbase {
    public static final String COUCHBASE_MISSING_DEPS_ERROR = "Cannot find the jar into the plugins folder. \nPlease put these jar in the plugins folder : \n\njava-client-x.y.z.jar\n\ncore-io-x.y.z.jar\n\nrxjava-x.y.z.jar\n\nSee the documentation: https://neo4j-contrib.github.io/neo4j-apoc-procedures/#_interacting_with_couchbase";

    @Procedure
    @Description(value="apoc.couchbase.get(hostOrKey, bucket, documentId, config) yield id, expiry, cas, mutationToken, content - retrieves a couchbase json document by its unique ID.")
    public Stream<CouchbaseJsonDocument> get(@Name(value="hostOrKey") String hostOrKey, @Name(value="bucket") String bucket, @Name(value="documentId") String documentId, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        try (CouchbaseConnection couchbaseConnection = this.getCouchbaseConnection(hostOrKey, bucket, config);){
            Stream<CouchbaseJsonDocument> stream = Stream.ofNullable(couchbaseConnection.get(documentId));
            return stream;
        }
    }

    @Procedure
    @Description(value="apoc.couchbase.exists(hostOrKey, bucket, documentId, config) yield value - check whether a couchbase json document with the given ID does exist.")
    public Stream<BooleanResult> exists(@Name(value="hostOrKey") String hostOrKey, @Name(value="bucket") String bucket, @Name(value="documentId") String documentId, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        try (CouchbaseConnection couchbaseConnection = this.getCouchbaseConnection(hostOrKey, bucket, config);){
            Stream<BooleanResult> stream = Stream.ofNullable(new BooleanResult(couchbaseConnection.exists(documentId)));
            return stream;
        }
    }

    @Procedure
    @Description(value="apoc.couchbase.insert(hostOrKey, bucket, documentId, jsonDocument, config) yield id, expiry, cas, mutationToken, content - insert a couchbase json document with its unique ID.")
    public Stream<CouchbaseJsonDocument> insert(@Name(value="hostOrKey") String hostOrKey, @Name(value="bucket") String bucket, @Name(value="documentId") String documentId, @Name(value="json") String json, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        try (CouchbaseConnection couchbaseConnection = this.getCouchbaseConnection(hostOrKey, bucket, config);){
            Stream<CouchbaseJsonDocument> stream = Stream.ofNullable(couchbaseConnection.insert(documentId, json));
            return stream;
        }
    }

    @Procedure
    @Description(value="apoc.couchbase.upsert(hostOrKey, bucket, documentId, jsonDocument) yield id, expiry, cas, mutationToken, content - insert or overwrite a couchbase json document with its unique ID.")
    public Stream<CouchbaseJsonDocument> upsert(@Name(value="hostOrKey") String hostOrKey, @Name(value="bucket") String bucket, @Name(value="documentId") String documentId, @Name(value="json") String json, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        try (CouchbaseConnection couchbaseConnection = this.getCouchbaseConnection(hostOrKey, bucket, config);){
            Stream<CouchbaseJsonDocument> stream = Stream.ofNullable(couchbaseConnection.upsert(documentId, json));
            return stream;
        }
    }

    @Procedure
    @Description(value="apoc.couchbase.append(hostOrKey, bucket, documentId, content, config) yield id, expiry, cas, mutationToken, content - append a couchbase json document to an existing one.")
    public Stream<CouchbaseByteArrayDocument> append(@Name(value="hostOrKey") String hostOrKey, @Name(value="bucket") String bucket, @Name(value="documentId") String documentId, @Name(value="content") byte[] content, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        try (CouchbaseConnection couchbaseConnection = this.getCouchbaseConnection(hostOrKey, bucket, config);){
            Stream<CouchbaseByteArrayDocument> stream = Stream.ofNullable(couchbaseConnection.append(documentId, content));
            return stream;
        }
    }

    @Procedure
    @Description(value="apoc.couchbase.prepend(hostOrKey, bucket, documentId, content, config) yield id, expiry, cas, mutationToken, content - prepend a couchbase json document to an existing one.")
    public Stream<CouchbaseByteArrayDocument> prepend(@Name(value="hostOrKey") String hostOrKey, @Name(value="bucket") String bucket, @Name(value="documentId") String documentId, @Name(value="content") byte[] content, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        try (CouchbaseConnection couchbaseConnection = this.getCouchbaseConnection(hostOrKey, bucket, config);){
            Stream<CouchbaseByteArrayDocument> stream = Stream.ofNullable(couchbaseConnection.prepend(documentId, content));
            return stream;
        }
    }

    @Procedure
    @Description(value="apoc.couchbase.remove(hostOrKey, bucket, documentId, config) yield id, expiry, cas, mutationToken, content - remove the couchbase json document identified by its unique ID.")
    public Stream<CouchbaseJsonDocument> remove(@Name(value="hostOrKey") String hostOrKey, @Name(value="bucket") String bucket, @Name(value="documentId") String documentId, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        try (CouchbaseConnection couchbaseConnection = this.getCouchbaseConnection(hostOrKey, bucket, config);){
            Stream<CouchbaseJsonDocument> stream = Stream.ofNullable(couchbaseConnection.remove(documentId));
            return stream;
        }
    }

    @Procedure
    @Description(value="apoc.couchbase.replace(hostOrKey, bucket, documentId, jsonDocument, config) yield id, expiry, cas, mutationToken, content - replace the content of the couchbase json document identified by its unique ID.")
    public Stream<CouchbaseJsonDocument> replace(@Name(value="hostOrKey") String hostOrKey, @Name(value="bucket") String bucket, @Name(value="documentId") String documentId, @Name(value="json") String json, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        try (CouchbaseConnection couchbaseConnection = this.getCouchbaseConnection(hostOrKey, bucket, config);){
            Stream<CouchbaseJsonDocument> stream = Stream.ofNullable(couchbaseConnection.replace(documentId, json));
            return stream;
        }
    }

    @Procedure
    @Description(value="apoc.couchbase.query(hostOrKey, bucket, statement, config) yield queryResult - executes a plain un-parameterized N1QL statement.")
    public Stream<CouchbaseQueryResult> query(@Name(value="hostOrKey") String hostOrKey, @Name(value="bucket") String bucket, @Name(value="statement") String statement, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        try (CouchbaseConnection couchbaseConnection = this.getCouchbaseConnection(hostOrKey, bucket, config);){
            Stream<CouchbaseQueryResult> stream = Stream.ofNullable(couchbaseConnection.executeStatement(statement));
            return stream;
        }
    }

    @Procedure
    @Description(value="apoc.couchbase.posParamsQuery(hostOrKey, bucket, statement, params, config) yield queryResult - executes a N1QL statement with positional parameters.")
    public Stream<CouchbaseQueryResult> posParamsQuery(@Name(value="hostOrKey") String hostOrKey, @Name(value="bucket") String bucket, @Name(value="statement") String statement, @Name(value="params") List<Object> params, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        try (CouchbaseConnection couchbaseConnection = this.getCouchbaseConnection(hostOrKey, bucket, config);){
            CouchbaseQueryResult result = couchbaseConnection.executeParameterizedStatement(statement, params);
            Stream<CouchbaseQueryResult> stream = Stream.ofNullable(result);
            return stream;
        }
    }

    @Procedure
    @Description(value="apoc.couchbase.namedParamsQuery(hostkOrKey, bucket, statement, paramNames, paramValues, config) yield queryResult - executes a N1QL statement with named parameters.")
    public Stream<CouchbaseQueryResult> namedParamsQuery(@Name(value="hostOrKey") String hostOrKey, @Name(value="bucket") String bucket, @Name(value="statement") String statement, @Name(value="paramNames") List<String> paramNames, @Name(value="paramValues") List<Object> paramValues, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        try (CouchbaseConnection couchbaseConnection = this.getCouchbaseConnection(hostOrKey, bucket, config);){
            CouchbaseQueryResult result = couchbaseConnection.executeParameterizedStatement(statement, paramNames, paramValues);
            Stream<CouchbaseQueryResult> stream = Stream.ofNullable(result);
            return stream;
        }
    }

    private CouchbaseConnection getCouchbaseConnection(String hostOrKey, String bucket, Map<String, Object> configMap) {
        try {
            CouchbaseConfig config = new CouchbaseConfig(configMap);
            return CouchbaseManager.getConnection(hostOrKey, bucket, config);
        }
        catch (NoClassDefFoundError e) {
            throw new MissingDependencyException(COUCHBASE_MISSING_DEPS_ERROR);
        }
    }
}

