/*
 * Decompiled with CFR 0.152.
 */
package apoc.agg;

import apoc.Extended;
import apoc.agg.AggregationUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.neo4j.graphdb.Entity;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.UserAggregationFunction;
import org.neo4j.procedure.UserAggregationResult;
import org.neo4j.procedure.UserAggregationUpdate;

@Extended
public class MultiStats {
    @UserAggregationFunction(value="apoc.agg.multiStats")
    @Description(value="Return a multi-dimensional aggregation")
    public MultiStatsFunction multiStats() {
        return new MultiStatsFunction();
    }

    public static class MultiStatsFunction {
        private final Map<String, Map<String, Map<String, Number>>> result = new HashMap<String, Map<String, Map<String, Number>>>();

        @UserAggregationUpdate
        public void aggregate(@Name(value="value") Object value, @Name(value="keys") List<String> keys) {
            Entity entity = (Entity)value;
            keys.forEach(key -> {
                if (entity.hasProperty(key)) {
                    Object property = entity.getProperty(key);
                    this.result.compute((String)key, (ignored, v) -> {
                        Map map = Objects.requireNonNullElseGet(v, HashMap::new);
                        map.compute(property.toString(), (propKey, propVal) -> {
                            Map propMap = Objects.requireNonNullElseGet(propVal, HashMap::new);
                            String countKey = "count";
                            String sumKey = "sum";
                            String avgKey = "avg";
                            AggregationUtil.updateAggregationValues(propMap, property, countKey, sumKey, avgKey);
                            return propMap;
                        });
                        return map;
                    });
                }
            });
        }

        @UserAggregationResult
        public Map<String, Map<String, Map<String, Number>>> result() {
            return this.result;
        }
    }
}

