/*
 * Decompiled with CFR 0.152.
 */
package apoc;

import apoc.ApocConfig;
import apoc.util.SimpleRateLimiter;
import java.io.File;
import java.time.Duration;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.configuration2.CombinedConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.EnvironmentConfiguration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.SystemConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.ex.ConversionException;
import org.apache.commons.configuration2.io.FileBased;
import org.apache.commons.configuration2.io.FileHandler;
import org.apache.commons.configuration2.tree.NodeCombiner;
import org.apache.commons.configuration2.tree.OverrideCombiner;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.logging.internal.LogService;

public class ExtendedApocConfig
extends LifecycleAdapter {
    public static final String APOC_TTL_SCHEDULE = "apoc.ttl.schedule";
    public static final String APOC_TTL_ENABLED = "apoc.ttl.enabled";
    public static final String APOC_TTL_LIMIT = "apoc.ttl.limit";
    public static final String APOC_TTL_SCHEDULE_DB = "apoc.ttl.schedule.%s";
    public static final String APOC_TTL_ENABLED_DB = "apoc.ttl.enabled.%s";
    public static final String APOC_TTL_LIMIT_DB = "apoc.ttl.limit.%s";
    public static final String APOC_UUID_ENABLED = "apoc.uuid.enabled";
    public static final String APOC_UUID_ENABLED_DB = "apoc.uuid.enabled.%s";
    public static final String APOC_UUID_FORMAT = "apoc.uuid.format";
    public static final String APOC_OPENAI_KEY = "apoc.openai.key";
    public static final String APOC_ML_OPENAI_URL = "apoc.ml.openai.url";
    public static final String APOC_ML_OPENAI_TYPE = "apoc.ml.openai.type";
    public static final String APOC_ML_OPENAI_AZURE_VERSION = "apoc.ml.azure.api.version";
    public static final String APOC_ML_VERTEXAI_URL = "apoc.ml.vertexai.url";
    public static final String APOC_ML_WATSON_PROJECT_ID = "apoc.ml.watson.project.id";
    public static final String APOC_ML_WATSON_URL = "apoc.ml.watson.url";
    public static final String APOC_AWS_KEY_ID = "apoc.aws.key.id";
    public static final String APOC_AWS_SECRET_KEY = "apoc.aws.secret.key";
    private static final Map<String, Object> configDefaultValues = Map.of("apoc.ttl.schedule", Duration.ofMinutes(1L), "apoc.ttl.enabled", false, "apoc.ttl.limit", 1000L, "apoc.uuid.enabled", false);
    private final Log log;
    private final String defaultConfigPath;
    private Configuration config;
    private static ExtendedApocConfig theInstance;
    private LoggingType loggingType;
    private SimpleRateLimiter rateLimiter;
    private boolean initialized = false;
    public static final String CONFIG_DIR = "config-dir=";

    public ExtendedApocConfig(LogService log, GlobalProcedures globalProceduresRegistry, String defaultConfigPath) {
        this.log = log.getInternalLog(ApocConfig.class);
        this.defaultConfigPath = defaultConfigPath;
        theInstance = this;
        globalProceduresRegistry.registerComponent(((Object)((Object)this)).getClass(), ctx -> this, true);
        this.log.info("successfully registered ExtendedApocConfig for @Context");
    }

    public void init() {
        this.log.debug("called init");
        String neo4jConfFolder = System.getenv().getOrDefault("NEO4J_CONF", this.determineNeo4jConfFolder());
        System.setProperty("NEO4J_CONF", neo4jConfFolder);
        this.log.info("system property NEO4J_CONF set to %s", new Object[]{neo4jConfFolder});
        File apocConfFile = new File(neo4jConfFolder + "/apoc.conf");
        this.loadConfiguration(apocConfFile);
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    protected String determineNeo4jConfFolder() {
        String command = System.getProperty("sun.java.command");
        if (command == null) {
            this.log.warn("system property %s is not set, assuming %s as conf dir. This might cause `apoc.conf` not getting loaded.", new Object[]{"sun.java.command", this.defaultConfigPath});
            return this.defaultConfigPath;
        }
        String neo4jConfFolder = Stream.of(command.split("--")).map(String::trim).filter(s -> s.startsWith(CONFIG_DIR)).map(s -> s.substring(CONFIG_DIR.length())).findFirst().orElse(this.defaultConfigPath);
        if (this.defaultConfigPath.equals(neo4jConfFolder)) {
            this.log.info("cannot determine conf folder from sys property %s, assuming %s", new Object[]{command, this.defaultConfigPath});
        } else {
            this.log.info("from system properties: NEO4J_CONF=%s", new Object[]{neo4jConfFolder});
        }
        return neo4jConfFolder;
    }

    protected void loadConfiguration(File apocConfFile) {
        try {
            this.config = ExtendedApocConfig.setupConfigurations(apocConfFile);
            configDefaultValues.forEach((k, v) -> {
                if (!this.config.containsKey(k)) {
                    this.config.setProperty(k, v);
                    this.log.info("setting APOC config to default value: " + k + "=" + v);
                }
            });
            this.initLogging();
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    private static Configuration setupConfigurations(File propertyFile) throws ConfigurationException {
        PropertiesConfiguration configFile = new PropertiesConfiguration();
        if (propertyFile.exists()) {
            FileHandler handler = new FileHandler((FileBased)configFile);
            handler.setFile(propertyFile);
            handler.load();
        }
        CombinedConfiguration combined = new CombinedConfiguration();
        combined.setNodeCombiner((NodeCombiner)new OverrideCombiner());
        combined.addConfiguration((Configuration)new EnvironmentConfiguration());
        combined.addConfiguration((Configuration)new SystemConfiguration());
        combined.addConfiguration((Configuration)configFile);
        return combined;
    }

    protected Configuration getConfig() {
        return this.config;
    }

    public LoggingType getLoggingType() {
        return this.loggingType;
    }

    public SimpleRateLimiter getRateLimiter() {
        return this.rateLimiter;
    }

    public void setLoggingType(LoggingType loggingType) {
        this.loggingType = loggingType;
    }

    public void setRateLimiter(SimpleRateLimiter rateLimiter) {
        this.rateLimiter = rateLimiter;
    }

    private void initLogging() {
        this.loggingType = LoggingType.valueOf(this.config.getString("apoc.user.log.type", "safe").trim());
        this.rateLimiter = new SimpleRateLimiter(this.getInt("apoc.user.log.window.time", 10000), this.getInt("apoc.user.log.window.ops", 10));
    }

    public static ExtendedApocConfig extendedApocConfig() {
        return theInstance;
    }

    public Iterator<String> getKeys(String prefix) {
        return this.config.getKeys(prefix);
    }

    public boolean containsKey(String key) {
        return this.config.containsKey(key);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return this.getConfig().getBoolean(key, defaultValue);
    }

    public String getString(String key, String defaultValue) {
        return this.getConfig().getString(key, defaultValue);
    }

    public <T extends Enum<T>> T getEnumProperty(String key, Class<T> cls, T defaultValue) {
        String value = this.config.getString(key, defaultValue.toString()).trim();
        try {
            return Enum.valueOf(cls, value);
        }
        catch (IllegalArgumentException e) {
            this.log.error("Wrong value '{}' for parameter '{}' is provided. Default value is used: '{}'", new Object[]{value, key, defaultValue});
            return defaultValue;
        }
    }

    private int getInt(String key, int defaultValue) {
        try {
            return this.config.getInt(key, defaultValue);
        }
        catch (ConversionException e) {
            Object o = this.config.getProperty(key);
            if (o instanceof Duration) {
                return (int)((Duration)o).getSeconds();
            }
            throw new IllegalArgumentException("don't know how to convert for config option " + key, e);
        }
    }

    public static enum LoggingType {
        none,
        safe,
        raw;

    }

    public static enum UuidFormatType {
        hex,
        base64;

    }
}

