/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.frontend.v3_4.ast;

import org.neo4j.cypher.internal.frontend.v3_4.ast.AstConstructionTestSupport;
import org.neo4j.cypher.internal.frontend.v3_4.ast.AstConstructionTestSupport$class;
import org.neo4j.cypher.internal.frontend.v3_4.ast.BoundGraphAs;
import org.neo4j.cypher.internal.frontend.v3_4.ast.GraphReturnItem;
import org.neo4j.cypher.internal.frontend.v3_4.ast.GraphReturnItems;
import org.neo4j.cypher.internal.frontend.v3_4.ast.GraphUrl;
import org.neo4j.cypher.internal.frontend.v3_4.ast.NewContextGraphs;
import org.neo4j.cypher.internal.frontend.v3_4.ast.NewTargetGraph;
import org.neo4j.cypher.internal.frontend.v3_4.ast.ReturnedGraph;
import org.neo4j.cypher.internal.frontend.v3_4.ast.SingleGraphAs;
import org.neo4j.cypher.internal.frontend.v3_4.semantics.Scope$;
import org.neo4j.cypher.internal.frontend.v3_4.semantics.SemanticCheckResult;
import org.neo4j.cypher.internal.frontend.v3_4.semantics.SemanticErrorDef;
import org.neo4j.cypher.internal.frontend.v3_4.semantics.SemanticFeature;
import org.neo4j.cypher.internal.frontend.v3_4.semantics.SemanticState$;
import org.neo4j.cypher.internal.util.v3_4.InputPosition;
import org.neo4j.cypher.internal.util.v3_4.test_helpers.CypherFunSuite;
import org.neo4j.cypher.internal.v3_4.expressions.DecimalDoubleLiteral;
import org.neo4j.cypher.internal.v3_4.expressions.Equals;
import org.neo4j.cypher.internal.v3_4.expressions.Expression;
import org.neo4j.cypher.internal.v3_4.expressions.HasLabels;
import org.neo4j.cypher.internal.v3_4.expressions.LabelName;
import org.neo4j.cypher.internal.v3_4.expressions.LessThan;
import org.neo4j.cypher.internal.v3_4.expressions.ListLiteral;
import org.neo4j.cypher.internal.v3_4.expressions.MapExpression;
import org.neo4j.cypher.internal.v3_4.expressions.Property;
import org.neo4j.cypher.internal.v3_4.expressions.SignedDecimalIntegerLiteral;
import org.neo4j.cypher.internal.v3_4.expressions.Variable;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001]2A!\u0001\u0002\u0001#\t!rI]1qQJ+G/\u001e:o\u0013R,Wn\u001d+fgRT!a\u0001\u0003\u0002\u0007\u0005\u001cHO\u0003\u0002\u0006\r\u0005!aoM05\u0015\t9\u0001\"\u0001\u0005ge>tG/\u001a8e\u0015\tI!\"\u0001\u0005j]R,'O\\1m\u0015\tYA\"\u0001\u0004dsBDWM\u001d\u0006\u0003\u001b9\tQA\\3pi)T\u0011aD\u0001\u0004_J<7\u0001A\n\u0004\u0001IY\u0002CA\n\u001a\u001b\u0005!\"BA\u000b\u0017\u00031!Xm\u001d;`Q\u0016d\u0007/\u001a:t\u0015\t)qC\u0003\u0002\u0019\u0011\u0005!Q\u000f^5m\u0013\tQBC\u0001\bDsBDWM\u001d$v]N+\u0018\u000e^3\u0011\u0005qiR\"\u0001\u0002\n\u0005y\u0011!AG!ti\u000e{gn\u001d;sk\u000e$\u0018n\u001c8UKN$8+\u001e9q_J$\b\"\u0002\u0011\u0001\t\u0003\t\u0013A\u0002\u001fj]&$h\bF\u0001#!\ta\u0002\u0001C\u0004%\u0001\t\u0007I\u0011A\u0013\u0002\u0007\u0019|w.F\u0001'!\tar%\u0003\u0002)\u0005\ta!i\\;oI\u001e\u0013\u0018\r\u001d5Bg\"1!\u0006\u0001Q\u0001\n\u0019\nAAZ8pA!9A\u0006\u0001b\u0001\n\u0003)\u0013a\u00012be\"1a\u0006\u0001Q\u0001\n\u0019\nAAY1sA!9\u0001\u0007\u0001b\u0001\n\u0003)\u0013a\u00012bu\"1!\u0007\u0001Q\u0001\n\u0019\nAAY1{A!9A\u0007\u0001b\u0001\n\u0003)\u0013\u0001B7pKBDaA\u000e\u0001!\u0002\u00131\u0013!B7pKB\u0004\u0003")
public class GraphReturnItemsTest
extends CypherFunSuite
implements AstConstructionTestSupport {
    private final BoundGraphAs foo;
    private final BoundGraphAs bar;
    private final BoundGraphAs baz;
    private final BoundGraphAs moep;
    private final InputPosition pos;

    @Override
    public InputPosition pos() {
        return this.pos;
    }

    @Override
    public void org$neo4j$cypher$internal$frontend$v3_4$ast$AstConstructionTestSupport$_setter_$pos_$eq(InputPosition x$1) {
        this.pos = x$1;
    }

    @Override
    public <T> T withPos(Function1<InputPosition, T> expr) {
        return (T)AstConstructionTestSupport$class.withPos(this, expr);
    }

    @Override
    public Variable varFor(String name) {
        return AstConstructionTestSupport$class.varFor(this, name);
    }

    @Override
    public LabelName lblName(String s) {
        return AstConstructionTestSupport$class.lblName(this, s);
    }

    @Override
    public HasLabels hasLabels(String v, String label) {
        return AstConstructionTestSupport$class.hasLabels(this, v, label);
    }

    @Override
    public Property prop(String variable, String propKey) {
        return AstConstructionTestSupport$class.prop(this, variable, propKey);
    }

    @Override
    public Equals propEquality(String variable, String propKey, int intValue) {
        return AstConstructionTestSupport$class.propEquality(this, variable, propKey, intValue);
    }

    @Override
    public LessThan propLessThan(String variable, String propKey, int intValue) {
        return AstConstructionTestSupport$class.propLessThan(this, variable, propKey, intValue);
    }

    @Override
    public SignedDecimalIntegerLiteral literalInt(int intValue) {
        return AstConstructionTestSupport$class.literalInt(this, intValue);
    }

    @Override
    public DecimalDoubleLiteral literalFloat(double floatValue) {
        return AstConstructionTestSupport$class.literalFloat(this, floatValue);
    }

    @Override
    public ListLiteral literalList(Seq<Expression> expressions) {
        return AstConstructionTestSupport$class.literalList(this, expressions);
    }

    @Override
    public ListLiteral literalIntList(Seq<Object> intValues) {
        return AstConstructionTestSupport$class.literalIntList(this, intValues);
    }

    @Override
    public ListLiteral literalFloatList(Seq<Object> floatValues) {
        return AstConstructionTestSupport$class.literalFloatList(this, floatValues);
    }

    @Override
    public MapExpression literalIntMap(Seq<Tuple2<String, Object>> keyValues) {
        return AstConstructionTestSupport$class.literalIntMap(this, keyValues);
    }

    @Override
    public ListLiteral listOf(Seq<Expression> expressions) {
        return AstConstructionTestSupport$class.listOf(this, expressions);
    }

    @Override
    public Expression TRUE() {
        return AstConstructionTestSupport$class.TRUE(this);
    }

    @Override
    public GraphUrl url(String addr) {
        return AstConstructionTestSupport$class.url(this, addr);
    }

    @Override
    public BoundGraphAs graph(String name) {
        return AstConstructionTestSupport$class.graph(this, name);
    }

    @Override
    public BoundGraphAs graphAs(String name, String alias) {
        return AstConstructionTestSupport$class.graphAs(this, name, alias);
    }

    @Override
    public SingleGraphAs graphAt(String name, String address) {
        return AstConstructionTestSupport$class.graphAt(this, name, address);
    }

    public BoundGraphAs foo() {
        return this.foo;
    }

    public BoundGraphAs bar() {
        return this.bar;
    }

    public BoundGraphAs baz() {
        return this.baz;
    }

    public BoundGraphAs moep() {
        return this.moep;
    }

    public GraphReturnItemsTest() {
        AstConstructionTestSupport$class.$init$(this);
        this.foo = this.graph("foo");
        this.bar = this.graph("bar");
        this.baz = this.graph("baz");
        this.moep = this.graph("moep");
        this.test("set correct source and target", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GraphReturnItemsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                GraphReturnItems items = new GraphReturnItems(false, (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GraphReturnItem[]{new ReturnedGraph((SingleGraphAs)this.$outer.baz(), this.$outer.pos()), new NewContextGraphs((SingleGraphAs)this.$outer.foo(), (Option)new Some((Object)this.$outer.bar()), this.$outer.pos()), new ReturnedGraph((SingleGraphAs)this.$outer.moep(), this.$outer.pos())})), this.$outer.pos());
                this.$outer.convertToAnyShouldWrapper(items.newSource()).should(this.$outer.equal(new Some((Object)this.$outer.foo())), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(items.newTarget()).should(this.$outer.equal(new Some((Object)this.$outer.bar())), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("set correct source graph", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GraphReturnItemsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                GraphReturnItems items = new GraphReturnItems(false, (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GraphReturnItem[]{new ReturnedGraph((SingleGraphAs)this.$outer.baz(), this.$outer.pos()), new NewContextGraphs((SingleGraphAs)this.$outer.foo(), (Option)None$.MODULE$, this.$outer.pos()), new ReturnedGraph((SingleGraphAs)this.$outer.moep(), this.$outer.pos())})), this.$outer.pos());
                this.$outer.convertToAnyShouldWrapper(items.newSource()).should(this.$outer.equal(new Some((Object)this.$outer.foo())), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(items.newTarget()).should(this.$outer.equal(new Some((Object)this.$outer.foo())), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("set correct target graph after setting source graph only", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GraphReturnItemsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                GraphReturnItems items = new GraphReturnItems(false, (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GraphReturnItem[]{new ReturnedGraph((SingleGraphAs)this.$outer.baz(), this.$outer.pos()), new NewContextGraphs((SingleGraphAs)this.$outer.foo(), (Option)None$.MODULE$, this.$outer.pos()), new NewTargetGraph((SingleGraphAs)this.$outer.bar(), this.$outer.pos()), new ReturnedGraph((SingleGraphAs)this.$outer.moep(), this.$outer.pos())})), this.$outer.pos());
                this.$outer.convertToAnyShouldWrapper(items.newSource()).should(this.$outer.equal(new Some((Object)this.$outer.foo())), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(items.newTarget()).should(this.$outer.equal(new Some((Object)this.$outer.bar())), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("allow only setting one new source", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GraphReturnItemsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                GraphReturnItems items = new GraphReturnItems(false, (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewContextGraphs[]{new NewContextGraphs((SingleGraphAs)this.$outer.foo(), (Option)new Some((Object)this.$outer.bar()), this.$outer.pos()), new NewContextGraphs((SingleGraphAs)this.$outer.baz(), (Option)None$.MODULE$, this.$outer.pos())})), this.$outer.pos());
                SemanticCheckResult result = (SemanticCheckResult)items.semanticCheck().apply((Object)SemanticState$.MODULE$.clean().withFeatures((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SemanticFeature[]{SemanticFeature.MultipleGraphs$.MODULE$})));
                Set errors = result.errors().toSet();
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)errors.exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(SemanticErrorDef x$1) {
                        return x$1.msg().contains("Setting multiple source graphs is not allowed");
                    }
                }))).should(this.$outer.be().apply(true));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("allow only setting one new target", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GraphReturnItemsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                GraphReturnItems items = new GraphReturnItems(false, (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTargetGraph[]{new NewTargetGraph((SingleGraphAs)this.$outer.foo(), this.$outer.pos()), new NewTargetGraph((SingleGraphAs)this.$outer.bar(), this.$outer.pos())})), this.$outer.pos());
                SemanticCheckResult result = (SemanticCheckResult)items.semanticCheck().apply((Object)SemanticState$.MODULE$.clean().withFeatures((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SemanticFeature[]{SemanticFeature.MultipleGraphs$.MODULE$})));
                Set errors = result.errors().toSet();
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)errors.exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(SemanticErrorDef x$2) {
                        return x$2.msg().contains("Setting multiple target graphs is not allowed");
                    }
                }))).should(this.$outer.be().apply(true));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("set correct source and target from single graph", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GraphReturnItemsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                GraphReturnItems items = new GraphReturnItems(false, (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnedGraph[]{new ReturnedGraph((SingleGraphAs)this.$outer.baz(), this.$outer.pos())})), this.$outer.pos());
                this.$outer.convertToAnyShouldWrapper(items.newSource()).should(this.$outer.equal(new Some((Object)this.$outer.baz())), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(items.newTarget()).should(this.$outer.equal(new Some((Object)this.$outer.baz())), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("set correct source and target from single source", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GraphReturnItemsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                GraphReturnItems items = new GraphReturnItems(false, (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewContextGraphs[]{new NewContextGraphs((SingleGraphAs)this.$outer.baz(), (Option)new Some((Object)this.$outer.baz()), this.$outer.pos())})), this.$outer.pos());
                this.$outer.convertToAnyShouldWrapper(items.newSource()).should(this.$outer.equal(new Some((Object)this.$outer.baz())), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(items.newTarget()).should(this.$outer.equal(new Some((Object)this.$outer.baz())), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("set correct source and target from single target", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GraphReturnItemsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                GraphReturnItems items = new GraphReturnItems(false, (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTargetGraph[]{new NewTargetGraph((SingleGraphAs)this.$outer.baz(), this.$outer.pos())})), this.$outer.pos());
                this.$outer.convertToAnyShouldWrapper(items.newSource()).should(this.$outer.equal(new Some((Object)this.$outer.baz())), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(items.newTarget()).should(this.$outer.equal(new Some((Object)this.$outer.baz())), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("disallow declaring variable multiple times", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GraphReturnItemsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                GraphReturnItems items = new GraphReturnItems(false, (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnedGraph[]{new ReturnedGraph(this.$outer.graphAt("foo", "url"), this.$outer.pos()), new ReturnedGraph(this.$outer.graphAt("foo", "url2"), this.$outer.pos())})), this.$outer.pos());
                SemanticCheckResult result = (SemanticCheckResult)items.declareGraphs(Scope$.MODULE$.empty(), false).apply((Object)SemanticState$.MODULE$.clean().withFeatures((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SemanticFeature[]{SemanticFeature.MultipleGraphs$.MODULE$})));
                Set errors = result.errors().toSet();
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)errors.exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(SemanticErrorDef x$3) {
                        return x$3.msg().contains("Graph `foo` already declared");
                    }
                }))).should(this.$outer.be().apply(true));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("disallow multiple result graphs with same name", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GraphReturnItemsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                GraphReturnItems items = new GraphReturnItems(false, (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnedGraph[]{new ReturnedGraph(this.$outer.graphAt("foo", "url"), this.$outer.pos()), new ReturnedGraph((SingleGraphAs)this.$outer.graphAs("foo", "foo"), this.$outer.pos())})), this.$outer.pos());
                SemanticCheckResult result = (SemanticCheckResult)items.semanticCheck().apply((Object)SemanticState$.MODULE$.clean().withFeatures((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SemanticFeature[]{SemanticFeature.MultipleGraphs$.MODULE$})));
                Set errors = result.errors().toSet();
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)errors.exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(SemanticErrorDef x$4) {
                        return x$4.msg().contains("Multiple result graphs with the same name are not supported");
                    }
                }))).should(this.$outer.be().apply(true));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

