/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.frontend.v3_4.semantics;

import org.neo4j.cypher.internal.frontend.v3_4.semantics.SemanticCheckResult;
import org.neo4j.cypher.internal.frontend.v3_4.semantics.SemanticError;
import org.neo4j.cypher.internal.frontend.v3_4.semantics.SemanticExpressionCheck$;
import org.neo4j.cypher.internal.frontend.v3_4.semantics.SemanticFunSuite;
import org.neo4j.cypher.internal.frontend.v3_4.semantics.SemanticState$;
import org.neo4j.cypher.internal.util.v3_4.DummyPosition$;
import org.neo4j.cypher.internal.util.v3_4.InputPosition;
import org.neo4j.cypher.internal.util.v3_4.symbols.CypherType;
import org.neo4j.cypher.internal.util.v3_4.symbols.package$;
import org.neo4j.cypher.internal.v3_4.expressions.DummyExpression;
import org.neo4j.cypher.internal.v3_4.expressions.DummyExpression$;
import org.neo4j.cypher.internal.v3_4.expressions.Expression;
import org.neo4j.cypher.internal.v3_4.expressions.ExtractExpression;
import org.neo4j.cypher.internal.v3_4.expressions.ExtractExpression$;
import org.neo4j.cypher.internal.v3_4.expressions.True;
import org.neo4j.cypher.internal.v3_4.expressions.Variable;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import org.scalatest.enablers.Emptiness$;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001)2A!\u0001\u0002\u0001#\ti2+Z7b]RL7-\u0012=ue\u0006\u001cG/\u0012=qe\u0016\u001c8/[8o)\u0016\u001cHO\u0003\u0002\u0004\t\u0005I1/Z7b]RL7m\u001d\u0006\u0003\u000b\u0019\tAA^\u001a`i)\u0011q\u0001C\u0001\tMJ|g\u000e^3oI*\u0011\u0011BC\u0001\tS:$XM\u001d8bY*\u00111\u0002D\u0001\u0007Gf\u0004\b.\u001a:\u000b\u00055q\u0011!\u00028f_RR'\"A\b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0011\u0002CA\n\u0015\u001b\u0005\u0011\u0011BA\u000b\u0003\u0005A\u0019V-\\1oi&\u001cg)\u001e8Tk&$X\rC\u0003\u0018\u0001\u0011\u0005\u0001$\u0001\u0004=S:LGO\u0010\u000b\u00023A\u00111\u0003\u0001\u0005\b7\u0001\u0011\r\u0011\"\u0001\u001d\u0003=!W/\\7z\u000bb\u0004(/Z:tS>tW#A\u000f\u0011\u0005y\u0011S\"A\u0010\u000b\u0005\u0001\n\u0013aC3yaJ,7o]5p]NT!!\u0002\u0005\n\u0005\rz\"a\u0004#v[6LX\t\u001f9sKN\u001c\u0018n\u001c8\t\r\u0015\u0002\u0001\u0015!\u0003\u001e\u0003A!W/\\7z\u000bb\u0004(/Z:tS>t\u0007\u0005C\u0004(\u0001\t\u0007I\u0011\u0001\u000f\u0002#\u0015DHO]1di\u0016C\bO]3tg&|g\u000e\u0003\u0004*\u0001\u0001\u0006I!H\u0001\u0013Kb$(/Y2u\u000bb\u0004(/Z:tS>t\u0007\u0005")
public class SemanticExtractExpressionTest
extends SemanticFunSuite {
    private final DummyExpression dummyExpression = new DummyExpression(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTNode())).$bar(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTBoolean())).$bar(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTString()))), DummyExpression$.MODULE$.apply$default$2());
    private final DummyExpression extractExpression = new DummyExpression(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTNode()).$bar(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTNumber())), DummyPosition$.MODULE$.apply(2));

    public DummyExpression dummyExpression() {
        return this.dummyExpression;
    }

    public DummyExpression extractExpression() {
        return this.extractExpression;
    }

    public SemanticExtractExpressionTest() {
        this.test("shouldHaveCollectionWithInnerTypesOfExtractExpression", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticExtractExpressionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExtractExpression extract = ExtractExpression$.MODULE$.apply(new Variable("x", DummyPosition$.MODULE$.apply(5)), (Expression)this.$outer.dummyExpression(), (Option)None$.MODULE$, (Option)new Some((Object)this.$outer.extractExpression()), DummyPosition$.MODULE$.apply(0));
                SemanticCheckResult result = (SemanticCheckResult)SemanticExpressionCheck$.MODULE$.simple((Expression)extract).apply((Object)SemanticState$.MODULE$.clean());
                this.$outer.convertToAnyShouldWrapper(result.errors()).shouldBe(this.$outer.empty(), Emptiness$.MODULE$.emptinessOfGenTraversable());
                this.$outer.convertToAnyShouldWrapper(this.$outer.types((Expression)extract).apply((Object)result.state())).should(this.$outer.equal(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTNode())).$bar(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTNumber())))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldRaiseSemanticErrorIfPredicateSpecified", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticExtractExpressionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExtractExpression extract = ExtractExpression$.MODULE$.apply(new Variable("x", DummyPosition$.MODULE$.apply(5)), (Expression)this.$outer.dummyExpression(), (Option)new Some((Object)new True(DummyPosition$.MODULE$.apply(5))), (Option)new Some((Object)this.$outer.extractExpression()), DummyPosition$.MODULE$.apply(0));
                SemanticCheckResult result = (SemanticCheckResult)SemanticExpressionCheck$.MODULE$.simple((Expression)extract).apply((Object)SemanticState$.MODULE$.clean());
                this.$outer.convertToAnyShouldWrapper(result.errors()).should(this.$outer.equal(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SemanticError[]{new SemanticError("extract(...) should not contain a WHERE predicate", DummyPosition$.MODULE$.apply(0), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new InputPosition[0]))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldRaiseSemanticErrorIfMissingExtractExpression", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticExtractExpressionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExtractExpression extract = ExtractExpression$.MODULE$.apply(new Variable("x", DummyPosition$.MODULE$.apply(5)), (Expression)this.$outer.dummyExpression(), (Option)None$.MODULE$, (Option)None$.MODULE$, DummyPosition$.MODULE$.apply(0));
                SemanticCheckResult result = (SemanticCheckResult)SemanticExpressionCheck$.MODULE$.simple((Expression)extract).apply((Object)SemanticState$.MODULE$.clean());
                this.$outer.convertToAnyShouldWrapper(result.errors()).should(this.$outer.equal(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SemanticError[]{new SemanticError("extract(...) requires '| expression' (an extract expression)", DummyPosition$.MODULE$.apply(0), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new InputPosition[0]))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

