/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.frontend.v3_4.semantics;

import org.neo4j.cypher.internal.frontend.v3_4.semantics.SemanticCheckResult;
import org.neo4j.cypher.internal.frontend.v3_4.semantics.SemanticError;
import org.neo4j.cypher.internal.frontend.v3_4.semantics.SemanticExpressionCheck$;
import org.neo4j.cypher.internal.frontend.v3_4.semantics.SemanticFunSuite;
import org.neo4j.cypher.internal.frontend.v3_4.semantics.SemanticState$;
import org.neo4j.cypher.internal.util.v3_4.DummyPosition$;
import org.neo4j.cypher.internal.util.v3_4.InputPosition;
import org.neo4j.cypher.internal.util.v3_4.symbols.CypherType;
import org.neo4j.cypher.internal.util.v3_4.symbols.package$;
import org.neo4j.cypher.internal.v3_4.expressions.DecimalDoubleLiteral;
import org.neo4j.cypher.internal.v3_4.expressions.DummyExpression;
import org.neo4j.cypher.internal.v3_4.expressions.DummyExpression$;
import org.neo4j.cypher.internal.v3_4.expressions.Expression;
import org.neo4j.cypher.internal.v3_4.expressions.ListSlice;
import org.neo4j.cypher.internal.v3_4.expressions.SignedDecimalIntegerLiteral;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import org.scalatest.enablers.Emptiness$;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00192A!\u0001\u0002\u0001#\tiA*[:u'2L7-\u001a+fgRT!a\u0001\u0003\u0002\u0013M,W.\u00198uS\u000e\u001c(BA\u0003\u0007\u0003\u001118g\u0018\u001b\u000b\u0005\u001dA\u0011\u0001\u00034s_:$XM\u001c3\u000b\u0005%Q\u0011\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005-a\u0011AB2za\",'O\u0003\u0002\u000e\u001d\u0005)a.Z85U*\tq\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001%A\u00111\u0003F\u0007\u0002\u0005%\u0011QC\u0001\u0002\u0011'\u0016l\u0017M\u001c;jG\u001a+hnU;ji\u0016DQa\u0006\u0001\u0005\u0002a\ta\u0001P5oSRtD#A\r\u0011\u0005M\u0001\u0001bB\u000e\u0001\u0005\u0004%\t\u0001H\u0001\nIVlW.\u001f'jgR,\u0012!\b\t\u0003=\tj\u0011a\b\u0006\u0003A\u0005\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011Q\u0001C\u0005\u0003G}\u0011q\u0002R;n[f,\u0005\u0010\u001d:fgNLwN\u001c\u0005\u0007K\u0001\u0001\u000b\u0011B\u000f\u0002\u0015\u0011,X.\\=MSN$\b\u0005")
public class ListSliceTest
extends SemanticFunSuite {
    private final DummyExpression dummyList = new DummyExpression(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTNode())).$bar(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTNode())).$bar(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTString()))), DummyExpression$.MODULE$.apply$default$2());

    public DummyExpression dummyList() {
        return this.dummyList;
    }

    public ListSliceTest() {
        this.test("shouldReturnCollectionTypesOfExpression", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ListSliceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ListSlice slice = new ListSlice((Expression)this.$outer.dummyList(), (Option)new Some((Object)new SignedDecimalIntegerLiteral("1", DummyPosition$.MODULE$.apply(5))), (Option)new Some((Object)new SignedDecimalIntegerLiteral("2", DummyPosition$.MODULE$.apply(7))), DummyPosition$.MODULE$.apply(4));
                SemanticCheckResult result = (SemanticCheckResult)SemanticExpressionCheck$.MODULE$.simple((Expression)slice).apply((Object)SemanticState$.MODULE$.clean());
                this.$outer.convertToAnyShouldWrapper(result.errors()).shouldBe(this.$outer.empty(), Emptiness$.MODULE$.emptinessOfGenTraversable());
                this.$outer.convertToAnyShouldWrapper(this.$outer.types((Expression)slice).apply((Object)result.state())).should(this.$outer.equal(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTNode())).$bar(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTString())))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldRaiseErrorWhenNeitherFromOrTwoSpecified", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ListSliceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ListSlice slice = new ListSlice((Expression)this.$outer.dummyList(), (Option)None$.MODULE$, (Option)None$.MODULE$, DummyPosition$.MODULE$.apply(4));
                SemanticCheckResult result = (SemanticCheckResult)SemanticExpressionCheck$.MODULE$.simple((Expression)slice).apply((Object)SemanticState$.MODULE$.clean());
                this.$outer.convertToAnyShouldWrapper(result.errors()).should(this.$outer.equal(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SemanticError[]{new SemanticError("The start or end (or both) is required for a collection slice", slice.position(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new InputPosition[0]))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldRaiseErrorIfStartingFromFraction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ListSliceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DecimalDoubleLiteral to = new DecimalDoubleLiteral("1.3", DummyPosition$.MODULE$.apply(5));
                ListSlice slice = new ListSlice((Expression)this.$outer.dummyList(), (Option)None$.MODULE$, (Option)new Some((Object)to), DummyPosition$.MODULE$.apply(4));
                SemanticCheckResult result = (SemanticCheckResult)SemanticExpressionCheck$.MODULE$.simple((Expression)slice).apply((Object)SemanticState$.MODULE$.clean());
                this.$outer.convertToAnyShouldWrapper(result.errors()).should(this.$outer.equal(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SemanticError[]{new SemanticError("Type mismatch: expected Integer but was Float", to.position(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new InputPosition[0]))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

