/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.frontend.v3_4.semantics;

import org.neo4j.cypher.internal.frontend.v3_4.semantics.SemanticCheckResult;
import org.neo4j.cypher.internal.frontend.v3_4.semantics.SemanticErrorDef;
import org.neo4j.cypher.internal.frontend.v3_4.semantics.SemanticExpressionCheck$;
import org.neo4j.cypher.internal.frontend.v3_4.semantics.SemanticFunSuite;
import org.neo4j.cypher.internal.frontend.v3_4.semantics.SemanticState;
import org.neo4j.cypher.internal.frontend.v3_4.semantics.SemanticState$;
import org.neo4j.cypher.internal.util.v3_4.symbols.TypeSpec;
import org.neo4j.cypher.internal.v3_4.expressions.DummyExpression;
import org.neo4j.cypher.internal.v3_4.expressions.DummyExpression$;
import org.neo4j.cypher.internal.v3_4.expressions.Expression;
import org.scalactic.Equality$;
import org.scalatest.enablers.Emptiness$;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001i3Q!\u0001\u0002\u0002\u0002E\u0011q#\u00138gSb,\u0005\u0010\u001d:fgNLwN\u001c+fgR\u0014\u0015m]3\u000b\u0005\r!\u0011!C:f[\u0006tG/[2t\u0015\t)a!\u0001\u0003wg}#$BA\u0004\t\u0003!1'o\u001c8uK:$'BA\u0005\u000b\u0003!Ig\u000e^3s]\u0006d'BA\u0006\r\u0003\u0019\u0019\u0017\u0010\u001d5fe*\u0011QBD\u0001\u0006]\u0016|GG\u001b\u0006\u0002\u001f\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0005\t\u0003'Qi\u0011AA\u0005\u0003+\t\u0011\u0001cU3nC:$\u0018n\u0019$v]N+\u0018\u000e^3\t\u0011]\u0001!\u0011!Q\u0001\na\t1a\u0019;s!\u0015IBD\b\u0010\u001f\u001b\u0005Q\"\"A\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005uQ\"!\u0003$v]\u000e$\u0018n\u001c83!\ty2%D\u0001!\u0015\t\t#%A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0003\t\u0013\t!\u0003E\u0001\u0006FqB\u0014Xm]:j_:DQA\n\u0001\u0005\u0002\u001d\na\u0001P5oSRtDC\u0001\u0015*!\t\u0019\u0002\u0001C\u0003\u0018K\u0001\u0007\u0001\u0004C\u0003,\u0001\u0011EA&\u0001\buKN$h+\u00197jIRK\b/Z:\u0015\u00075bd\b\u0006\u0002/cA\u0011\u0011dL\u0005\u0003ai\u0011A!\u00168ji\")!G\u000ba\u0001g\u0005AQ\r\u001f9fGR,G\r\u0005\u00025u5\tQG\u0003\u00027o\u000591/_7c_2\u001c(BA\u00039\u0015\tI\u0004\"\u0001\u0003vi&d\u0017BA\u001e6\u0005!!\u0016\u0010]3Ta\u0016\u001c\u0007\"B\u001f+\u0001\u0004\u0019\u0014\u0001\u00037igRK\b/Z:\t\u000b}R\u0003\u0019A\u001a\u0002\u0011ID7\u000fV=qKNDQ!\u0011\u0001\u0005\u0012\t\u000ba\u0003^3ti&sg/\u00197jI\u0006\u0003\b\u000f\\5dCRLwN\u001c\u000b\u0004\u00076sEC\u0001\u0018E\u0011\u0015)\u0005\t1\u0001G\u0003\u001diWm]:bO\u0016\u0004\"a\u0012&\u000f\u0005eA\u0015BA%\u001b\u0003\u0019\u0001&/\u001a3fM&\u00111\n\u0014\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005%S\u0002\"B\u001fA\u0001\u0004\u0019\u0004\"B A\u0001\u0004\u0019\u0004\"\u0002)\u0001\t#\t\u0016!E3wC2,\u0018\r^3XSRDG+\u001f9fgR\u0019!\u000bW-\u0011\te\u0019VKH\u0005\u0003)j\u0011a\u0001V;qY\u0016\u0014\u0004CA\nW\u0013\t9&AA\nTK6\fg\u000e^5d\u0007\",7m\u001b*fgVdG\u000fC\u0003>\u001f\u0002\u00071\u0007C\u0003@\u001f\u0002\u00071\u0007")
public abstract class InfixExpressionTestBase
extends SemanticFunSuite {
    private final Function2<Expression, Expression, Expression> ctr;

    public void testValidTypes(TypeSpec lhsTypes, TypeSpec rhsTypes, TypeSpec expected) {
        Tuple2<SemanticCheckResult, Expression> tuple2 = this.evaluateWithTypes(lhsTypes, rhsTypes);
        if (tuple2 != null) {
            Tuple2 tuple22;
            SemanticCheckResult result = (SemanticCheckResult)tuple2._1();
            Expression expression = (Expression)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)result, (Object)expression);
            SemanticCheckResult result2 = (SemanticCheckResult)tuple23._1();
            Expression expression2 = (Expression)tuple23._2();
            this.convertToAnyShouldWrapper(result2.errors()).shouldBe(this.empty(), Emptiness$.MODULE$.emptinessOfGenTraversable());
            this.convertToAnyShouldWrapper(this.types(expression2).apply((Object)result2.state())).should(this.equal(expected), (Object)Equality$.MODULE$.default());
            return;
        }
        throw new MatchError(tuple2);
    }

    public void testInvalidApplication(TypeSpec lhsTypes, TypeSpec rhsTypes, String message) {
        Tuple2<SemanticCheckResult, Expression> tuple2 = this.evaluateWithTypes(lhsTypes, rhsTypes);
        if (tuple2 != null) {
            SemanticCheckResult result;
            SemanticCheckResult semanticCheckResult;
            SemanticCheckResult result2 = semanticCheckResult = (result = (SemanticCheckResult)tuple2._1());
            this.convertToAnyShouldWrapper(result2.errors()).should(this.not()).be(this.empty(), Emptiness$.MODULE$.emptinessOfGenTraversable());
            this.convertToStringShouldWrapper(((SemanticErrorDef)result2.errors().head()).msg()).should(this.equal(message), (Object)Equality$.MODULE$.default());
            return;
        }
        throw new MatchError(tuple2);
    }

    public Tuple2<SemanticCheckResult, Expression> evaluateWithTypes(TypeSpec lhsTypes, TypeSpec rhsTypes) {
        DummyExpression lhs = new DummyExpression(lhsTypes, DummyExpression$.MODULE$.apply$default$2());
        DummyExpression rhs = new DummyExpression(rhsTypes, DummyExpression$.MODULE$.apply$default$2());
        Expression expression = (Expression)this.ctr.apply((Object)lhs, (Object)rhs);
        SemanticState state = ((SemanticCheckResult)SemanticExpressionCheck$.MODULE$.simple((Traversable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DummyExpression[]{lhs, rhs}))).apply((Object)SemanticState$.MODULE$.clean())).state();
        return new Tuple2(SemanticExpressionCheck$.MODULE$.simple(expression).apply((Object)state), (Object)expression);
    }

    public InfixExpressionTestBase(Function2<Expression, Expression, Expression> ctr) {
        this.ctr = ctr;
    }
}

