/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.jsonld;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.jsonldjava.core.JsonLdError;
import com.github.jsonldjava.core.JsonLdOptions;
import com.github.jsonldjava.core.JsonLdProcessor;
import com.github.jsonldjava.utils.JsonUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.helpers.JSONSettings;
import org.eclipse.rdf4j.rio.jsonld.JSONLDInternalTripleCallback;
import org.eclipse.rdf4j.rio.jsonld.JSONLDParser;

public class GenericJSONParser
extends JSONLDParser {
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();

    public void parse(InputStream in, String baseURI, String hookUri, String relName) throws IOException, RDFParseException, RDFHandlerException {
        this.clear();
        try {
            JSONLDInternalTripleCallback callback = new JSONLDInternalTripleCallback(this.getRDFHandler(), this.valueFactory, this.getParserConfig(), this.getParseErrorListener(), nodeID -> this.createNode((String)nodeID), () -> this.createNode());
            JsonLdOptions options = new JsonLdOptions(baseURI);
            options.useNamespaces = true;
            HashMap expandedContext = new HashMap();
            HashMap<String, String> childMap = new HashMap<String, String>();
            childMap.put("@vocab", baseURI);
            expandedContext.put("@context", childMap);
            options.setExpandContext(expandedContext);
            JsonFactory nextJsonFactory = this.configureNewJsonFactory();
            JsonParser nextParser = nextJsonFactory.createParser(in);
            Object parsedJson = JsonUtils.fromJsonParser(nextParser);
            LinkedHashMap<String, Object> wrappedParsedJson = new LinkedHashMap<String, Object>();
            wrappedParsedJson.put("@id", hookUri);
            wrappedParsedJson.put(relName, parsedJson);
            JsonLdProcessor.toRDF(wrappedParsedJson, callback, options);
        }
        catch (JsonLdError var13) {
            throw new RDFParseException("Could not parse JSONLD", var13);
        }
        catch (JsonProcessingException var14) {
            throw new RDFParseException("Could not parse JSONLD", (Throwable)var14, var14.getLocation().getLineNr(), var14.getLocation().getColumnNr());
        }
        catch (RuntimeException var15) {
            if (var15.getCause() != null && var15.getCause() instanceof RDFParseException) {
                throw (RDFParseException)var15.getCause();
            }
            throw var15;
        }
        finally {
            this.clear();
        }
    }

    private JsonFactory configureNewJsonFactory() {
        JsonFactory nextJsonFactory = new JsonFactory((ObjectCodec)JSON_MAPPER);
        if (this.getParserConfig().isSet(JSONSettings.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER)) {
            nextJsonFactory.configure(JsonParser.Feature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER, this.getParserConfig().get(JSONSettings.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER).booleanValue());
        }
        if (this.getParserConfig().isSet(JSONSettings.ALLOW_COMMENTS)) {
            nextJsonFactory.configure(JsonParser.Feature.ALLOW_COMMENTS, this.getParserConfig().get(JSONSettings.ALLOW_COMMENTS).booleanValue());
        }
        if (this.getParserConfig().isSet(JSONSettings.ALLOW_NON_NUMERIC_NUMBERS)) {
            nextJsonFactory.configure(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS, this.getParserConfig().get(JSONSettings.ALLOW_NON_NUMERIC_NUMBERS).booleanValue());
        }
        if (this.getParserConfig().isSet(JSONSettings.ALLOW_NUMERIC_LEADING_ZEROS)) {
            nextJsonFactory.configure(JsonParser.Feature.ALLOW_NUMERIC_LEADING_ZEROS, this.getParserConfig().get(JSONSettings.ALLOW_NUMERIC_LEADING_ZEROS).booleanValue());
        }
        if (this.getParserConfig().isSet(JSONSettings.ALLOW_SINGLE_QUOTES)) {
            nextJsonFactory.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, this.getParserConfig().get(JSONSettings.ALLOW_SINGLE_QUOTES).booleanValue());
        }
        if (this.getParserConfig().isSet(JSONSettings.ALLOW_UNQUOTED_CONTROL_CHARS)) {
            nextJsonFactory.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, this.getParserConfig().get(JSONSettings.ALLOW_UNQUOTED_CONTROL_CHARS).booleanValue());
        }
        if (this.getParserConfig().isSet(JSONSettings.ALLOW_UNQUOTED_FIELD_NAMES)) {
            nextJsonFactory.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, this.getParserConfig().get(JSONSettings.ALLOW_UNQUOTED_FIELD_NAMES).booleanValue());
        }
        if (this.getParserConfig().isSet(JSONSettings.ALLOW_YAML_COMMENTS)) {
            nextJsonFactory.configure(JsonParser.Feature.ALLOW_YAML_COMMENTS, this.getParserConfig().get(JSONSettings.ALLOW_YAML_COMMENTS).booleanValue());
        }
        if (this.getParserConfig().isSet(JSONSettings.ALLOW_TRAILING_COMMA)) {
            nextJsonFactory.configure(JsonParser.Feature.ALLOW_TRAILING_COMMA, this.getParserConfig().get(JSONSettings.ALLOW_TRAILING_COMMA).booleanValue());
        }
        if (this.getParserConfig().isSet(JSONSettings.INCLUDE_SOURCE_IN_LOCATION)) {
            nextJsonFactory.configure(JsonParser.Feature.INCLUDE_SOURCE_IN_LOCATION, this.getParserConfig().get(JSONSettings.INCLUDE_SOURCE_IN_LOCATION).booleanValue());
        }
        if (this.getParserConfig().isSet(JSONSettings.STRICT_DUPLICATE_DETECTION)) {
            nextJsonFactory.configure(JsonParser.Feature.STRICT_DUPLICATE_DETECTION, this.getParserConfig().get(JSONSettings.STRICT_DUPLICATE_DETECTION).booleanValue());
        }
        return nextJsonFactory;
    }
}

