/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.parser.sparql;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.rdf4j.common.annotation.InternalUseOnly;
import org.eclipse.rdf4j.query.algebra.And;
import org.eclipse.rdf4j.query.algebra.Filter;
import org.eclipse.rdf4j.query.algebra.Join;
import org.eclipse.rdf4j.query.algebra.LeftJoin;
import org.eclipse.rdf4j.query.algebra.SingletonSet;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.Var;

@InternalUseOnly
public class GraphPattern {
    private Var contextVar;
    private StatementPattern.Scope spScope = StatementPattern.Scope.DEFAULT_CONTEXTS;
    private final List<TupleExpr> requiredTEs = new ArrayList<TupleExpr>();
    private final List<Map.Entry<TupleExpr, List<ValueExpr>>> optionalTEs = new ArrayList<Map.Entry<TupleExpr, List<ValueExpr>>>();
    private List<ValueExpr> constraints = new ArrayList<ValueExpr>();

    public GraphPattern() {
    }

    public GraphPattern(GraphPattern parent) {
        this.contextVar = parent.contextVar;
        this.spScope = parent.spScope;
    }

    public void setContextVar(Var contextVar) {
        this.contextVar = contextVar;
    }

    public Var getContextVar() {
        return this.contextVar;
    }

    public void setStatementPatternScope(StatementPattern.Scope spScope) {
        this.spScope = spScope;
    }

    public StatementPattern.Scope getStatementPatternScope() {
        return this.spScope;
    }

    public void addRequiredTE(TupleExpr te) {
        this.requiredTEs.add(te);
    }

    public void addRequiredSP(Var subjVar, Var predVar, Var objVar) {
        this.addRequiredTE(new StatementPattern(this.spScope, subjVar, predVar, objVar, this.contextVar != null ? this.contextVar.clone() : null));
    }

    public List<TupleExpr> getRequiredTEs() {
        return Collections.unmodifiableList(this.requiredTEs);
    }

    public void addOptionalTE(TupleExpr te, List<ValueExpr> constraints) {
        AbstractMap.SimpleImmutableEntry<TupleExpr, List<ValueExpr>> entry = new AbstractMap.SimpleImmutableEntry<TupleExpr, List<ValueExpr>>(te, constraints);
        this.optionalTEs.add(entry);
    }

    public List<Map.Entry<TupleExpr, List<ValueExpr>>> getOptionalTEs() {
        return Collections.unmodifiableList(this.optionalTEs);
    }

    public void addConstraint(ValueExpr constraint) {
        this.constraints.add(constraint);
    }

    public void addConstraints(Collection<ValueExpr> constraints) {
        this.constraints.addAll(constraints);
    }

    public List<ValueExpr> getConstraints() {
        return Collections.unmodifiableList(this.constraints);
    }

    public List<ValueExpr> removeAllConstraints() {
        List<ValueExpr> constraints = this.constraints;
        this.constraints = new ArrayList<ValueExpr>();
        return constraints;
    }

    public void clear() {
        this.requiredTEs.clear();
        this.optionalTEs.clear();
        this.constraints.clear();
    }

    public TupleExpr buildTupleExpr() {
        TupleExpr result;
        if (this.requiredTEs.isEmpty()) {
            result = new SingletonSet();
        } else {
            result = this.requiredTEs.get(0);
            for (int i = 1; i < this.requiredTEs.size(); ++i) {
                TupleExpr te = this.requiredTEs.get(i);
                result = new Join(result, te);
            }
        }
        for (Map.Entry<TupleExpr, List<ValueExpr>> entry : this.optionalTEs) {
            List<ValueExpr> constraints = entry.getValue();
            if (constraints != null && !constraints.isEmpty()) {
                ValueExpr condition = constraints.get(0);
                for (int i = 1; i < constraints.size(); ++i) {
                    condition = new And(condition, constraints.get(i));
                }
                result = new LeftJoin(result, entry.getKey(), condition);
                continue;
            }
            result = new LeftJoin(result, entry.getKey());
        }
        for (ValueExpr constraint : this.constraints) {
            result = new Filter(result, constraint);
        }
        return result;
    }
}

