/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.function.aggregate.stdev;

import org.apache.commons.math3.util.FastMath;
import org.eclipse.rdf4j.common.annotation.Experimental;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.query.algebra.evaluation.function.aggregate.StatisticCollector;

@Experimental
public class StandardDeviationCollector
extends StatisticCollector {
    public StandardDeviationCollector(boolean population) {
        super(population);
    }

    @Override
    protected Literal computeValue() {
        double stDev = this.population ? FastMath.sqrt(this.statistics.getPopulationVariance()) : this.statistics.getStandardDeviation();
        if (Double.isNaN(stDev)) {
            return ZERO;
        }
        return SimpleValueFactory.getInstance().createLiteral(stDev);
    }
}

