/*
 * Decompiled with CFR 0.152.
 */
package n10s.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import n10s.utils.DynamicNamespacePrefixConflict;
import n10s.utils.InvalidNamespacePrefixDefinitionInDB;
import n10s.utils.NamespacePrefixConflictException;
import n10s.utils.NamespaceWithUndefinedPrefix;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;

public class NsPrefixMap {
    private static Map<String, String> standardNamespaces = NsPrefixMap.createStandardNamespacesMap();
    private static Map<String, String> standardPrefixes = NsPrefixMap.createStandardPrefixesMap();
    Map<String, String> prefixToNs = new HashMap<String, String>();
    Map<String, String> nsToPrefix = new HashMap<String, String>();

    private static Map<String, String> createStandardNamespacesMap() {
        HashMap<String, String> ns = new HashMap<String, String>();
        ns.put("http://schema.org/", "sch");
        ns.put("http://www.w3.org/2004/02/skos/core#", "skos");
        ns.put("http://www.w3.org/2008/05/skos-xl#", "skosxl");
        ns.put("http://www.w3.org/2000/01/rdf-schema#", "rdfs");
        ns.put("http://www.w3.org/2002/07/owl#", "owl");
        ns.put("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "rdf");
        ns.put("http://www.w3.org/ns/shacl#", "sh");
        ns.put("http://www.w3.org/2001/XMLSchema#", "xsd");
        return ns;
    }

    private static Map<String, String> createStandardPrefixesMap() {
        HashMap<String, String> ns = new HashMap<String, String>();
        ns.put("sch", "http://schema.org/");
        ns.put("skos", "http://www.w3.org/2004/02/skos/core#");
        ns.put("skosxl", "http://www.w3.org/2008/05/skos-xl#");
        ns.put("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        ns.put("owl", "http://www.w3.org/2002/07/owl#");
        ns.put("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        ns.put("sh", "http://www.w3.org/ns/shacl#");
        ns.put("xsd", "http://www.w3.org/2001/XMLSchema#");
        return ns;
    }

    public NsPrefixMap(Transaction tx, boolean acquireLock) throws InvalidNamespacePrefixDefinitionInDB {
        try {
            ResourceIterator namespacePrefixDefinitionNodes = tx.findNodes(Label.label((String)"_NsPrefDef"));
            if (namespacePrefixDefinitionNodes.hasNext()) {
                Node nspd = (Node)namespacePrefixDefinitionNodes.next();
                if (acquireLock) {
                    tx.acquireWriteLock((Entity)nspd);
                }
                for (Map.Entry entry : nspd.getAllProperties().entrySet()) {
                    this.add((String)entry.getKey(), (String)entry.getValue());
                }
            }
        }
        catch (NamespacePrefixConflictException e) {
            throw new InvalidNamespacePrefixDefinitionInDB("The namespace prefix definition in the DB is invalid. Detail: " + e.getMessage());
        }
    }

    public String getNsForPrefix(String prefix) {
        return this.prefixToNs.get(prefix);
    }

    public String getPrefixForNs(String ns) {
        return this.nsToPrefix.get(ns);
    }

    public boolean hasPrefix(String prefix) {
        return this.prefixToNs.containsKey(prefix);
    }

    public boolean hasNs(String ns) {
        return this.nsToPrefix.containsKey(ns);
    }

    public String getPrefixOrAdd(String ns, boolean strict) {
        if (this.nsToPrefix.containsKey(ns)) {
            return this.nsToPrefix.get(ns);
        }
        if (!strict) {
            if (standardNamespaces.containsKey(ns)) {
                this.add(standardNamespaces.get(ns), ns);
                return standardNamespaces.get(ns);
            }
            String nextNsPrefix = "ns" + this.prefixToNs.keySet().stream().filter(x -> x.startsWith("ns")).count();
            this.add(nextNsPrefix, ns);
            return nextNsPrefix;
        }
        throw new NamespaceWithUndefinedPrefix("No prefix has been defined for namespace <" + ns + "> and 'handleVocabUris' is set to 'SHORTEN_STRICT'");
    }

    public void add(String prefix, String ns) throws NamespacePrefixConflictException {
        if (standardPrefixes.containsKey(prefix) && !standardPrefixes.get(prefix).equals(ns)) {
            throw new NamespacePrefixConflictException("Invalid prefix + namespace combination: " + prefix + " is a reserved namespace prefix for <" + standardPrefixes.get(prefix) + ">");
        }
        if (standardNamespaces.containsKey(ns) && !standardNamespaces.get(ns).equals(prefix)) {
            throw new NamespacePrefixConflictException("Invalid prefix + namespace combination: " + ns + " is a standard namespace that has the associated standard prefix " + standardNamespaces.get(ns));
        }
        if (!this.prefixToNs.containsKey(prefix) && !this.nsToPrefix.containsKey(ns)) {
            this.prefixToNs.put(prefix, ns);
            this.nsToPrefix.put(ns, prefix);
        } else {
            if (this.prefixToNs.containsKey(prefix) && !this.prefixToNs.get(prefix).equals(ns)) {
                throw new NamespacePrefixConflictException("prefix " + prefix + " is in use for namespace <" + this.prefixToNs.get(prefix) + ">");
            }
            if (this.nsToPrefix.containsKey(ns) && !this.nsToPrefix.get(ns).equals(prefix)) {
                throw new NamespacePrefixConflictException("namespace <" + ns + "> has already an associated prefix (" + this.nsToPrefix.get(ns) + ")");
            }
        }
    }

    public void removePrefix(String prefix) {
        if (this.prefixToNs.containsKey(prefix)) {
            this.nsToPrefix.remove(this.prefixToNs.get(prefix));
            this.prefixToNs.remove(prefix);
        }
    }

    public void removeNamespace(String ns) {
        if (this.nsToPrefix.containsKey(ns)) {
            this.prefixToNs.remove(this.nsToPrefix.get(ns));
            this.nsToPrefix.remove(ns);
        }
    }

    public Set<String> getPrefixes() {
        return this.prefixToNs.keySet();
    }

    public Set<String> getNamespaces() {
        return this.nsToPrefix.keySet();
    }

    public Map<String, String> getPrefixToNs() {
        return this.prefixToNs;
    }

    public Map<String, String> getNsToPrefix() {
        return this.nsToPrefix;
    }

    public void flushToDB(Transaction tx) {
        block5: {
            block4: {
                ResourceIterator namespacePrefixDefinitionNodes = tx.findNodes(Label.label((String)"_NsPrefDef"));
                if (!namespacePrefixDefinitionNodes.hasNext()) break block4;
                Node nsPrefDefNode = (Node)namespacePrefixDefinitionNodes.next();
                HashMap<String, String> nsPrefDefInDB = new HashMap<String, String>();
                for (Map.Entry entry : nsPrefDefNode.getAllProperties().entrySet()) {
                    if (!this.prefixToNs.containsKey(entry.getKey()) || !this.prefixToNs.get(entry.getKey()).equals(entry.getValue())) {
                        nsPrefDefNode.removeProperty((String)entry.getKey());
                        continue;
                    }
                    nsPrefDefInDB.put((String)entry.getKey(), (String)entry.getValue());
                }
                for (Map.Entry<Object, Object> entry : this.prefixToNs.entrySet()) {
                    if (nsPrefDefInDB.containsKey(entry.getKey())) continue;
                    nsPrefDefNode.setProperty((String)entry.getKey(), entry.getValue());
                }
                break block5;
            }
            if (this.prefixToNs.isEmpty()) break block5;
            Node nsPrefDefNode = (Node)tx.execute("MERGE (n:_NsPrefDef) RETURN n ").next().get("n");
            for (Map.Entry<String, String> entry : this.prefixToNs.entrySet()) {
                nsPrefDefNode.setProperty(entry.getKey(), (Object)entry.getValue());
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> pair : this.prefixToNs.entrySet()) {
            sb.append(pair.getKey() + ": <" + pair.getValue() + ">");
        }
        return sb.toString();
    }

    private boolean reloadFromDB(Transaction tx) throws DynamicNamespacePrefixConflict {
        ResourceIterator namespacePrefixDefinitionNodes = tx.findNodes(Label.label((String)"_NsPrefDef"));
        if (namespacePrefixDefinitionNodes.hasNext()) {
            Node nsPrefDefNode = (Node)namespacePrefixDefinitionNodes.next();
            tx.acquireWriteLock((Entity)nsPrefDefNode);
            for (Map.Entry entry : nsPrefDefNode.getAllProperties().entrySet()) {
                if (!this.prefixToNs.containsKey(entry.getKey()) && !this.nsToPrefix.containsKey(entry.getValue())) {
                    this.add((String)entry.getKey(), (String)entry.getValue());
                    continue;
                }
                if (this.prefixToNs.containsKey(entry.getKey()) && !this.nsToPrefix.containsKey(entry.getValue())) {
                    throw new DynamicNamespacePrefixConflict("Prefix " + (String)entry.getKey() + " is already in use for namespace <" + entry.getValue() + ">");
                }
                if (this.prefixToNs.containsKey(entry.getKey()) || !this.nsToPrefix.containsKey(entry.getValue())) continue;
                throw new DynamicNamespacePrefixConflict("An alternative prefix (" + (String)entry.getKey() + ") is already in use for namespace <" + entry.getValue() + ">");
            }
        }
        return true;
    }

    public Integer partialRefresh(Transaction tx) throws DynamicNamespacePrefixConflict {
        if (this.reloadFromDB(tx)) {
            this.flushToDB(tx);
            return 0;
        }
        return 1;
    }
}

