/*
 * Decompiled with CFR 0.152.
 */
package n10s.rdf.export;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import n10s.graphconfig.GraphConfig;
import n10s.rdf.export.ExportProcessor;
import n10s.rdf.export.TriplePattern;
import n10s.utils.InvalidNamespacePrefixDefinitionInDB;
import n10s.utils.UriUtils;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.OWL;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;

public class LPGToRDFProcesssor
extends ExportProcessor {
    private final Map<String, String> exportMappings;
    private final boolean exportOnlyMappedElems;

    public LPGToRDFProcesssor(GraphDatabaseService gds, Transaction tx, GraphConfig gc, Map<String, String> exportMappings, boolean mappedElemsOnly, boolean isRDFStarSerialisation) {
        super(tx, gds, gc);
        this.exportMappings = exportMappings;
        this.exportPropertiesInRels = isRDFStarSerialisation;
        this.exportOnlyMappedElems = mappedElemsOnly;
    }

    @Override
    public Stream<Statement> streamLocalImplicitOntology() {
        Result res = this.tx.execute("CALL db.schema.visualization() ");
        HashSet<Statement> statements = new HashSet<Statement>();
        Map next = res.next();
        List nodeList = (List)next.get("nodes");
        nodeList.forEach(node -> {
            String catName = node.getAllProperties().get("name").toString();
            if (!(catName.equals("Resource") || catName.equals("_NsPrefDef") || catName.equals("_n10sValidatorConfig") || catName.equals("_MapNs") || catName.equals("_MapDef") || catName.equals("_GraphConfig"))) {
                IRI subject = this.vf.createIRI(this.BASE_SCH_NS, catName);
                statements.add(this.vf.createStatement(subject, RDF.TYPE, OWL.CLASS));
                statements.add(this.vf.createStatement(subject, RDFS.LABEL, this.vf.createLiteral(catName)));
            }
        });
        List relationshipList = (List)next.get("relationships");
        for (Relationship r : relationshipList) {
            String rangeLabel;
            IRI relUri = this.vf.createIRI(this.BASE_SCH_NS, r.getType().name());
            statements.add(this.vf.createStatement(relUri, RDF.TYPE, OWL.OBJECTPROPERTY));
            statements.add(this.vf.createStatement(relUri, RDFS.LABEL, this.vf.createLiteral(r.getType().name())));
            String domainLabel = ((Label)r.getStartNode().getLabels().iterator().next()).name();
            if (!domainLabel.equals("Resource")) {
                statements.add(this.vf.createStatement(relUri, RDFS.DOMAIN, this.vf.createIRI(this.BASE_SCH_NS, domainLabel)));
            }
            if ((rangeLabel = ((Label)r.getEndNode().getLabels().iterator().next()).name()).equals("Resource")) continue;
            statements.add(this.vf.createStatement(relUri, RDFS.RANGE, this.vf.createIRI(this.BASE_SCH_NS, rangeLabel)));
        }
        res = this.tx.execute("call db.schema.nodeTypeProperties() yield nodeLabels, propertyName, propertyTypes \n return [x in nodeLabels where x <> 'Resource'] as domain, propertyName as pName,  replace(propertyTypes[0],\"Array\",\"\") as range ");
        while (res.hasNext()) {
            next = res.next();
            if (next.get("pName").toString().equals("uri")) continue;
            IRI propUri = this.vf.createIRI(this.BASE_SCH_NS, next.get("pName").toString());
            statements.add(this.vf.createStatement(propUri, RDF.TYPE, OWL.DATATYPEPROPERTY));
            statements.add(this.vf.createStatement(propUri, RDFS.LABEL, this.vf.createLiteral(next.get("pName").toString())));
            List domains = (List)next.get("domain");
            for (String dom : domains) {
                statements.add(this.vf.createStatement(propUri, RDFS.DOMAIN, this.vf.createIRI(this.BASE_SCH_NS, dom)));
            }
            statements.add(this.vf.createStatement(propUri, RDFS.RANGE, this.getXSDType(next.get("range").toString())));
        }
        return statements.stream();
    }

    public Stream<Statement> streamLocalExplicitOntology(Map<String, Object> params) {
        return this.tx.execute(this.buildOntoQuery(params)).stream().map(triple -> this.vf.createStatement(this.vf.createIRI((String)triple.get("subject")), this.vf.createIRI((String)triple.get("predicate")), this.vf.createIRI((String)triple.get("object"))));
    }

    private String buildOntoQuery(Map<String, Object> params) {
        return " MATCH (rel)-[:DOMAIN]->(domain) RETURN '" + this.BASE_SCH_NS + "' + rel.name AS subject, '" + RDFS.DOMAIN + "' AS predicate, '" + this.BASE_SCH_NS + "' + domain.name AS object  UNION  MATCH (rel)-[:RANGE]->(range) RETURN '" + this.BASE_SCH_NS + "' + rel.name AS subject, '" + RDFS.RANGE + "' AS predicate, '" + this.BASE_SCH_NS + "' + range.name AS object  UNION  MATCH (child)-[:SCO]->(parent) RETURN '" + this.BASE_SCH_NS + "' + child.name AS subject, '" + RDFS.SUBCLASSOF + "' AS predicate, '" + this.BASE_SCH_NS + "' + parent.name AS object   UNION  MATCH (child)-[:SPO]->(parent) RETURN '" + this.BASE_SCH_NS + "' + child.name AS subject, '" + RDFS.SUBPROPERTYOF + "' AS predicate, '" + this.BASE_SCH_NS + "' + parent.name AS object ";
    }

    public Stream<Statement> streamNodeById(Long nodeId, boolean streamContext) {
        HashMap<Long, IRI> ontologyEntitiesUris = new HashMap<Long, IRI>();
        Node node = this.tx.getNodeById(nodeId.longValue());
        Set<Statement> result = this.processNode(node, ontologyEntitiesUris, null);
        if (streamContext) {
            ResourceIterable relationships = node.getRelationships();
            for (Relationship rel : relationships) {
                result.addAll(this.processRelationship(rel, ontologyEntitiesUris));
            }
        }
        return result.stream();
    }

    public Stream<Statement> streamNodeByUri(String nodeUri, boolean streamContext) {
        HashMap<Long, IRI> ontologyEntitiesUris = new HashMap<Long, IRI>();
        Node node = this.tx.findNode(Label.label((String)"Resource"), "uri", (Object)nodeUri);
        Set<Statement> result = this.processNode(node, ontologyEntitiesUris, null);
        if (streamContext) {
            ResourceIterable relationships = node.getRelationships();
            for (Relationship rel : relationships) {
                result.addAll(this.processRelationship(rel, ontologyEntitiesUris));
            }
        }
        return result.stream();
    }

    @Override
    protected boolean filterRelationship(Relationship rel, Map<Long, IRI> ontologyEntitiesUris) {
        return this.filterNode(rel.getStartNode(), ontologyEntitiesUris) || this.filterNode(rel.getEndNode(), ontologyEntitiesUris);
    }

    @Override
    protected boolean filterNode(Node node, Map<Long, IRI> ontologyEntitiesUris) {
        return node.hasLabel(Label.label((String)"_MapDef")) || node.hasLabel(Label.label((String)"_MapNs")) || node.hasLabel(Label.label((String)"_NsPrefDef")) || node.hasLabel(Label.label((String)"_n10sValidatorConfig")) || node.hasLabel(Label.label((String)"_GraphConfig"));
    }

    @Override
    protected void processPropOnRel(Set<Statement> statementSet, Statement baseStatement, String key, Object propertyValueObject) {
        if (!this.exportOnlyMappedElems || this.exportMappings.containsKey(key)) {
            IRI predicate;
            IRI iRI = predicate = this.exportMappings.containsKey(key) ? this.vf.createIRI(this.exportMappings.get(key)) : this.vf.createIRI(this.BASE_SCH_NS, key);
            if (propertyValueObject instanceof Object[]) {
                for (Object o : (Object[])propertyValueObject) {
                    statementSet.add(this.vf.createStatement(this.vf.createTriple(baseStatement.getSubject(), baseStatement.getPredicate(), baseStatement.getObject()), predicate, this.createTypedLiteral(o)));
                }
            } else {
                statementSet.add(this.vf.createStatement(this.vf.createTriple(baseStatement.getSubject(), baseStatement.getPredicate(), baseStatement.getObject()), predicate, this.createTypedLiteral(propertyValueObject)));
            }
        }
    }

    @Override
    protected Set<Statement> processRelationship(Relationship rel, Map<Long, IRI> ontologyEntitiesUris) {
        HashSet<Statement> statements = new HashSet<Statement>();
        if (!this.exportOnlyMappedElems || this.exportMappings.containsKey(rel.getType().name())) {
            Statement base = this.vf.createStatement(this.getResourceUri(rel.getStartNode()), this.exportMappings.containsKey(rel.getType().name()) ? this.vf.createIRI(this.exportMappings.get(rel.getType().name())) : this.vf.createIRI(this.BASE_SCH_NS, rel.getType().name()), this.getResourceUri(rel.getEndNode()));
            statements.add(base);
            if (this.exportPropertiesInRels) {
                rel.getAllProperties().forEach((k, v) -> this.processPropOnRel((Set<Statement>)statements, base, (String)k, v));
            }
        }
        return statements;
    }

    private IRI getUriforRelName(String name) {
        switch (name) {
            case "SCO": {
                return RDFS.SUBCLASSOF;
            }
            case "SPO": {
                return RDFS.SUBPROPERTYOF;
            }
            case "DOMAIN": {
                return RDFS.DOMAIN;
            }
            case "RANGE": {
                return RDFS.RANGE;
            }
        }
        return RDFS.SUBCLASSOF;
    }

    @Override
    protected Set<Statement> processNode(Node node, Map<Long, IRI> ontologyEntitiesUris, String propNameFilter) {
        HashSet<Statement> statements = new HashSet<Statement>();
        ArrayList nodeLabels = new ArrayList();
        node.getLabels().forEach(l -> {
            if (!l.name().equals("Resource")) {
                nodeLabels.add(l);
            }
        });
        IRI subject = this.getResourceUri(node);
        if (propNameFilter == null || propNameFilter.equals(RDF.TYPE.stringValue())) {
            for (Label label : nodeLabels) {
                if (this.exportOnlyMappedElems && !this.exportMappings.containsKey(label.name())) continue;
                statements.add(this.vf.createStatement(subject, RDF.TYPE, this.exportMappings.containsKey(label.name()) ? this.vf.createIRI(this.exportMappings.get(label.name())) : this.vf.createIRI(this.BASE_SCH_NS, label.name())));
            }
        }
        Map allProperties = node.getAllProperties();
        allProperties.remove("uri");
        for (String key : allProperties.keySet()) {
            if (propNameFilter != null && !propNameFilter.equals(this.vf.createIRI(this.BASE_SCH_NS, key).stringValue()) || this.exportOnlyMappedElems && !this.exportMappings.containsKey(key)) continue;
            IRI predicate = this.exportMappings.containsKey(key) ? this.vf.createIRI(this.exportMappings.get(key)) : this.vf.createIRI(this.BASE_SCH_NS, key);
            Object propertyValueObject = allProperties.get(key);
            this.addStatementsForPotentiallyMultivalLiteral(statements, subject, predicate, propertyValueObject);
        }
        return statements;
    }

    private void addStatementsForPotentiallyMultivalLiteral(Set<Statement> statements, IRI subject, IRI predicate, Object propertyValueObject) {
        if (propertyValueObject instanceof long[]) {
            for (int i = 0; i < ((long[])propertyValueObject).length; ++i) {
                Literal object = this.createTypedLiteral(((long[])propertyValueObject)[i]);
                statements.add(this.vf.createStatement(subject, predicate, object));
            }
        } else if (propertyValueObject instanceof double[]) {
            for (int i = 0; i < ((double[])propertyValueObject).length; ++i) {
                Literal object = this.createTypedLiteral(((double[])propertyValueObject)[i]);
                statements.add(this.vf.createStatement(subject, predicate, object));
            }
        } else if (propertyValueObject instanceof boolean[]) {
            for (int i = 0; i < ((boolean[])propertyValueObject).length; ++i) {
                Literal object = this.createTypedLiteral(((boolean[])propertyValueObject)[i]);
                statements.add(this.vf.createStatement(subject, predicate, object));
            }
        } else if (propertyValueObject instanceof LocalDateTime[]) {
            for (int i = 0; i < ((LocalDateTime[])propertyValueObject).length; ++i) {
                Literal object = this.createTypedLiteral(((LocalDateTime[])propertyValueObject)[i]);
                statements.add(this.vf.createStatement(subject, predicate, object));
            }
        } else if (propertyValueObject instanceof Object[]) {
            for (Object o : (Object[])propertyValueObject) {
                statements.add(this.vf.createStatement(subject, predicate, this.createTypedLiteral(o)));
            }
        } else {
            statements.add(this.vf.createStatement(subject, predicate, this.createTypedLiteral(propertyValueObject)));
        }
    }

    @Override
    public Stream<Statement> streamTriplesFromTriplePattern(TriplePattern tp) throws InvalidNamespacePrefixDefinitionInDB {
        if (tp.getSubject() != null) {
            HashSet<Statement> allStatements = new HashSet<Statement>();
            Node resource = this.getNodeByUri(tp.getSubject());
            if (resource != null) {
                String predicate = tp.getPredicate();
                if (tp.getObject() == null) {
                    allStatements.addAll(this.processNode(resource, null, predicate));
                    ResourceIterable relationships = predicate == null ? resource.getRelationships(Direction.OUTGOING) : resource.getRelationships(Direction.OUTGOING, new RelationshipType[]{RelationshipType.withName((String)this.vf.createIRI(predicate).getLocalName())});
                    for (Relationship r : relationships) {
                        allStatements.addAll(this.processRelationship(r, null));
                    }
                } else {
                    Value object = this.getValueFromTriplePatternObject(tp);
                    allStatements.addAll(this.processNode(resource, null, predicate).stream().filter(st -> st.getObject().equals(object)).collect(Collectors.toSet()));
                    if (!tp.getLiteral().booleanValue()) {
                        ResourceIterable relationships = predicate == null ? resource.getRelationships(Direction.OUTGOING) : resource.getRelationships(Direction.OUTGOING, new RelationshipType[]{RelationshipType.withName((String)this.vf.createIRI(predicate).getLocalName())});
                        for (Relationship r : relationships) {
                            if (!this.getResourceUri(r.getEndNode()).stringValue().equals(object.stringValue())) continue;
                            allStatements.addAll(this.processRelationship(r, null));
                        }
                    }
                }
            }
            return allStatements.stream();
        }
        HashSet<Statement> allStatements = new HashSet<Statement>();
        String predicate = null;
        try {
            predicate = tp.getPredicate() != null ? UriUtils.translateUri(tp.getPredicate(), this.tx, this.graphConfig) : null;
        }
        catch (UriUtils.UriNamespaceHasNoAssociatedPrefix e) {
            predicate = tp.getPredicate();
        }
        if (tp.getObject() == null) {
            if (predicate != null) {
                if (tp.getPredicate().equals(RDF.TYPE.stringValue())) {
                    Result result = this.tx.execute("MATCH (r) RETURN r");
                    while (result.hasNext()) {
                        Map next = result.next();
                        Node node = (Node)next.get("r");
                        for (Label label : node.getLabels()) {
                            if (this.graphConfig != null) {
                                if (label.name().equals("Resource") || label.name().equals("_GraphConfig")) continue;
                                allStatements.add(this.vf.createStatement(this.getResourceUri(node), RDF.TYPE, this.vf.createIRI(this.BASE_SCH_NS, label.name())));
                                continue;
                            }
                            if (this.exportOnlyMappedElems && !this.exportMappings.containsKey(label.name())) continue;
                            allStatements.add(this.vf.createStatement(this.getResourceUri(node), RDF.TYPE, this.exportMappings.containsKey(label.name()) ? this.vf.createIRI(this.exportMappings.get(label.name())) : this.vf.createIRI(this.BASE_SCH_NS, label.name())));
                        }
                    }
                    return allStatements.stream();
                }
                if (!predicate.equals("__NONE__")) {
                    Result result = this.tx.execute(String.format("MATCH (s) WHERE s.`%s` is not null RETURN s, s.`%s` as o\nUNION \nMATCH (s)-[:`%s`]->(o) RETURN s, o", predicate, predicate, predicate));
                    while (result.hasNext()) {
                        Map next = result.next();
                        Node subjectNode = (Node)next.get("s");
                        Object objectThing = next.get("o");
                        if (this.exportOnlyMappedElems && !this.exportMappings.containsKey(predicate)) continue;
                        if (objectThing instanceof Node) {
                            allStatements.add(this.vf.createStatement(this.getResourceUri(subjectNode), this.exportMappings.containsKey(predicate) ? this.vf.createIRI(this.exportMappings.get(predicate)) : this.vf.createIRI(this.BASE_SCH_NS, predicate), this.getResourceUri((Node)objectThing)));
                            continue;
                        }
                        this.addStatementsForPotentiallyMultivalLiteral(allStatements, this.getResourceUri(subjectNode), this.exportMappings.containsKey(predicate) ? this.vf.createIRI(this.exportMappings.get(predicate)) : this.vf.createIRI(this.BASE_SCH_NS, predicate), objectThing);
                    }
                }
                return allStatements.stream();
            }
            Result result = this.tx.execute("MATCH (r) WHERE NOT r:_GraphConfig RETURN r\nUNION \nMATCH ()-[r]->() RETURN r");
            return result.stream().flatMap(row -> {
                HashSet<Statement> rowResult = new HashSet<Statement>();
                Object r = row.get("r");
                if (r instanceof Node) {
                    rowResult.addAll(this.processNode((Node)r, null, null));
                } else if (r instanceof Relationship) {
                    rowResult.addAll(this.processRelationship((Relationship)r, null));
                }
                return rowResult.stream();
            });
        }
        Value object = this.getValueFromTriplePatternObject(tp);
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (predicate != null) {
            if (tp.getPredicate().equals(RDF.TYPE.stringValue())) {
                String objectAsLabel = null;
                objectAsLabel = object instanceof IRI ? (((IRI)object).getNamespace().equals("neo4j://graph.schema#") ? ((IRI)object).getLocalName() : "____") : "____";
                Result result = this.tx.execute(String.format("MATCH (r:`%s`) RETURN r", objectAsLabel));
                while (result.hasNext()) {
                    if (this.exportOnlyMappedElems && !this.exportMappings.containsKey(objectAsLabel)) continue;
                    allStatements.add(this.vf.createStatement(this.getResourceUri((Node)result.next().get("r")), RDF.TYPE, object));
                }
                return allStatements.stream();
            }
            if (object instanceof IRI) {
                params.put("uri", object.stringValue());
                Result result = this.tx.execute(String.format("MATCH (:Resource)-[r:`%s`]->(o:Resource { uri:  $uri }) RETURN r", predicate), params);
                while (result.hasNext()) {
                    if (this.exportOnlyMappedElems && !this.exportMappings.containsKey(predicate)) continue;
                    allStatements.add(this.vf.createStatement(this.getResourceUri((Node)result.next().get("r")), this.exportMappings.containsKey(predicate) ? this.vf.createIRI(this.exportMappings.get(predicate)) : this.vf.createIRI(this.BASE_SCH_NS, predicate), object));
                }
                return allStatements.stream();
            }
            params.put("propVal", this.castValueFromXSDType((Literal)object));
            Result result = this.tx.execute(String.format("MATCH (r) WHERE $propVal in r.`%s` + [] RETURN r", predicate), params);
            while (result.hasNext()) {
                if (this.exportOnlyMappedElems && !this.exportMappings.containsKey(predicate)) continue;
                allStatements.add(this.vf.createStatement(this.getResourceUri((Node)result.next().get("r")), this.exportMappings.containsKey(predicate) ? this.vf.createIRI(this.exportMappings.get(predicate)) : this.vf.createIRI(this.BASE_SCH_NS, predicate), object));
            }
            return allStatements.stream();
        }
        if (object instanceof IRI) {
            Node objectNode = this.getNodeByUri(object.stringValue());
            params.put("objectNodeInternalId", objectNode.getId());
            Result result = this.tx.execute("MATCH ()-[r]->(o) WHERE id(o) = $objectNodeInternalId RETURN r", params);
            return result.stream().flatMap(row -> {
                HashSet<Statement> rowResult = new HashSet<Statement>();
                Object r = row.get("r");
                rowResult.addAll(this.processRelationship((Relationship)r, null));
                return rowResult.stream();
            });
        }
        params.put("propVal", this.castValueFromXSDType((Literal)object));
        Result result = this.tx.execute("MATCH (r) UNWIND keys(r) as propName \nWITH r, propName\nWHERE $propVal in [] + r[propName] \nRETURN r, propName", params);
        while (result.hasNext()) {
            Map next = result.next();
            if (this.exportOnlyMappedElems && !this.exportMappings.containsKey(predicate)) continue;
            allStatements.add(this.vf.createStatement(this.getResourceUri((Node)next.get("r")), this.exportMappings.containsKey((String)next.get("propName")) ? this.vf.createIRI(this.exportMappings.get((String)next.get("propName"))) : this.vf.createIRI(this.BASE_SCH_NS, (String)next.get("propName")), object));
        }
        return allStatements.stream();
    }

    private Node getNodeByUri(String uri) {
        if (this.graphConfig != null) {
            return this.tx.findNode(Label.label((String)"Resource"), "uri", (Object)uri);
        }
        try {
            return this.tx.getNodeById(this.getNodeIdFromUri(uri));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private long getNodeIdFromUri(String subject) {
        return Long.parseLong(subject.substring("neo4j://graph.individuals#".length()));
    }

    private IRI getResourceUri(Node node) {
        String explicituri = (String)node.getProperty("uri", null);
        return explicituri == null ? this.vf.createIRI("neo4j://graph.individuals#", String.valueOf(node.getId())) : this.vf.createIRI(explicituri);
    }
}

