/*
 * Decompiled with CFR 0.152.
 */
package n10s.rdf.export;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import n10s.graphconfig.GraphConfig;
import n10s.graphconfig.Params;
import n10s.rdf.export.TriplePattern;
import n10s.utils.InvalidNamespacePrefixDefinitionInDB;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.eclipse.rdf4j.model.vocabulary.XSD;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.values.storable.PointValue;

public abstract class ExportProcessor {
    protected Transaction tx;
    protected GraphDatabaseService graphdb;
    protected final ValueFactory vf = SimpleValueFactory.getInstance();
    protected boolean exportPropertiesInRels;
    protected GraphConfig graphConfig;
    protected final String BASE_SCH_NS;

    public ExportProcessor(Transaction tx, GraphDatabaseService graphdb, GraphConfig gc) {
        this.tx = tx;
        this.graphdb = graphdb;
        this.graphConfig = gc;
        this.BASE_SCH_NS = gc != null ? gc.getBaseSchemaNamespace() : "neo4j://graph.schema#";
    }

    public Stream<Statement> streamTriplesFromCypher(String cypher, Map<String, Object> params) {
        Result result = this.tx.execute(cypher, params);
        HashMap ontologyEntitiesUris = new HashMap();
        HashSet serializedNodeIds = new HashSet();
        return result.stream().flatMap(row -> {
            HashSet<Statement> rowResult = new HashSet<Statement>();
            Set entries = row.entrySet();
            ArrayList<Node> nodes = new ArrayList<Node>();
            ArrayList<Relationship> rels = new ArrayList<Relationship>();
            ArrayList<Path> paths = new ArrayList<Path>();
            for (Map.Entry entry : entries) {
                Object o = entry.getValue();
                if (o instanceof Node) {
                    nodes.add((Node)o);
                    continue;
                }
                if (o instanceof Relationship) {
                    rels.add((Relationship)o);
                    continue;
                }
                if (o instanceof Path) {
                    paths.add((Path)o);
                    continue;
                }
                if (!(o instanceof List)) continue;
                ((List)o).stream().forEach(x -> {
                    if (x instanceof Node) {
                        nodes.add((Node)x);
                    } else if (x instanceof Relationship) {
                        rels.add((Relationship)x);
                    } else if (x instanceof Path) {
                        paths.add((Path)x);
                    }
                });
            }
            for (Node node : nodes) {
                if (serializedNodeIds.contains(node.getId()) || this.filterNode(node, ontologyEntitiesUris)) continue;
                serializedNodeIds.add(node.getId());
                rowResult.addAll(this.processNode(node, ontologyEntitiesUris, null));
            }
            for (Relationship rel : rels) {
                if (this.filterRelationship(rel, ontologyEntitiesUris)) continue;
                rowResult.addAll(this.processRelationship(rel, ontologyEntitiesUris));
            }
            for (Path p : paths) {
                p.iterator().forEachRemaining(propertyContainer -> {
                    if (propertyContainer instanceof Node) {
                        Node node = (Node)propertyContainer;
                        if (!serializedNodeIds.contains(node.getId()) && !this.filterNode(node, ontologyEntitiesUris)) {
                            serializedNodeIds.add(node.getId());
                            rowResult.addAll(this.processNode(node, ontologyEntitiesUris, null));
                        }
                    } else if (propertyContainer instanceof Relationship && !this.filterRelationship((Relationship)propertyContainer, ontologyEntitiesUris)) {
                        rowResult.addAll(this.processRelationship((Relationship)propertyContainer, ontologyEntitiesUris));
                    }
                });
            }
            return rowResult.stream();
        });
    }

    public Stream<Statement> streamNodesBySearch(String label, String property, String propVal, String valType, boolean includeContext) {
        HashSet<Statement> result = new HashSet<Statement>();
        HashMap<Long, IRI> ontologyEntitiesUris = new HashMap<Long, IRI>();
        ResourceIterator nodes = this.tx.findNodes(Label.label((String)label), property, valType == null ? propVal : this.castValue(valType, propVal));
        while (nodes.hasNext()) {
            Node node = (Node)nodes.next();
            result.addAll(this.processNode(node, ontologyEntitiesUris, null));
            if (!includeContext) continue;
            ResourceIterable relationships = node.getRelationships();
            for (Relationship rel : relationships) {
                result.addAll(this.processRelationship(rel, ontologyEntitiesUris));
            }
        }
        return result.stream();
    }

    protected Literal createTypedLiteral(Object value) {
        Literal result = value instanceof String ? this.getLiteralWithTagOrDTIfPresent((String)value) : (value instanceof Integer ? this.vf.createLiteral((Integer)value) : (value instanceof Long ? this.vf.createLiteral((Long)value) : (value instanceof Float ? this.vf.createLiteral(((Float)value).floatValue()) : (value instanceof Double ? this.vf.createLiteral((Double)value) : (value instanceof Boolean ? this.vf.createLiteral((Boolean)value) : (value instanceof LocalDateTime ? this.vf.createLiteral(((LocalDateTime)value).format(DateTimeFormatter.ISO_LOCAL_DATE_TIME), XMLSchema.DATETIME) : (value instanceof ZonedDateTime ? this.vf.createLiteral(((ZonedDateTime)value).format(DateTimeFormatter.ISO_ZONED_DATE_TIME), XMLSchema.DATETIME) : (value instanceof LocalDate ? this.vf.createLiteral(((LocalDate)value).format(DateTimeFormatter.ISO_LOCAL_DATE), XMLSchema.DATE) : (value instanceof PointValue ? this.vf.createLiteral(this.pointValueToWTK((PointValue)value), this.vf.createIRI("http://www.opengis.net/ont/geosparql#", "wktLiteral")) : this.getLiteralWithTagOrDTIfPresent((String)value))))))))));
        return result;
    }

    private String pointValueToWTK(PointValue pv) {
        return "Point(" + pv.coordinate()[0] + " " + pv.coordinate()[1] + (String)(pv.getCRS().getCode() == 9157 ? " " + pv.coordinate()[2] : "") + ")";
    }

    private Literal getLiteralWithTagOrDTIfPresent(String value) {
        Pattern langTagPattern = Pattern.compile("^(.*)@([a-z,\\-]+)$");
        Pattern customDataTypePattern = Pattern.compile("^(.*)" + Pattern.quote("^^") + "(.*)$");
        Matcher langTag = langTagPattern.matcher(value);
        Matcher customDT = customDataTypePattern.matcher(value);
        if (langTag.matches()) {
            return this.vf.createLiteral(langTag.group(1), langTag.group(2));
        }
        if (customDT.matches()) {
            return this.vf.createLiteral(customDT.group(1), this.vf.createIRI(customDT.group(2)));
        }
        return this.vf.createLiteral(value);
    }

    protected Value getValueFromTriplePatternObject(TriplePattern tp) {
        Value object = tp.getLiteral().booleanValue() ? (tp.getLiteralLang() != null ? this.vf.createLiteral(tp.getObject(), tp.getLiteralLang()) : this.vf.createLiteral(tp.getObject(), this.vf.createIRI(tp.getLiteralType()))) : this.vf.createIRI(tp.getObject());
        return object;
    }

    Object castValue(String valType, String propVal) {
        switch (valType) {
            case "INTEGER": {
                return Integer.valueOf(propVal);
            }
            case "FLOAT": {
                return Float.valueOf(propVal);
            }
            case "BOOLEAN": {
                return Boolean.valueOf(propVal);
            }
        }
        return propVal;
    }

    Object castValueFromXSDType(Literal l) {
        if (l.getDatatype().equals(XSD.LONG)) {
            return l.longValue();
        }
        if (l.getDatatype().equals(XSD.INT) || l.getDatatype().equals(XSD.INTEGER)) {
            return l.intValue();
        }
        if (l.getDatatype().equals(XSD.DECIMAL)) {
            return l.decimalValue();
        }
        if (l.getDatatype().equals(XSD.FLOAT)) {
            return Float.valueOf(l.floatValue());
        }
        if (l.getDatatype().equals(XSD.DOUBLE)) {
            return l.doubleValue();
        }
        if (l.getDatatype().equals(XSD.BOOLEAN)) {
            return l.booleanValue();
        }
        return l.stringValue();
    }

    protected IRI getXSDType(String type) {
        if (type.equals("String")) {
            return XSD.STRING;
        }
        if (type.equals("Long")) {
            return XSD.INTEGER;
        }
        if (type.equals("Double")) {
            return XSD.DECIMAL;
        }
        if (type.equals("Boolean")) {
            return XSD.BOOLEAN;
        }
        if (type.equals("Date")) {
            return XSD.DATE;
        }
        if (type.equals("DateTime")) {
            return XSD.DATETIME;
        }
        if (type.equals("Point")) {
            return Params.WKTLITERAL_URI;
        }
        return XSD.STRING;
    }

    protected abstract boolean filterRelationship(Relationship var1, Map<Long, IRI> var2);

    protected abstract boolean filterNode(Node var1, Map<Long, IRI> var2);

    protected abstract void processPropOnRel(Set<Statement> var1, Statement var2, String var3, Object var4);

    protected abstract Set<Statement> processRelationship(Relationship var1, Map<Long, IRI> var2);

    protected abstract Set<Statement> processNode(Node var1, Map<Long, IRI> var2, String var3);

    public abstract Stream<Statement> streamTriplesFromTriplePattern(TriplePattern var1) throws InvalidNamespacePrefixDefinitionInDB;

    public abstract Stream<Statement> streamLocalImplicitOntology();
}

