/*
 * Decompiled with CFR 0.152.
 */
package n10s.rdf.delete;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.Iterators;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import n10s.RDFToLPGStatementProcessor;
import n10s.graphconfig.RDFParserConfig;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.logging.Log;

public class DirectStatementDeleter
extends RDFToLPGStatementProcessor {
    private static final Label RESOURCE = Label.label((String)"Resource");
    private final Cache<String, Node> nodeCache;
    private long notDeletedStatementCount;
    private long statementsWithBNodeCount;
    private String bNodeInfo;

    public DirectStatementDeleter(GraphDatabaseService db, Transaction tx, RDFParserConfig conf, Log l) {
        super(db, tx, conf, l);
        this.nodeCache = CacheBuilder.newBuilder().maximumSize(conf.getNodeCacheSize()).build();
        this.bNodeInfo = "";
        this.notDeletedStatementCount = 0L;
        this.statementsWithBNodeCount = 0L;
    }

    @Override
    public void endRDF() throws RDFHandlerException {
        this.periodicOperation();
        this.log.debug("Delete operation complete: Total number of triples deleted is " + this.totalTriplesMapped + " (out of " + this.totalTriplesParsed + " parsed)");
    }

    public Integer runPartialTx(Transaction inThreadTransaction) {
        for (Map.Entry entry : this.resourceLabels.entrySet()) {
            try {
                if (((String)entry.getKey()).startsWith("bnode://")) {
                    this.statementsWithBNodeCount += (long)(((Set)entry.getValue()).size() + 1);
                    continue;
                }
                Node tempNode = null;
                try {
                    tempNode = this.nodeCache.get((String)entry.getKey(), () -> inThreadTransaction.findNode(RESOURCE, "uri", entry.getKey()));
                }
                catch (CacheLoader.InvalidCacheLoadException icle) {
                    icle.printStackTrace();
                }
                Node node = tempNode;
                ((Set)entry.getValue()).forEach(l -> {
                    if (node != null && node.hasLabel(Label.label((String)l))) {
                        node.removeLabel(Label.label((String)l));
                    } else {
                        ++this.notDeletedStatementCount;
                    }
                });
                ((Map)this.resourceProps.get(entry.getKey())).forEach((k, v) -> {
                    if (v instanceof List) {
                        List valuesToDelete = (List)v;
                        if (node != null && node.hasProperty(k)) {
                            ArrayList<Object> newProps = new ArrayList<Object>();
                            Object prop = node.getProperty(k);
                            if (prop instanceof long[]) {
                                long[] props;
                                for (long currentVal : props = (long[])prop) {
                                    if (valuesToDelete.contains(currentVal)) continue;
                                    newProps.add(currentVal);
                                }
                            } else if (prop instanceof double[]) {
                                double[] props;
                                for (double currentVal : props = (double[])prop) {
                                    if (valuesToDelete.contains(currentVal)) continue;
                                    newProps.add(currentVal);
                                }
                            } else if (prop instanceof boolean[]) {
                                boolean[] props;
                                for (boolean currentVal : props = (boolean[])prop) {
                                    if (valuesToDelete.contains(currentVal)) continue;
                                    newProps.add(currentVal);
                                }
                            } else if (prop instanceof LocalDateTime[]) {
                                LocalDateTime[] props;
                                for (LocalDateTime currentVal : props = (LocalDateTime[])prop) {
                                    if (valuesToDelete.contains(currentVal)) continue;
                                    newProps.add(currentVal);
                                }
                            } else if (prop instanceof LocalDate[]) {
                                LocalDate[] props;
                                for (LocalDate currentVal : props = (LocalDate[])prop) {
                                    if (valuesToDelete.contains(currentVal)) continue;
                                    newProps.add(currentVal);
                                }
                            } else {
                                Object[] props;
                                for (Object currentVal : props = (Object[])prop) {
                                    if (valuesToDelete.contains(currentVal)) continue;
                                    newProps.add(currentVal);
                                }
                            }
                            node.removeProperty(k);
                            if (!newProps.isEmpty()) {
                                node.setProperty(k, this.toPropertyValue(newProps));
                            }
                        } else {
                            this.notDeletedStatementCount += (long)valuesToDelete.size();
                        }
                    } else if (node != null && node.hasProperty(k)) {
                        node.removeProperty(k);
                    } else {
                        ++this.notDeletedStatementCount;
                    }
                });
                if (node == null) continue;
                this.deleteNodeIfEmpty(node);
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        for (Statement st : this.statements) {
            try {
                if ((st.getSubject() instanceof IRI && st.getSubject().stringValue().startsWith("bnode://")) != (st.getObject() instanceof IRI && st.getObject().stringValue().startsWith("bnode://"))) {
                    ++this.statementsWithBNodeCount;
                }
                if (st.getSubject() instanceof IRI && st.getSubject().stringValue().startsWith("bnode://") || st.getObject() instanceof IRI && st.getObject().stringValue().startsWith("bnode://")) continue;
                Node fromNode = null;
                try {
                    fromNode = this.nodeCache.get(st.getSubject().stringValue(), () -> inThreadTransaction.findNode(RESOURCE, "uri", (Object)st.getSubject().stringValue()));
                }
                catch (CacheLoader.InvalidCacheLoadException icle) {
                    icle.printStackTrace();
                }
                Node toNode = null;
                try {
                    toNode = this.nodeCache.get(st.getObject().stringValue(), () -> inThreadTransaction.findNode(RESOURCE, "uri", (Object)st.getObject().stringValue()));
                }
                catch (CacheLoader.InvalidCacheLoadException icle) {
                    icle.printStackTrace();
                }
                if (fromNode == null || toNode == null) {
                    ++this.notDeletedStatementCount;
                    continue;
                }
                if (fromNode.getDegree(RelationshipType.withName((String)this.handleIRI(st.getPredicate(), 0)), Direction.OUTGOING) < toNode.getDegree(RelationshipType.withName((String)this.handleIRI(st.getPredicate(), 0)), Direction.INCOMING)) {
                    for (Relationship rel : fromNode.getRelationships(Direction.OUTGOING, new RelationshipType[]{RelationshipType.withName((String)this.handleIRI(st.getPredicate(), 0))})) {
                        if (!rel.getEndNode().equals(toNode)) continue;
                        rel.delete();
                        break;
                    }
                } else {
                    for (Relationship rel : toNode.getRelationships(Direction.INCOMING, new RelationshipType[]{RelationshipType.withName((String)this.handleIRI(st.getPredicate(), 0))})) {
                        if (!rel.getStartNode().equals(fromNode)) continue;
                        rel.delete();
                        break;
                    }
                }
                this.deleteNodeIfEmpty(toNode);
                this.deleteNodeIfEmpty(fromNode);
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        this.statements.clear();
        this.resourceLabels.clear();
        this.resourceProps.clear();
        this.nodeCache.invalidateAll();
        if (this.statementsWithBNodeCount > 0L) {
            this.setbNodeInfo(this.statementsWithBNodeCount + " of the statements could not be deleted, due to use of blank nodes.");
        }
        return 0;
    }

    @Override
    protected void periodicOperation() {
        try (Transaction tempTransaction = this.graphdb.beginTx();){
            this.runPartialTx(tempTransaction);
            tempTransaction.commit();
            this.totalTriplesMapped += this.mappedTripleCounter;
            this.log.debug("Successful partial commit of " + this.mappedTripleCounter + " triples. " + (this.totalTriplesMapped - this.notDeletedStatementCount) + " triples deleted so far...");
        }
        this.mappedTripleCounter = 0L;
    }

    public long getNotDeletedStatementCount() {
        return this.notDeletedStatementCount + this.statementsWithBNodeCount;
    }

    public String getbNodeInfo() {
        return this.bNodeInfo;
    }

    private void setbNodeInfo(String bNodeInfo) {
        this.bNodeInfo = bNodeInfo;
    }

    private void deleteNodeIfEmpty(Node node) {
        int nodePropertyCount = node.getAllProperties().size();
        int labelCount = Iterators.size(node.getLabels().iterator());
        if (!node.hasRelationship(Direction.OUTGOING) && !node.hasRelationship(Direction.INCOMING) && node.hasLabel(RESOURCE) && labelCount == 1 && node.getAllProperties().containsKey("uri") && nodePropertyCount == 1) {
            node.delete();
        }
    }
}

