/*
 * Decompiled with CFR 0.152.
 */
package n10s.rdf.aggregate;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.DynamicModel;
import org.eclipse.rdf4j.model.impl.LinkedHashModelFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.Rio;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.UserAggregationFunction;
import org.neo4j.procedure.UserAggregationResult;
import org.neo4j.procedure.UserAggregationUpdate;

public class CollectTriples {
    @UserAggregationFunction(name="n10s.rdf.collect")
    @Description(value="n10s.rdf.collect(subject,predicate,object,isLiteral,literalType,literalLang) - collects a set of triples as returned by n10s.rdf.export.* or n10s.rdf.stream.* and returns them serialised as N-triples")
    public TripleCollector collect() {
        return new TripleCollector(RDFFormat.NTRIPLES);
    }

    @UserAggregationFunction(name="n10s.rdf.collect.ttl")
    @Description(value="n10s.rdf.collect(subject,predicate,object,isLiteral,literalType,literalLang) - collects a set of triples as returned by n10s.rdf.export.* or n10s.rdf.stream.* and returns them serialised as Turtle")
    public TripleCollector collectTurtle() {
        return new TripleCollector(RDFFormat.TURTLE);
    }

    @UserAggregationFunction(name="n10s.rdf.collect.nt")
    @Description(value="n10s.rdf.collect(subject,predicate,object,isLiteral,literalType,literalLang) - collects a set of triples as returned by n10s.rdf.export.* or n10s.rdf.stream.* and returns them serialised as Turtle")
    public TripleCollector collectNTriples() {
        return new TripleCollector(RDFFormat.NTRIPLES);
    }

    @UserAggregationFunction(name="n10s.rdf.collect.xml")
    @Description(value="n10s.rdf.collect(subject,predicate,object,isLiteral,literalType,literalLang) - collects a set of triples as returned by n10s.rdf.export.* or n10s.rdf.stream.* and returns them serialised as RDF/XML")
    public TripleCollector collectRdfXml() {
        return new TripleCollector(RDFFormat.RDFXML);
    }

    @UserAggregationFunction(name="n10s.rdf.collect.json")
    @Description(value="n10s.rdf.collect(subject,predicate,object,isLiteral,literalType,literalLang) - collects a set of triples as returned by n10s.rdf.export.* or n10s.rdf.stream.* and returns them serialised as JSON-LD")
    public TripleCollector collectJson() {
        return new TripleCollector(RDFFormat.JSONLD);
    }

    @UserAggregationFunction(name="n10s.rdf.collect.ttlstar")
    @Description(value="n10s.rdf.collect(subject,predicate,object,isLiteral,literalType,literalLang) - collects a set of triples as returned by n10s.rdf.export.* or n10s.rdf.stream.* and returns them serialised as JSON-LD")
    public TripleCollector collectTurtleStar() {
        return new TripleCollector(RDFFormat.TURTLESTAR);
    }

    public static class TripleCollector {
        Model m = new DynamicModel(new LinkedHashModelFactory());
        ValueFactory vf = SimpleValueFactory.getInstance();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        private RDFFormat format;

        public TripleCollector(RDFFormat f) {
            this.format = f;
        }

        @UserAggregationUpdate
        public void addTriple(@Name(value="subject") String subject, @Name(value="predicate") String predicate, @Name(value="object") String object, @Name(value="isLiteral") Boolean isLiteral, @Name(value="literalType") String literalType, @Name(value="literalLang") String literalLang, @Name(value="sspo", defaultValue="null") List<String> sspo) {
            Resource s = sspo == null ? (subject.indexOf(58) < 0 ? this.vf.createBNode(subject) : this.vf.createIRI(subject)) : this.vf.createTriple(sspo.get(0).indexOf(58) < 0 ? this.vf.createBNode(sspo.get(0)) : this.vf.createIRI(sspo.get(0)), this.vf.createIRI(sspo.get(1)), sspo.get(2).indexOf(58) < 0 ? this.vf.createBNode(sspo.get(2)) : this.vf.createIRI(sspo.get(2)));
            IRI p = this.vf.createIRI(predicate);
            if (isLiteral.booleanValue()) {
                Literal o = literalType.equals(RDF.LANGSTRING.stringValue()) ? this.vf.createLiteral(object, literalLang) : this.vf.createLiteral(object, this.vf.createIRI(literalType));
                this.m.add(s, p, o, new Resource[0]);
            } else {
                Resource o = object.indexOf(58) < 0 ? this.vf.createBNode(object) : this.vf.createIRI(object);
                this.m.add(s, p, o, new Resource[0]);
            }
        }

        @UserAggregationResult
        public String result() {
            try {
                Rio.write((Iterable<Statement>)this.m, (OutputStream)this.baos, this.format);
                String string = this.baos.toString();
                return string;
            }
            finally {
                try {
                    this.baos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

