/*
 * Decompiled with CFR 0.152.
 */
package n10s.onto;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import n10s.RDFToLPGStatementProcessor;
import n10s.graphconfig.RDFParserConfig;
import n10s.onto.OWLRestriction;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.vocabulary.OWL;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.model.vocabulary.SKOS;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.logging.Log;

public class OntologyImporter
extends RDFToLPGStatementProcessor {
    protected static final int SUB_CLASS_REST = 0;
    protected static final int EQUIV_CLASS_REST = 1;
    public static final Label RESOURCE = Label.label((String)"Resource");
    protected static final List<IRI> ANNOTATION_PROPERTIES_TO_IMPORT = Arrays.asList(RDFS.LABEL, RDFS.COMMENT, SKOS.PREF_LABEL, SKOS.ALT_LABEL, SKOS.DEFINITION);
    protected static final List<IRI> PROPERTY_DECORATIONS_TO_IMPORT = Arrays.asList(OWL.TRANSITIVEPROPERTY, OWL.INVERSEFUNCTIONALPROPERTY, OWL.SYMMETRICPROPERTY, OWL.FUNCTIONALPROPERTY);
    protected Set<Statement> extraStatements = new HashSet<Statement>();
    protected Map<BNode, OWLRestriction> allOpenRestrictions = new HashMap<BNode, OWLRestriction>();
    protected Map<IRI, List<OWLRestriction>> openSubClassRestrictions = new HashMap<IRI, List<OWLRestriction>>();
    protected Map<IRI, List<OWLRestriction>> openEquivRestrictions = new HashMap<IRI, List<OWLRestriction>>();
    Cache<String, Node> nodeCache;

    public OntologyImporter(GraphDatabaseService db, Transaction tx, RDFParserConfig conf, Log l) {
        super(db, tx, conf, l);
        this.nodeCache = CacheBuilder.newBuilder().maximumSize(conf.getNodeCacheSize()).build();
    }

    @Override
    protected void periodicOperation() {
        block18: {
            Transaction tempTransaction;
            block17: {
                if (this.parserConfig.getGraphConf().getHandleVocabUris() == 0) {
                    try {
                        tempTransaction = this.graphdb.beginTx();
                        try {
                            this.namespaces.partialRefresh(tempTransaction);
                            tempTransaction.commit();
                            this.log.debug("namespace prefixes synced: " + this.namespaces.toString());
                        }
                        finally {
                            if (tempTransaction != null) {
                                tempTransaction.close();
                            }
                        }
                    }
                    catch (Exception e) {
                        this.log.error("Problems syncing up namespace prefixes in partial commit. ", (Throwable)e);
                        if (!this.getParserConfig().isAbortOnError()) break block17;
                        throw new RDFToLPGStatementProcessor.NamespacePrefixConflict(this, "Problems syncing up namespace prefixes in partial commit. ", e);
                    }
                }
            }
            try {
                tempTransaction = this.graphdb.beginTx();
                try {
                    this.runPartialTx(tempTransaction);
                    tempTransaction.commit();
                    this.log.debug("partial commit: " + this.mappedTripleCounter + " triples ingested. Total so far: " + this.totalTriplesMapped);
                    this.totalTriplesMapped += this.mappedTripleCounter;
                }
                finally {
                    if (tempTransaction != null) {
                        tempTransaction.close();
                    }
                }
            }
            catch (Exception e) {
                this.log.error("Problems when running partial commit. Partial transaction rolled back. " + this.mappedTripleCounter + " triples lost.", (Throwable)e);
                if (!this.getParserConfig().isAbortOnError()) break block18;
                throw new RDFToLPGStatementProcessor.PartialCommitException(this, "Problems when running partial commit. Partial transaction rolled back. ", e);
            }
        }
        this.mappedTripleCounter = 0L;
    }

    @Override
    public void startRDF() throws RDFHandlerException {
        super.startRDF();
        if (this.parserConfig.getGraphConf().getHandleVocabUris() == 0 || this.parserConfig.getGraphConf().getHandleVocabUris() == 1) {
            this.namespaces.add(this.parserConfig.getGraphConf().getBaseSchemaNamespacePrefix(), this.parserConfig.getGraphConf().getBaseSchemaNamespace());
            this.log.debug("Added schema ns and prefix " + this.parserConfig.getGraphConf().getBaseSchemaNamespacePrefix() + ": " + this.parserConfig.getGraphConf().getBaseSchemaNamespace());
        }
    }

    @Override
    public void endRDF() throws RDFHandlerException {
        this.periodicOperation();
        int unusedExtra = 0;
        for (Map.Entry entry : this.resourceProps.entrySet()) {
            for (Map.Entry values : ((Map)entry.getValue()).entrySet()) {
                if (values.getValue() instanceof List) {
                    unusedExtra += ((List)values.getValue()).size();
                    continue;
                }
                ++unusedExtra;
            }
        }
        this.totalTriplesMapped -= (long)unusedExtra;
        this.statements.clear();
        this.resourceLabels.clear();
        this.resourceProps.clear();
    }

    @Override
    public void handleStatement(Statement st) {
        if (this.parserConfig.getPredicateExclusionList() == null || !this.parserConfig.getPredicateExclusionList().contains(st.getPredicate().stringValue())) {
            if (st.getPredicate().equals(RDF.TYPE) && (st.getObject().equals(RDFS.CLASS) || st.getObject().equals(OWL.CLASS)) && st.getSubject() instanceof IRI) {
                this.instantiate(this.vf.createIRI(this.parserConfig.getGraphConf().getBaseSchemaNamespace(), this.parserConfig.getGraphConf().getClassLabelName()), (IRI)st.getSubject());
                ++this.mappedTripleCounter;
            } else if (st.getPredicate().equals(RDF.TYPE) && (st.getObject().equals(RDF.PROPERTY) || st.getObject().equals(OWL.OBJECTPROPERTY)) && st.getSubject() instanceof IRI) {
                this.instantiate(this.vf.createIRI(this.parserConfig.getGraphConf().getBaseSchemaNamespace(), this.parserConfig.getGraphConf().getObjectPropertyLabelName()), (IRI)st.getSubject());
                ++this.mappedTripleCounter;
            } else if (st.getPredicate().equals(RDF.TYPE) && st.getObject().equals(OWL.DATATYPEPROPERTY) && st.getSubject() instanceof IRI) {
                this.instantiate(this.vf.createIRI(this.parserConfig.getGraphConf().getBaseSchemaNamespace(), this.parserConfig.getGraphConf().getDataTypePropertyLabelName()), (IRI)st.getSubject());
                ++this.mappedTripleCounter;
            } else if (st.getPredicate().equals(RDFS.SUBCLASSOF) && st.getSubject() instanceof IRI) {
                if (st.getObject() instanceof IRI) {
                    this.instantiatePair("Resource", (IRI)st.getSubject(), "Resource", (IRI)st.getObject());
                    this.addStatement(st);
                } else if (st.getObject() instanceof BNode) {
                    this.instantiate(this.vf.createIRI(this.parserConfig.getGraphConf().getBaseSchemaNamespace(), this.parserConfig.getGraphConf().getClassLabelName()), (IRI)st.getSubject());
                    ++this.mappedTripleCounter;
                    this.addLinkToClass((IRI)st.getSubject(), (BNode)st.getObject(), this.openSubClassRestrictions);
                }
                ++this.mappedTripleCounter;
            } else if (st.getPredicate().equals(OWL.EQUIVALENTCLASS) && st.getSubject() instanceof IRI) {
                if (st.getObject() instanceof IRI) {
                    this.instantiatePair("Resource", (IRI)st.getSubject(), "Resource", (IRI)st.getObject());
                    this.addStatement(st);
                } else if (st.getObject() instanceof BNode) {
                    this.instantiate(this.vf.createIRI(this.parserConfig.getGraphConf().getBaseSchemaNamespace(), this.parserConfig.getGraphConf().getClassLabelName()), (IRI)st.getSubject());
                    ++this.mappedTripleCounter;
                    this.addLinkToClass((IRI)st.getSubject(), (BNode)st.getObject(), this.openEquivRestrictions);
                }
                ++this.mappedTripleCounter;
            } else if (st.getPredicate().equals(OWL.ONPROPERTY) && st.getSubject() instanceof BNode && st.getObject() instanceof IRI) {
                this.instantiate(this.vf.createIRI(this.parserConfig.getGraphConf().getBaseSchemaNamespace(), this.parserConfig.getGraphConf().getObjectPropertyLabelName()), (IRI)st.getObject());
                this.addRelToRestriction((BNode)st.getSubject(), (IRI)st.getObject());
                ++this.mappedTripleCounter;
            } else if (st.getPredicate().equals(OWL.SOMEVALUESFROM) && st.getSubject() instanceof BNode && st.getObject() instanceof IRI) {
                this.instantiate(this.vf.createIRI(this.parserConfig.getGraphConf().getBaseSchemaNamespace(), this.parserConfig.getGraphConf().getClassLabelName()), (IRI)st.getObject());
                this.addTargetToRestriction((BNode)st.getSubject(), (IRI)st.getObject(), OWL.SOMEVALUESFROM);
                ++this.mappedTripleCounter;
            } else if (st.getPredicate().equals(OWL.ALLVALUESFROM) && st.getSubject() instanceof BNode && st.getObject() instanceof IRI) {
                this.instantiate(this.vf.createIRI(this.parserConfig.getGraphConf().getBaseSchemaNamespace(), this.parserConfig.getGraphConf().getClassLabelName()), (IRI)st.getObject());
                this.addTargetToRestriction((BNode)st.getSubject(), (IRI)st.getObject(), OWL.ALLVALUESFROM);
                ++this.mappedTripleCounter;
            } else if ((st.getPredicate().equals(OWL.CARDINALITY) || st.getPredicate().equals(OWL.MAXCARDINALITY) || st.getPredicate().equals(OWL.MAXQUALIFIEDCARDINALITY) || st.getPredicate().equals(OWL.MINCARDINALITY) || st.getPredicate().equals(OWL.MINQUALIFIEDCARDINALITY) || st.getPredicate().equals(OWL.QUALIFIEDCARDINALITY)) && st.getSubject() instanceof BNode && st.getObject() instanceof Literal) {
                this.addValueToCardinalityRestriction((BNode)st.getSubject(), (Literal)st.getObject(), st.getPredicate());
                ++this.mappedTripleCounter;
            } else if (st.getPredicate().equals(OWL.ONCLASS) && st.getSubject() instanceof BNode && st.getObject() instanceof IRI) {
                this.instantiate(this.vf.createIRI(this.parserConfig.getGraphConf().getBaseSchemaNamespace(), this.parserConfig.getGraphConf().getClassLabelName()), (IRI)st.getObject());
                this.addTargetToRestriction((BNode)st.getSubject(), (IRI)st.getObject(), OWL.ONCLASS);
                ++this.mappedTripleCounter;
            } else if (st.getPredicate().equals(RDFS.SUBPROPERTYOF) && st.getObject() instanceof IRI && st.getSubject() instanceof IRI) {
                this.instantiatePair("Resource", (IRI)st.getSubject(), "Resource", (IRI)st.getObject());
                this.addStatement(st);
                ++this.mappedTripleCounter;
            } else if (st.getPredicate().equals(RDFS.DOMAIN) && st.getObject() instanceof IRI && st.getSubject() instanceof IRI) {
                this.instantiatePair("Resource", (IRI)st.getSubject(), "Resource", (IRI)st.getObject());
                this.addStatement(st);
                ++this.mappedTripleCounter;
            } else if (st.getPredicate().equals(RDFS.RANGE) && st.getObject() instanceof IRI && st.getSubject() instanceof IRI) {
                this.instantiatePair("Resource", (IRI)st.getSubject(), "Resource", (IRI)st.getObject());
                this.addStatement(st);
                ++this.mappedTripleCounter;
            } else if (ANNOTATION_PROPERTIES_TO_IMPORT.contains(st.getPredicate()) && st.getSubject() instanceof IRI) {
                this.setProp(st.getSubject().stringValue(), this.vf.createIRI(this.parserConfig.getGraphConf().getBaseSchemaNamespace(), st.getPredicate().getLocalName()), (Literal)st.getObject());
                ++this.mappedTripleCounter;
            } else if (st.getPredicate().equals(RDF.TYPE) && PROPERTY_DECORATIONS_TO_IMPORT.contains(st.getObject()) && st.getSubject() instanceof IRI) {
                this.setProp(st.getSubject().stringValue(), this.vf.createIRI(this.parserConfig.getGraphConf().getBaseSchemaNamespace(), "propCharacteristics"), this.vf.createLiteral(((IRI)st.getObject()).getLocalName().substring(0, ((IRI)st.getObject()).getLocalName().indexOf("Property"))));
                ++this.mappedTripleCounter;
            }
        }
        ++this.totalTriplesParsed;
        if (this.parserConfig.getCommitSize() != Long.MAX_VALUE && this.mappedTripleCounter != 0L && this.mappedTripleCounter % this.parserConfig.getCommitSize() == 0L) {
            this.periodicOperation();
        }
    }

    private void addValueToCardinalityRestriction(BNode rId, Literal cardinalityValue, IRI type) {
        OWLRestriction restr = this.allOpenRestrictions.containsKey(rId) ? this.allOpenRestrictions.get(rId) : new OWLRestriction(rId);
        restr.setCardinalityValue(cardinalityValue);
        restr.setCardinalitySpecificType(type);
        if (!this.allOpenRestrictions.containsKey(rId)) {
            this.allOpenRestrictions.put(rId, restr);
        }
    }

    private void addTargetToRestriction(BNode rId, IRI target, IRI type) {
        OWLRestriction restr = this.allOpenRestrictions.containsKey(rId) ? this.allOpenRestrictions.get(rId) : new OWLRestriction(rId);
        restr.setTarget(target);
        restr.setType(type);
        if (!this.allOpenRestrictions.containsKey(rId)) {
            this.allOpenRestrictions.put(rId, restr);
        }
    }

    private void addRelToRestriction(BNode rId, IRI relName) {
        OWLRestriction restr = this.allOpenRestrictions.containsKey(rId) ? this.allOpenRestrictions.get(rId) : new OWLRestriction(rId);
        restr.setRelName(relName);
        if (!this.allOpenRestrictions.containsKey(rId)) {
            this.allOpenRestrictions.put(rId, restr);
        }
    }

    private void addLinkToClass(IRI subject, BNode rId, Map<IRI, List<OWLRestriction>> mapofLists) {
        OWLRestriction restr;
        OWLRestriction oWLRestriction = restr = this.allOpenRestrictions.containsKey(rId) ? this.allOpenRestrictions.get(rId) : new OWLRestriction(rId);
        if (!this.allOpenRestrictions.containsKey(rId)) {
            this.allOpenRestrictions.put(rId, restr);
        }
        if (mapofLists.containsKey(subject)) {
            mapofLists.get(subject).add(restr);
        } else {
            ArrayList<OWLRestriction> owlRestrictionList = new ArrayList<OWLRestriction>();
            owlRestrictionList.add(restr);
            mapofLists.put(subject, owlRestrictionList);
        }
    }

    private void instantiate(IRI label, IRI iri) {
        this.setLabel(iri.stringValue(), this.handleIRI(label, 1));
        ((Map)this.resourceProps.get(iri.stringValue())).put(this.handleIRI(this.vf.createIRI(this.parserConfig.getGraphConf().getBaseSchemaNamespace(), "name"), 2), iri.getLocalName());
    }

    private void instantiatePair(String label1, IRI iri1, String label2, IRI iri2) {
        this.setLabel(iri1.stringValue(), label1);
        ((Map)this.resourceProps.get(iri1.stringValue())).put(this.handleIRI(this.vf.createIRI(this.parserConfig.getGraphConf().getBaseSchemaNamespace(), "name"), 2), iri1.getLocalName());
        this.setLabel(iri2.stringValue(), label2);
        ((Map)this.resourceProps.get(iri2.stringValue())).put(this.handleIRI(this.vf.createIRI(this.parserConfig.getGraphConf().getBaseSchemaNamespace(), "name"), 2), iri2.getLocalName());
    }

    public Integer runPartialTx(final Transaction inThreadTransaction) {
        for (final Map.Entry entry : this.resourceLabels.entrySet()) {
            try {
                if (((Set)entry.getValue()).isEmpty()) continue;
                Node node = this.nodeCache.get((String)entry.getKey(), new Callable<Node>(){

                    @Override
                    public Node call() {
                        Node node = inThreadTransaction.findNode(RESOURCE, "uri", entry.getKey());
                        if (node == null) {
                            node = inThreadTransaction.createNode(new Label[]{RESOURCE});
                            node.setProperty("uri", entry.getKey());
                        }
                        return node;
                    }
                });
                ((Set)entry.getValue()).forEach(l -> node.addLabel(Label.label((String)l)));
                ((Map)this.resourceProps.get(entry.getKey())).forEach((k, v) -> {
                    if (v instanceof List) {
                        Object currentValue = node.getProperty(k, null);
                        if (currentValue == null) {
                            node.setProperty(k, this.toPropertyValue(v));
                        } else {
                            if (currentValue.getClass().isArray()) {
                                Object[] properties;
                                for (Object property : properties = (Object[])currentValue) {
                                    ((List)v).add(property);
                                }
                            } else {
                                ((List)v).add(node.getProperty(k));
                            }
                            node.setProperty(k, this.toPropertyValue(((List)v).stream().collect(Collectors.toSet())));
                        }
                    } else {
                        node.setProperty(k, v);
                    }
                });
                this.resourceProps.remove(entry.getKey());
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        for (Map.Entry<IRI, List<OWLRestriction>> classAndRestrictions : this.openSubClassRestrictions.entrySet()) {
            Iterator<OWLRestriction> restIter = classAndRestrictions.getValue().iterator();
            while (restIter.hasNext()) {
                OWLRestriction rest = restIter.next();
                if (!rest.isComplete()) continue;
                this.processRestriction(inThreadTransaction, classAndRestrictions.getKey(), rest, 0);
                this.allOpenRestrictions.remove(rest.getRestrictionId());
                restIter.remove();
            }
        }
        Iterator<Map.Entry<IRI, List<OWLRestriction>>> eqcRestIter = this.openEquivRestrictions.entrySet().iterator();
        while (eqcRestIter.hasNext()) {
            Map.Entry<IRI, List<OWLRestriction>> classAndRestrictions = eqcRestIter.next();
            for (OWLRestriction rest : classAndRestrictions.getValue()) {
                if (!rest.isComplete()) continue;
                this.processRestriction(inThreadTransaction, classAndRestrictions.getKey(), rest, 1);
                this.allOpenRestrictions.remove(rest.getRestrictionId());
                eqcRestIter.remove();
            }
        }
        for (final Statement st : this.statements) {
            try {
                Node fromNode = this.nodeCache.get(st.getSubject().stringValue(), new Callable<Node>(){

                    @Override
                    public Node call() {
                        return inThreadTransaction.findNode(RESOURCE, "uri", (Object)st.getSubject().stringValue());
                    }
                });
                Node toNode = this.nodeCache.get(st.getObject().stringValue(), new Callable<Node>(){

                    @Override
                    public Node call() {
                        return inThreadTransaction.findNode(RESOURCE, "uri", (Object)st.getObject().stringValue());
                    }
                });
                boolean found = false;
                if (fromNode.getDegree(RelationshipType.withName((String)this.handleIRI(this.translateRelName(st.getPredicate()), 0)), Direction.OUTGOING) < toNode.getDegree(RelationshipType.withName((String)this.handleIRI(this.translateRelName(st.getPredicate()), 0)), Direction.INCOMING)) {
                    for (Relationship rel : fromNode.getRelationships(Direction.OUTGOING, new RelationshipType[]{RelationshipType.withName((String)this.handleIRI(this.translateRelName(st.getPredicate()), 0))})) {
                        if (!rel.getEndNode().equals(toNode)) continue;
                        found = true;
                        break;
                    }
                } else {
                    for (Relationship rel : toNode.getRelationships(Direction.INCOMING, new RelationshipType[]{RelationshipType.withName((String)this.handleIRI(this.translateRelName(st.getPredicate()), 0))})) {
                        if (!rel.getStartNode().equals(fromNode)) continue;
                        found = true;
                        break;
                    }
                }
                if (found) continue;
                fromNode.createRelationshipTo(toNode, RelationshipType.withName((String)this.handleIRI(this.translateRelName(st.getPredicate()), 0)));
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        this.statements.clear();
        this.resourceLabels.clear();
        this.nodeCache.invalidateAll();
        return 0;
    }

    private void processRestriction(final Transaction tx, final IRI c, final OWLRestriction rest, int type) {
        try {
            Node fromNode = this.nodeCache.get(c.stringValue(), new Callable<Node>(){

                @Override
                public Node call() {
                    return tx.findNode(RESOURCE, "uri", (Object)c.stringValue());
                }
            });
            Node toNode = this.nodeCache.get(rest.getTargetClass().stringValue(), new Callable<Node>(){

                @Override
                public Node call() {
                    return tx.findNode(RESOURCE, "uri", (Object)rest.getTargetClass().stringValue());
                }
            });
            boolean found = false;
            for (Relationship rel : fromNode.getRelationships(Direction.OUTGOING, new RelationshipType[]{RelationshipType.withName((String)this.handleIRI(this.vf.createIRI("neo4j://graph.schema#" + this.getRestrictionRelName(type)), 0))})) {
                if (!rel.getEndNode().equals(toNode)) continue;
                found = rel.getProperty("onPropertyURI").equals(rest.getRelName().stringValue()) && rel.getProperty("onPropertyName").equals(rest.getRelName().getLocalName()) && rel.getProperty("restrictionType").equals(this.getTypeAsString(rest)) && (!rel.hasProperty("cardinalityVal") && !rest.isCardinalityConstraint() || rel.getProperty("cardinalityVal").equals(rest.getCardinalityVal()));
                break;
            }
            if (!found) {
                Relationship restrictionRel = fromNode.createRelationshipTo(toNode, RelationshipType.withName((String)this.handleIRI(this.vf.createIRI("neo4j://graph.schema#" + this.getRestrictionRelName(type)), 0)));
                restrictionRel.setProperty("onPropertyURI", (Object)rest.getRelName().stringValue());
                restrictionRel.setProperty("onPropertyName", (Object)rest.getRelName().getLocalName());
                restrictionRel.setProperty("restrictionType", (Object)this.getTypeAsString(rest));
                if (rest.isCardinalityConstraint()) {
                    restrictionRel.setProperty("cardinalityVal", (Object)rest.getCardinalityVal());
                }
            }
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    protected String getRestrictionRelName(int type) {
        String relName;
        switch (type) {
            case 0: {
                relName = "SCO_RESTRICTION";
                break;
            }
            case 1: {
                relName = "EQC_RESTRICTION";
                break;
            }
            default: {
                relName = "RESTRICTION";
            }
        }
        return relName;
    }

    protected String getTypeAsString(OWLRestriction rest) {
        if (rest.getType().equals(OWL.SOMEVALUESFROM)) {
            return "SOME";
        }
        if (rest.getType().equals(OWL.ALLVALUESFROM)) {
            return "ALL";
        }
        if (rest.isCardinalityConstraint()) {
            return rest.getCardinalityType().getLocalName().toUpperCase();
        }
        return "UNKNOWN";
    }

    protected IRI translateRelName(IRI iri) {
        if (iri.equals(RDFS.SUBCLASSOF)) {
            return this.vf.createIRI(this.parserConfig.getGraphConf().getBaseSchemaNamespace(), this.parserConfig.getGraphConf().getSubClassOfRelName());
        }
        if (iri.equals(RDFS.SUBPROPERTYOF)) {
            return this.vf.createIRI(this.parserConfig.getGraphConf().getBaseSchemaNamespace(), this.parserConfig.getGraphConf().getSubPropertyOfRelName());
        }
        if (iri.equals(OWL.EQUIVALENTCLASS)) {
            return this.vf.createIRI(this.parserConfig.getGraphConf().getBaseSchemaNamespace(), "EQC");
        }
        if (iri.equals(RDFS.DOMAIN)) {
            return this.vf.createIRI(this.parserConfig.getGraphConf().getBaseSchemaNamespace(), this.parserConfig.getGraphConf().getDomainRelName());
        }
        if (iri.equals(RDFS.RANGE)) {
            return this.vf.createIRI(this.parserConfig.getGraphConf().getBaseSchemaNamespace(), this.parserConfig.getGraphConf().getRangeRelName());
        }
        return this.vf.createIRI(this.parserConfig.getGraphConf().getBaseSchemaNamespace(), "REL");
    }
}

