/*
 * Decompiled with CFR 0.152.
 */
package n10s.endpoint;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import n10s.graphconfig.GraphConfig;
import n10s.mapping.MappingUtils;
import n10s.rdf.export.ExportProcessor;
import n10s.rdf.export.LPGRDFToRDFProcesssor;
import n10s.rdf.export.LPGToRDFProcesssor;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.helpers.JSONLDMode;
import org.eclipse.rdf4j.rio.helpers.JSONLDSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Transaction;

@Path(value="/")
public class RDFEndpoint {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final String DEFAULT_DB_NAME = "neo4j";
    private static RDFFormat[] availableParsers = new RDFFormat[]{RDFFormat.RDFXML, RDFFormat.JSONLD, RDFFormat.TURTLE, RDFFormat.NTRIPLES, RDFFormat.TRIG, RDFFormat.NQUADS, RDFFormat.TURTLESTAR, RDFFormat.TRIGSTAR};

    @GET
    @Path(value="/ping")
    public Response ping() throws IOException {
        HashMap<String, String> results = new HashMap<String, String>(){
            {
                this.put("ping", "here!");
            }
        };
        return Response.ok().entity((Object)objectMapper.writeValueAsString((Object)results)).build();
    }

    @GET
    @Path(value="/{dbname}/describe/{nodeidentifier}")
    @Produces(value={"application/rdf+xml", "text/plain", "text/turtle", "text/n3", "application/trig", "application/ld+json", "application/n-quads", "text/x-turtlestar", "application/x-trigstar"})
    public Response nodebyIdOrUri(@Context DatabaseManagementService gds, @PathParam(value="dbname") String dbNameParam, @PathParam(value="nodeidentifier") String nodeIdentifier, @QueryParam(value="graphuri") String namedGraphId, @QueryParam(value="excludeContext") String excludeContextParam, @QueryParam(value="mappedElemsOnly") String onlyMappedInfo, @QueryParam(value="format") String format, @HeaderParam(value="accept") String acceptHeaderParam) {
        return Response.ok().entity(outputStream -> {
            RDFWriter writer = this.startRdfWriter(this.getFormat(acceptHeaderParam, format), outputStream);
            GraphDatabaseService neo4j = gds.database(dbNameParam);
            try (Transaction tx = neo4j.beginTx();){
                GraphConfig gc = this.getGraphConfig(tx);
                if (gc == null || gc.getHandleVocabUris() == 2 || gc.getHandleVocabUris() == 3) {
                    MappingUtils.getPrefixesFromMappingDefinitions(neo4j).forEach((pref, ns) -> writer.handleNamespace((String)pref, (String)ns));
                    writer.handleNamespace(gc != null ? gc.getBaseSchemaNamespacePrefix() : "n4sch", gc != null ? gc.getBaseSchemaNamespace() : "neo4j://graph.schema#");
                    if (gc == null) {
                        writer.handleNamespace("n4ind", "neo4j://graph.individuals#");
                    }
                    LPGToRDFProcesssor proc = new LPGToRDFProcesssor(neo4j, tx, gc, MappingUtils.getExportMappingsFromDB(neo4j), onlyMappedInfo != null, this.isRdfStarSerialisation(writer.getRDFFormat()));
                    try {
                        long nodeid = Long.parseLong(nodeIdentifier);
                        proc.streamNodeById(nodeid, excludeContextParam == null).forEach(writer::handleStatement);
                    }
                    catch (NumberFormatException e) {
                        proc.streamNodeByUri(nodeIdentifier, excludeContextParam == null).forEach(writer::handleStatement);
                    }
                } else {
                    MappingUtils.getPrefixesInUse(neo4j).forEach((pref, ns) -> writer.handleNamespace((String)pref, (String)ns));
                    LPGRDFToRDFProcesssor proc = new LPGRDFToRDFProcesssor(neo4j, tx, gc, this.isRdfStarSerialisation(writer.getRDFFormat()));
                    proc.streamNodeByUri(nodeIdentifier, namedGraphId, excludeContextParam != null).forEach(writer::handleStatement);
                }
                this.endRDFWriter(writer);
            }
            catch (NotFoundException e) {
                writer.endRDF();
            }
            catch (Exception e) {
                this.handleSerialisationError(outputStream, e, acceptHeaderParam, format);
            }
        }).build();
    }

    private GraphConfig getGraphConfig(Transaction tx) {
        GraphConfig result = null;
        try {
            result = new GraphConfig(tx);
        }
        catch (GraphConfig.GraphConfigNotFound graphConfigNotFound) {
            // empty catch block
        }
        return result;
    }

    @GET
    @Path(value="/{dbname}/describe/find/{label}/{property}/{propertyValue}")
    @Produces(value={"application/rdf+xml", "text/plain", "text/turtle", "text/n3", "application/trig", "application/ld+json", "application/n-quads", "text/x-turtlestar", "application/x-trigstar"})
    public Response nodefind(@Context DatabaseManagementService gds, @PathParam(value="dbname") String dbNameParam, @PathParam(value="label") String label, @PathParam(value="property") String property, @PathParam(value="propertyValue") String propVal, @QueryParam(value="valType") String valType, @QueryParam(value="excludeContext") String excludeContextParam, @QueryParam(value="mappedElemsOnly") String onlyMappedInfo, @QueryParam(value="format") String format, @HeaderParam(value="accept") String acceptHeaderParam) {
        return Response.ok().entity(outputStream -> {
            RDFWriter writer = this.startRdfWriter(this.getFormat(acceptHeaderParam, format), outputStream);
            GraphDatabaseService neo4j = gds.database(dbNameParam);
            try (Transaction tx = neo4j.beginTx();){
                ExportProcessor proc;
                GraphConfig gc = this.getGraphConfig(tx);
                if (gc == null || gc.getHandleVocabUris() == 2 || gc.getHandleVocabUris() == 3) {
                    MappingUtils.getPrefixesFromMappingDefinitions(neo4j).forEach((pref, ns) -> writer.handleNamespace((String)pref, (String)ns));
                    writer.handleNamespace(gc != null ? gc.getBaseSchemaNamespacePrefix() : "n4sch", gc != null ? gc.getBaseSchemaNamespace() : "neo4j://graph.schema#");
                    if (gc == null) {
                        writer.handleNamespace("n4ind", "neo4j://graph.individuals#");
                    }
                    proc = new LPGToRDFProcesssor(neo4j, tx, gc, MappingUtils.getExportMappingsFromDB(neo4j), onlyMappedInfo != null, this.isRdfStarSerialisation(writer.getRDFFormat()));
                } else {
                    MappingUtils.getPrefixesFromMappingDefinitions(neo4j).forEach((pref, ns) -> writer.handleNamespace((String)pref, (String)ns));
                    proc = new LPGRDFToRDFProcesssor(neo4j, tx, gc, this.isRdfStarSerialisation(writer.getRDFFormat()));
                }
                proc.streamNodesBySearch(label, property, propVal, valType, excludeContextParam == null).forEach(writer::handleStatement);
                this.endRDFWriter(writer);
            }
            catch (Exception e) {
                this.handleSerialisationError(outputStream, e, acceptHeaderParam, format);
            }
        }).build();
    }

    @POST
    @Path(value="/{dbname}/cypher")
    @Produces(value={"application/rdf+xml", "text/plain", "text/turtle", "text/n3", "application/trig", "application/ld+json", "application/n-quads", "text/x-turtlestar", "application/x-trigstar"})
    public Response cypher(@Context DatabaseManagementService gds, @PathParam(value="dbname") String dbNameParam, @HeaderParam(value="accept") String acceptHeaderParam, String body) {
        return Response.ok().entity(outputStream -> {
            Map jsonMap = (Map)objectMapper.readValue(body, (TypeReference)new TypeReference<Map<String, Object>>(){});
            GraphDatabaseService neo4j = gds.database(dbNameParam);
            try (Transaction tx = neo4j.beginTx();){
                ExportProcessor proc;
                RDFWriter writer = this.startRdfWriter(this.getFormat(acceptHeaderParam, (String)jsonMap.get("format")), outputStream);
                GraphConfig gc = this.getGraphConfig(tx);
                if (gc == null || gc.getHandleVocabUris() == 2 || gc.getHandleVocabUris() == 3) {
                    MappingUtils.getPrefixesFromMappingDefinitions(neo4j).forEach((pref, ns) -> writer.handleNamespace((String)pref, (String)ns));
                    writer.handleNamespace(gc != null ? gc.getBaseSchemaNamespacePrefix() : "n4sch", gc != null ? gc.getBaseSchemaNamespace() : "neo4j://graph.schema#");
                    if (gc == null) {
                        writer.handleNamespace("n4ind", "neo4j://graph.individuals#");
                    }
                    proc = new LPGToRDFProcesssor(neo4j, tx, gc, MappingUtils.getExportMappingsFromDB(neo4j), jsonMap.containsKey("mappedElemsOnly"), this.isRdfStarSerialisation(writer.getRDFFormat()));
                } else {
                    MappingUtils.getPrefixesInUse(neo4j).forEach((pref, ns) -> writer.handleNamespace((String)pref, (String)ns));
                    proc = new LPGRDFToRDFProcesssor(neo4j, tx, gc, this.isRdfStarSerialisation(writer.getRDFFormat()));
                }
                proc.streamTriplesFromCypher((String)jsonMap.get("cypher"), jsonMap.getOrDefault("cypherParams", new HashMap())).forEach(writer::handleStatement);
                this.endRDFWriter(writer);
            }
            catch (Exception e) {
                this.handleSerialisationError(outputStream, e, acceptHeaderParam, (String)jsonMap.get("format"));
            }
        }).build();
    }

    private boolean isRdfStarSerialisation(RDFFormat rdfFormat) {
        return rdfFormat.equals(RDFFormat.TURTLESTAR) || rdfFormat.equals(RDFFormat.TRIGSTAR);
    }

    @GET
    @Path(value="/{dbname}/onto")
    @Produces(value={"application/rdf+xml", "text/plain", "text/turtle", "text/n3", "application/trig", "application/ld+json", "application/n-quads", "text/x-turtlestar", "application/x-trigstar"})
    public Response exportOnto(@Context DatabaseManagementService gds, @PathParam(value="dbname") String dbNameParam, @QueryParam(value="format") String format, @HeaderParam(value="accept") String acceptHeaderParam) {
        return Response.ok().entity(outputStream -> {
            GraphDatabaseService neo4j = gds.database(dbNameParam);
            RDFWriter writer = this.startRdfWriter(this.getFormat(acceptHeaderParam, format), outputStream);
            writer.handleNamespace("owl", "http://www.w3.org/2002/07/owl#");
            writer.handleNamespace("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
            try (Transaction tx = neo4j.beginTx();){
                GraphConfig gc = this.getGraphConfig(tx);
                ExportProcessor proc = gc == null || gc.getHandleVocabUris() == 2 || gc.getHandleVocabUris() == 3 ? new LPGToRDFProcesssor(neo4j, tx, gc, null, false, false) : new LPGRDFToRDFProcesssor(neo4j, tx, gc, this.isRdfStarSerialisation(writer.getRDFFormat()));
                ((ExportProcessor)proc).streamLocalImplicitOntology().forEach(writer::handleStatement);
                this.endRDFWriter(writer);
            }
            catch (Exception e) {
                this.handleSerialisationError(outputStream, e, acceptHeaderParam, format);
            }
        }).build();
    }

    private RDFWriter startRdfWriter(RDFFormat format, OutputStream os) {
        RDFWriter writer = Rio.createWriter(format, os);
        writer.set(JSONLDSettings.JSONLD_MODE, JSONLDMode.COMPACT);
        writer.set(JSONLDSettings.OPTIMIZE, true);
        writer.startRDF();
        return writer;
    }

    private void endRDFWriter(RDFWriter writer) {
        writer.endRDF();
    }

    private void handleSerialisationError(OutputStream outputStream, Exception e, @HeaderParam(value="accept") String acceptHeaderParam, @QueryParam(value="format") String format) {
        RDFWriter writer = Rio.createWriter(this.getFormat(acceptHeaderParam, format), outputStream);
        writer.startRDF();
        writer.handleComment(e.getMessage());
        writer.endRDF();
    }

    private RDFFormat getFormat(String mimetype, String formatParam) {
        block3: {
            block2: {
                if (formatParam == null) break block2;
                for (RDFFormat parser : availableParsers) {
                    if (!parser.getName().contains(formatParam)) continue;
                    return parser;
                }
                break block3;
            }
            if (mimetype == null) break block3;
            for (RDFFormat parser : availableParsers) {
                if (!parser.getMIMETypes().contains(mimetype)) continue;
                return parser;
            }
        }
        return RDFFormat.TURTLE;
    }
}

