/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.memory;

import java.io.File;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.rdf4j.IsolationLevels;
import org.eclipse.rdf4j.common.concurrent.locks.Lock;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategyFactory;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolver;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolverClient;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.StrictEvaluationStrategyFactory;
import org.eclipse.rdf4j.repository.sparql.federation.SPARQLServiceResolver;
import org.eclipse.rdf4j.sail.NotifyingSailConnection;
import org.eclipse.rdf4j.sail.SailChangedEvent;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.base.SailDataset;
import org.eclipse.rdf4j.sail.base.SailSink;
import org.eclipse.rdf4j.sail.base.SailStore;
import org.eclipse.rdf4j.sail.helpers.AbstractNotifyingSail;
import org.eclipse.rdf4j.sail.helpers.DirectoryLockManager;
import org.eclipse.rdf4j.sail.memory.FileIO;
import org.eclipse.rdf4j.sail.memory.MemorySailStore;
import org.eclipse.rdf4j.sail.memory.MemoryStoreConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryStore
extends AbstractNotifyingSail
implements FederatedServiceResolverClient {
    private static final Logger logger = LoggerFactory.getLogger(MemoryStore.class);
    protected static final String DATA_FILE_NAME = "memorystore.data";
    protected static final String SYNC_FILE_NAME = "memorystore.sync";
    private SailStore store;
    private volatile boolean persist = false;
    private volatile File dataFile;
    private volatile File syncFile;
    private volatile Lock dirLock;
    private volatile boolean contentsChanged;
    private volatile long syncDelay = 0L;
    private final Object syncSemaphore = new Object();
    private volatile Timer syncTimer;
    private volatile TimerTask syncTimerTask;
    private final Object syncTimerSemaphore = new Object();
    private EvaluationStrategyFactory evalStratFactory;
    private FederatedServiceResolver serviceResolver;
    private SPARQLServiceResolver dependentServiceResolver;

    public MemoryStore() {
        this.setSupportedIsolationLevels(IsolationLevels.NONE, IsolationLevels.READ_COMMITTED, IsolationLevels.SNAPSHOT_READ, IsolationLevels.SNAPSHOT, IsolationLevels.SERIALIZABLE);
        this.setDefaultIsolationLevel(IsolationLevels.SNAPSHOT_READ);
    }

    public MemoryStore(File dataDir) {
        this();
        this.setDataDir(dataDir);
        this.setPersist(true);
    }

    public void setPersist(boolean persist) {
        if (this.isInitialized()) {
            throw new IllegalStateException("sail has already been initialized");
        }
        this.persist = persist;
    }

    public boolean getPersist() {
        return this.persist;
    }

    public void setSyncDelay(long syncDelay) {
        if (this.isInitialized()) {
            throw new IllegalStateException("sail has already been initialized");
        }
        this.syncDelay = syncDelay;
    }

    public long getSyncDelay() {
        return this.syncDelay;
    }

    public synchronized EvaluationStrategyFactory getEvaluationStrategyFactory() {
        if (this.evalStratFactory == null) {
            this.evalStratFactory = new StrictEvaluationStrategyFactory(this.getFederatedServiceResolver());
        }
        this.evalStratFactory.setQuerySolutionCacheThreshold(this.getIterationCacheSyncThreshold());
        this.evalStratFactory.setTrackResultSize(this.isTrackResultSize());
        return this.evalStratFactory;
    }

    public synchronized void setEvaluationStrategyFactory(EvaluationStrategyFactory factory) {
        this.evalStratFactory = factory;
    }

    public synchronized FederatedServiceResolver getFederatedServiceResolver() {
        if (this.serviceResolver == null) {
            if (this.dependentServiceResolver == null) {
                this.dependentServiceResolver = new SPARQLServiceResolver();
            }
            this.setFederatedServiceResolver(this.dependentServiceResolver);
        }
        return this.serviceResolver;
    }

    @Override
    public synchronized void setFederatedServiceResolver(FederatedServiceResolver resolver) {
        this.serviceResolver = resolver;
        if (resolver != null && this.evalStratFactory instanceof FederatedServiceResolverClient) {
            ((FederatedServiceResolverClient)((Object)this.evalStratFactory)).setFederatedServiceResolver(resolver);
        }
    }

    @Override
    protected void initializeInternal() throws SailException {
        logger.debug("Initializing MemoryStore...");
        this.store = new MemorySailStore(MemoryStore.debugEnabled());
        if (this.persist) {
            File dataDir = this.getDataDir();
            DirectoryLockManager locker = new DirectoryLockManager(dataDir);
            this.dataFile = new File(dataDir, DATA_FILE_NAME);
            this.syncFile = new File(dataDir, SYNC_FILE_NAME);
            if (this.dataFile.exists()) {
                logger.debug("Reading data from {}...", (Object)this.dataFile);
                if (!this.dataFile.canRead()) {
                    logger.error("Data file is not readable: {}", (Object)this.dataFile);
                    throw new SailException("Can't read data file: " + this.dataFile);
                }
                this.dirLock = locker.tryLock();
                if (this.dirLock == null) {
                    logger.warn("Failed to lock directory: {}", (Object)dataDir);
                }
                if (this.dataFile.length() == 0L) {
                    logger.warn("Ignoring empty data file: {}", (Object)this.dataFile);
                } else {
                    SailSink explicit = this.store.getExplicitSailSource().sink(IsolationLevels.NONE);
                    SailSink inferred = this.store.getInferredSailSource().sink(IsolationLevels.NONE);
                    try {
                        new FileIO(this.store.getValueFactory()).read(this.dataFile, explicit, inferred);
                        logger.debug("Data file read successfully");
                    }
                    catch (IOException e) {
                        logger.error("Failed to read data file", e);
                        throw new SailException(e);
                    }
                    finally {
                        explicit.prepare();
                        explicit.flush();
                        explicit.close();
                        inferred.prepare();
                        inferred.flush();
                        inferred.close();
                    }
                }
            } else {
                try {
                    File dir = this.dataFile.getParentFile();
                    if (dir != null && !dir.exists()) {
                        logger.debug("Creating directory for data file...");
                        if (!dir.mkdirs()) {
                            logger.debug("Failed to create directory for data file: {}", (Object)dir);
                            throw new SailException("Failed to create directory for data file: " + dir);
                        }
                    }
                    this.dirLock = locker.lockOrFail();
                    logger.debug("Initializing data file...");
                    try (SailDataset explicit = this.store.getExplicitSailSource().dataset(IsolationLevels.SNAPSHOT);
                         SailDataset inferred = this.store.getInferredSailSource().dataset(IsolationLevels.SNAPSHOT);){
                        new FileIO(this.store.getValueFactory()).write(explicit, inferred, this.syncFile, this.dataFile);
                    }
                    logger.debug("Data file initialized");
                }
                catch (IOException | SailException e) {
                    logger.debug("Failed to initialize data file", e);
                    throw new SailException("Failed to initialize data file " + this.dataFile, e);
                }
            }
        }
        this.contentsChanged = false;
        logger.debug("MemoryStore initialized");
    }

    @Override
    protected void shutDownInternal() throws SailException {
        try {
            this.cancelSyncTimer();
            this.sync();
            this.store.close();
            this.dataFile = null;
            this.syncFile = null;
        }
        finally {
            if (this.dirLock != null) {
                this.dirLock.release();
            }
            if (this.dependentServiceResolver != null) {
                this.dependentServiceResolver.shutDown();
            }
        }
    }

    @Override
    public boolean isWritable() {
        return !this.persist || this.dirLock != null;
    }

    @Override
    protected NotifyingSailConnection getConnectionInternal() throws SailException {
        return new MemoryStoreConnection(this);
    }

    @Override
    public ValueFactory getValueFactory() {
        if (this.store == null) {
            throw new IllegalStateException("sail not initialized.");
        }
        return this.store.getValueFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifySailChanged(SailChangedEvent event) {
        super.notifySailChanged(event);
        Object object = this.syncSemaphore;
        synchronized (object) {
            this.contentsChanged = this.contentsChanged || event.statementsAdded() || event.statementsRemoved();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scheduleSyncTask() throws SailException {
        if (!this.persist) {
            return;
        }
        if (this.syncDelay == 0L) {
            this.sync();
        } else if (this.syncDelay > 0L) {
            Object object = this.syncTimerSemaphore;
            synchronized (object) {
                if (this.syncTimer == null) {
                    this.syncTimer = new Timer("MemoryStore synchronization", true);
                }
                if (this.syncTimerTask != null) {
                    this.syncTimerTask.cancel();
                }
                this.syncTimerTask = new TimerTask(){

                    @Override
                    public void run() {
                        try {
                            MemoryStore.this.sync();
                        }
                        catch (SailException e) {
                            logger.warn("Unable to sync on timer", e);
                        }
                    }
                };
                this.syncTimer.schedule(this.syncTimerTask, this.syncDelay);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancelSyncTask() {
        Object object = this.syncTimerSemaphore;
        synchronized (object) {
            if (this.syncTimerTask != null) {
                this.syncTimerTask.cancel();
                this.syncTimerTask = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancelSyncTimer() {
        Object object = this.syncTimerSemaphore;
        synchronized (object) {
            if (this.syncTimer != null) {
                this.syncTimer.cancel();
                this.syncTimer = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync() throws SailException {
        Object object = this.syncSemaphore;
        synchronized (object) {
            if (this.persist && this.contentsChanged) {
                logger.debug("syncing data to file...");
                try {
                    IsolationLevels level = IsolationLevels.SNAPSHOT;
                    try (SailDataset explicit = this.store.getExplicitSailSource().dataset(level);
                         SailDataset inferred = this.store.getInferredSailSource().dataset(level);){
                        new FileIO(this.store.getValueFactory()).write(explicit, inferred, this.syncFile, this.dataFile);
                    }
                    this.contentsChanged = false;
                    logger.debug("Data synced to file");
                }
                catch (IOException e) {
                    logger.error("Failed to sync to file", e);
                    throw new SailException(e);
                }
            }
        }
    }

    SailStore getSailStore() {
        return this.store;
    }
}

