/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.jsonld;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.jsonldjava.core.DocumentLoader;
import com.github.jsonldjava.core.JsonLdError;
import com.github.jsonldjava.core.JsonLdOptions;
import com.github.jsonldjava.core.JsonLdProcessor;
import com.github.jsonldjava.utils.JsonUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collection;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.rio.ParserConfig;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.helpers.AbstractRDFParser;
import org.eclipse.rdf4j.rio.helpers.JSONLDSettings;
import org.eclipse.rdf4j.rio.helpers.JSONSettings;
import org.eclipse.rdf4j.rio.jsonld.JSONLDInternalTripleCallback;

public class JSONLDParser
extends AbstractRDFParser
implements RDFParser {
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();

    public JSONLDParser() {
    }

    public JSONLDParser(ValueFactory valueFactory) {
        super(valueFactory);
    }

    @Override
    public RDFFormat getRDFFormat() {
        return RDFFormat.JSONLD;
    }

    @Override
    public Collection<RioSetting<?>> getSupportedSettings() {
        Collection<RioSetting<?>> result = super.getSupportedSettings();
        result.add(JSONSettings.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER);
        result.add(JSONSettings.ALLOW_COMMENTS);
        result.add(JSONSettings.ALLOW_NON_NUMERIC_NUMBERS);
        result.add(JSONSettings.ALLOW_NUMERIC_LEADING_ZEROS);
        result.add(JSONSettings.ALLOW_SINGLE_QUOTES);
        result.add(JSONSettings.ALLOW_UNQUOTED_CONTROL_CHARS);
        result.add(JSONSettings.ALLOW_UNQUOTED_FIELD_NAMES);
        result.add(JSONSettings.ALLOW_YAML_COMMENTS);
        result.add(JSONSettings.ALLOW_TRAILING_COMMA);
        result.add(JSONSettings.INCLUDE_SOURCE_IN_LOCATION);
        result.add(JSONSettings.STRICT_DUPLICATE_DETECTION);
        result.add(JSONLDSettings.DOCUMENT_LOADER);
        return result;
    }

    @Override
    public void parse(InputStream in, String baseURI) throws IOException, RDFParseException, RDFHandlerException {
        this.parse(in, null, baseURI);
    }

    @Override
    public void parse(Reader reader, String baseURI) throws IOException, RDFParseException, RDFHandlerException {
        this.parse(null, reader, baseURI);
    }

    private void parse(InputStream in, Reader reader, String baseURI) throws IOException, RDFParseException, RDFHandlerException {
        this.clear();
        try {
            JSONLDInternalTripleCallback callback = new JSONLDInternalTripleCallback(this.getRDFHandler(), this.valueFactory, this.getParserConfig(), this.getParseErrorListener(), nodeID -> this.createNode((String)nodeID), () -> this.createNode());
            JsonLdOptions options = baseURI != null ? new JsonLdOptions(baseURI) : new JsonLdOptions();
            options.useNamespaces = true;
            DocumentLoader loader = this.getParserConfig().get(JSONLDSettings.DOCUMENT_LOADER);
            if (loader != null) {
                options.setDocumentLoader(loader);
            }
            JsonFactory factory = this.configureNewJsonFactory();
            Object parsedJson = this.getJSONObject(in, reader, factory);
            JsonLdProcessor.toRDF(parsedJson, callback, options);
        }
        catch (JsonLdError e) {
            throw new RDFParseException("Could not parse JSONLD", e);
        }
        catch (JsonProcessingException e) {
            throw new RDFParseException("Could not parse JSONLD", (Throwable)e, e.getLocation().getLineNr(), e.getLocation().getColumnNr());
        }
        catch (RuntimeException e) {
            if (e.getCause() != null && e.getCause() instanceof RDFParseException) {
                throw (RDFParseException)e.getCause();
            }
            throw e;
        }
        finally {
            this.clear();
        }
    }

    protected Object getJSONObject(InputStream in, Reader reader, JsonFactory factory) throws IOException {
        JsonParser nextParser = in != null ? factory.createParser(in) : factory.createParser(reader);
        return JsonUtils.fromJsonParser(nextParser);
    }

    private JsonFactory configureNewJsonFactory() {
        JsonFactory nextJsonFactory = new JsonFactory((ObjectCodec)JSON_MAPPER);
        ParserConfig parserConfig = this.getParserConfig();
        if (parserConfig.isSet(JSONSettings.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER)) {
            nextJsonFactory.configure(JsonParser.Feature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER, (boolean)parserConfig.get(JSONSettings.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER));
        }
        if (parserConfig.isSet(JSONSettings.ALLOW_COMMENTS)) {
            nextJsonFactory.configure(JsonParser.Feature.ALLOW_COMMENTS, (boolean)parserConfig.get(JSONSettings.ALLOW_COMMENTS));
        }
        if (parserConfig.isSet(JSONSettings.ALLOW_NON_NUMERIC_NUMBERS)) {
            nextJsonFactory.configure(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS, (boolean)parserConfig.get(JSONSettings.ALLOW_NON_NUMERIC_NUMBERS));
        }
        if (parserConfig.isSet(JSONSettings.ALLOW_NUMERIC_LEADING_ZEROS)) {
            nextJsonFactory.configure(JsonParser.Feature.ALLOW_NUMERIC_LEADING_ZEROS, (boolean)parserConfig.get(JSONSettings.ALLOW_NUMERIC_LEADING_ZEROS));
        }
        if (parserConfig.isSet(JSONSettings.ALLOW_SINGLE_QUOTES)) {
            nextJsonFactory.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, (boolean)parserConfig.get(JSONSettings.ALLOW_SINGLE_QUOTES));
        }
        if (parserConfig.isSet(JSONSettings.ALLOW_UNQUOTED_CONTROL_CHARS)) {
            nextJsonFactory.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, (boolean)parserConfig.get(JSONSettings.ALLOW_UNQUOTED_CONTROL_CHARS));
        }
        if (parserConfig.isSet(JSONSettings.ALLOW_UNQUOTED_FIELD_NAMES)) {
            nextJsonFactory.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, (boolean)parserConfig.get(JSONSettings.ALLOW_UNQUOTED_FIELD_NAMES));
        }
        if (parserConfig.isSet(JSONSettings.ALLOW_YAML_COMMENTS)) {
            nextJsonFactory.configure(JsonParser.Feature.ALLOW_YAML_COMMENTS, (boolean)parserConfig.get(JSONSettings.ALLOW_YAML_COMMENTS));
        }
        if (parserConfig.isSet(JSONSettings.ALLOW_TRAILING_COMMA)) {
            nextJsonFactory.configure(JsonParser.Feature.ALLOW_TRAILING_COMMA, (boolean)parserConfig.get(JSONSettings.ALLOW_TRAILING_COMMA));
        }
        if (parserConfig.isSet(JSONSettings.INCLUDE_SOURCE_IN_LOCATION)) {
            nextJsonFactory.configure(JsonParser.Feature.INCLUDE_SOURCE_IN_LOCATION, (boolean)parserConfig.get(JSONSettings.INCLUDE_SOURCE_IN_LOCATION));
        }
        if (parserConfig.isSet(JSONSettings.STRICT_DUPLICATE_DETECTION)) {
            nextJsonFactory.configure(JsonParser.Feature.STRICT_DUPLICATE_DETECTION, (boolean)parserConfig.get(JSONSettings.STRICT_DUPLICATE_DETECTION));
        }
        return nextJsonFactory;
    }
}

