/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.sparql.config;

import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.BooleanLiteral;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.util.ModelException;
import org.eclipse.rdf4j.model.util.Models;
import org.eclipse.rdf4j.repository.config.AbstractRepositoryImplConfig;
import org.eclipse.rdf4j.repository.config.RepositoryConfigException;

public class SPARQLRepositoryConfig
extends AbstractRepositoryImplConfig {
    private static final ValueFactory vf = SimpleValueFactory.getInstance();
    public static final String NAMESPACE = "http://www.openrdf.org/config/repository/sparql#";
    public static final IRI QUERY_ENDPOINT = vf.createIRI("http://www.openrdf.org/config/repository/sparql#query-endpoint");
    public static final IRI UPDATE_ENDPOINT = vf.createIRI("http://www.openrdf.org/config/repository/sparql#update-endpoint");
    public static final IRI PASS_THROUGH_ENABLED = vf.createIRI("http://www.openrdf.org/config/repository/sparql#pass-through-enabled");
    private String queryEndpointUrl;
    private String updateEndpointUrl;
    private Boolean passThroughEnabled;

    public SPARQLRepositoryConfig() {
        super("openrdf:SPARQLRepository");
    }

    public SPARQLRepositoryConfig(String queryEndpointUrl) {
        this();
        this.setQueryEndpointUrl(queryEndpointUrl);
    }

    public SPARQLRepositoryConfig(String queryEndpointUrl, String updateEndpointUrl) {
        this(queryEndpointUrl);
        this.setUpdateEndpointUrl(updateEndpointUrl);
    }

    public String getQueryEndpointUrl() {
        return this.queryEndpointUrl;
    }

    public void setQueryEndpointUrl(String url) {
        this.queryEndpointUrl = url;
    }

    public String getUpdateEndpointUrl() {
        return this.updateEndpointUrl;
    }

    public void setUpdateEndpointUrl(String url) {
        this.updateEndpointUrl = url;
    }

    @Override
    public void validate() throws RepositoryConfigException {
        super.validate();
        if (this.getQueryEndpointUrl() == null) {
            throw new RepositoryConfigException("No endpoint URL specified for SPARQL repository");
        }
    }

    @Override
    public Resource export(Model m) {
        Resource implNode = super.export(m);
        m.setNamespace("sparql", NAMESPACE);
        if (this.getQueryEndpointUrl() != null) {
            m.add(implNode, QUERY_ENDPOINT, (Value)vf.createIRI(this.getQueryEndpointUrl()), new Resource[0]);
        }
        if (this.getUpdateEndpointUrl() != null) {
            m.add(implNode, UPDATE_ENDPOINT, (Value)vf.createIRI(this.getUpdateEndpointUrl()), new Resource[0]);
        }
        if (this.getPassThroughEnabled() != null) {
            m.add(implNode, PASS_THROUGH_ENABLED, (Value)BooleanLiteral.valueOf(this.getPassThroughEnabled()), new Resource[0]);
        }
        return implNode;
    }

    @Override
    public void parse(Model m, Resource implNode) throws RepositoryConfigException {
        super.parse(m, implNode);
        try {
            Models.objectIRI(m.getStatements(implNode, QUERY_ENDPOINT, null, new Resource[0])).ifPresent(iri -> this.setQueryEndpointUrl(iri.stringValue()));
            Models.objectIRI(m.getStatements(implNode, UPDATE_ENDPOINT, null, new Resource[0])).ifPresent(iri -> this.setUpdateEndpointUrl(iri.stringValue()));
            Models.objectLiteral(m.getStatements(implNode, PASS_THROUGH_ENABLED, null, new Resource[0])).ifPresent(lit -> this.setPassThroughEnabled(lit.booleanValue()));
        }
        catch (ModelException e) {
            throw new RepositoryConfigException(e.getMessage(), e);
        }
    }

    public Boolean getPassThroughEnabled() {
        return this.passThroughEnabled;
    }

    public void setPassThroughEnabled(Boolean passThroughEnabled) {
        this.passThroughEnabled = passThroughEnabled;
    }
}

