/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.model.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import java.util.Optional;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.base.AbstractLiteral;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.XSD;

public class SimpleLiteral
extends AbstractLiteral {
    private static final long serialVersionUID = -1649571784782592271L;
    private String label;
    private String language;
    private IRI datatype;
    private transient Optional<XSD.Datatype> xsdDatatype = null;

    protected SimpleLiteral() {
    }

    protected SimpleLiteral(String label) {
        this.setLabel(label);
        this.setDatatype(XSD.STRING);
    }

    protected SimpleLiteral(String label, String language) {
        this.setLabel(label);
        this.setLanguage(language);
    }

    protected SimpleLiteral(String label, IRI datatype) {
        this.setLabel(label);
        if (RDF.LANGSTRING.equals(datatype)) {
            throw new IllegalArgumentException("datatype rdf:langString requires a language tag");
        }
        if (datatype == null) {
            this.setDatatype(XSD.Datatype.STRING);
        } else {
            this.setDatatype(datatype);
        }
    }

    protected SimpleLiteral(String label, XSD.Datatype datatype) {
        this.setLabel(label);
        if (RDF.LANGSTRING.equals(datatype.getIri())) {
            throw new IllegalArgumentException("datatype rdf:langString requires a language tag");
        }
        if (datatype == null) {
            this.setDatatype(XSD.Datatype.STRING);
        } else {
            this.setDatatype(datatype);
        }
    }

    protected void setLabel(String label) {
        Objects.requireNonNull(label, "Literal label cannot be null");
        this.label = label;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    protected void setLanguage(String language) {
        Objects.requireNonNull(language);
        if (language.isEmpty()) {
            throw new IllegalArgumentException("Language tag cannot be empty");
        }
        this.language = language;
        this.setDatatype(RDF.LANGSTRING);
    }

    @Override
    public Optional<String> getLanguage() {
        return Optional.ofNullable(this.language);
    }

    protected void setDatatype(IRI datatype) {
        this.datatype = datatype;
    }

    protected void setDatatype(XSD.Datatype datatype) {
        this.datatype = datatype.getIri();
        this.xsdDatatype = Optional.of(datatype);
    }

    @Override
    public IRI getDatatype() {
        return this.datatype;
    }

    public Optional<XSD.Datatype> getXsdDatatype() {
        if (this.xsdDatatype == null) {
            this.xsdDatatype = XSD.Datatype.from(this.datatype);
        }
        return this.xsdDatatype;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Literal) {
            Literal other = (Literal)o;
            if (!this.label.equals(other.getLabel())) {
                return false;
            }
            if (!this.datatype.equals(other.getDatatype())) {
                return false;
            }
            if (this.getLanguage().isPresent() && other.getLanguage().isPresent()) {
                return this.getLanguage().get().equalsIgnoreCase(other.getLanguage().get());
            }
            return !this.getLanguage().isPresent() && !other.getLanguage().isPresent();
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.label.hashCode();
    }

    @Override
    public String toString() {
        if (Literals.isLanguageLiteral(this)) {
            StringBuilder sb = new StringBuilder(this.label.length() + this.language.length() + 3);
            sb.append('\"').append(this.label).append('\"');
            sb.append('@').append(this.language);
            return sb.toString();
        }
        if (XSD.STRING.equals(this.datatype) || this.datatype == null) {
            StringBuilder sb = new StringBuilder(this.label.length() + 2);
            sb.append('\"').append(this.label).append('\"');
            return sb.toString();
        }
        StringBuilder sb = new StringBuilder(this.label.length() + this.datatype.stringValue().length() + 6);
        sb.append('\"').append(this.label).append('\"');
        sb.append("^^<").append(this.datatype.toString()).append(">");
        return sb.toString();
    }

    @Override
    public String stringValue() {
        return this.label;
    }

    @Override
    public boolean booleanValue() {
        return XMLDatatypeUtil.parseBoolean(this.label);
    }

    @Override
    public byte byteValue() {
        return XMLDatatypeUtil.parseByte(this.label);
    }

    @Override
    public short shortValue() {
        return XMLDatatypeUtil.parseShort(this.label);
    }

    @Override
    public int intValue() {
        return XMLDatatypeUtil.parseInt(this.label);
    }

    @Override
    public long longValue() {
        return XMLDatatypeUtil.parseLong(this.label);
    }

    @Override
    public float floatValue() {
        return XMLDatatypeUtil.parseFloat(this.label);
    }

    @Override
    public double doubleValue() {
        return XMLDatatypeUtil.parseDouble(this.label);
    }

    @Override
    public BigInteger integerValue() {
        return XMLDatatypeUtil.parseInteger(this.label);
    }

    @Override
    public BigDecimal decimalValue() {
        return XMLDatatypeUtil.parseDecimal(this.label);
    }

    @Override
    public XMLGregorianCalendar calendarValue() {
        return XMLDatatypeUtil.parseCalendar(this.label);
    }
}

