/*
 * Decompiled with CFR 0.152.
 */
package n10s.validation;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import n10s.CommonProcedures;
import n10s.utils.InvalidNamespacePrefixDefinitionInDB;
import n10s.utils.UriUtils;
import n10s.validation.ConstraintComponent;
import n10s.validation.SHACLValidationException;
import n10s.validation.SHACLValidator;
import n10s.validation.ValidationResult;
import n10s.validation.ValidatorConfig;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Result;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class ValidationProcedures
extends CommonProcedures {
    private static final String MAP_APOC_TRIGGER_PARAMS_TO_VALIDATION = "UNWIND reduce(nodes = [], x IN keys($removedLabels) | nodes + $removedLabels[x]) AS rln  MATCH (rln)<--(x) WITH collect(DISTINCT x) AS sn  UNWIND sn + $createdNodes + [x IN $createdRelationships | startNode(x)] + [x IN $createdRelationships | endNode(x)] +  [x IN $deletedRelationships | startNode(x)] + [x IN $deletedRelationships | endNode(x)] +  reduce( nodes = [] , x IN keys($assignedLabels) | nodes + $assignedLabels[x]) +   reduce( nodes = [] , x IN keys($assignedNodeProperties) | nodes +   [ item IN $assignedNodeProperties[x] | item.node] ) +  reduce( nodes = [] , x IN keys($removedNodeProperties) | nodes +   [ item IN $removedNodeProperties[x] | item.node] ) AS nd  WITH reduce (minus = [], x in collect( DISTINCT nd) |  case when not (x in $deletedNodes) then minus + x else minus end )  AS touchedNodes\nCALL n10s.validation.shacl.validateSet(touchedNodes) YIELD focusNode, nodeType, shapeId, propertyShape, offendingValue, resultPath, severity, resultMessage\nRETURN {focusNode: focusNode, nodeType: nodeType, shapeId: shapeId, propertyShape: propertyShape, offendingValue: offendingValue, resultPath:resultPath, severity:severity, resultMessage:resultMessage } AS validationResult ";

    @Procedure(name="n10s.validation.shacl.validateTransaction", mode=Mode.READ)
    @Description(value="n10s.validation.shacl.validateTransaction(createdNodes,createdRelationships,...) - runs SHACL validation in trigger context.")
    public Stream<ValidationResult> shaclValidateTxForTrigger(@Name(value="createdNodes") Object createdNodes, @Name(value="createdRelationships") Object createdRelationships, @Name(value="assignedLabels") Object assignedLabels, @Name(value="removedLabels") Object removedLabels, @Name(value="assignedNodeProperties") Object assignedNodeProperties, @Name(value="removedNodeProperties") Object removedNodeProperties, @Name(value="deletedRelationships") Object deletedRelationships, @Name(value="deletedNodes") Object deletedNodes) {
        if (this.tx.execute("MATCH (vc:_n10sValidatorConfig { _id: 1}) RETURN id(vc) as id").hasNext()) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("createdNodes", createdNodes);
            params.put("createdRelationships", createdRelationships);
            params.put("assignedLabels", assignedLabels);
            params.put("removedLabels", removedLabels);
            params.put("assignedNodeProperties", assignedNodeProperties);
            params.put("removedNodeProperties", removedNodeProperties);
            params.put("deletedRelationships", deletedRelationships);
            params.put("deletedNodes", deletedNodes);
            Result validationResults = this.tx.execute(MAP_APOC_TRIGGER_PARAMS_TO_VALIDATION, params);
            if (validationResults.hasNext()) {
                throw new SHACLValidationException(validationResults.next().toString());
            }
        }
        return Stream.empty();
    }

    @Procedure(name="n10s.validation.shacl.import.inline", mode=Mode.WRITE)
    @Description(value="Imports a SHACL shapes snippet passed as parameter and compiles a validator into neo4j")
    public Stream<ConstraintComponent> importInlineSHACL(@Name(value="rdf") String rdfFragment, @Name(value="format") String format, @Name(value="params", defaultValue="{}") Map<String, Object> props) throws IOException, CommonProcedures.RDFImportBadParams, InvalidNamespacePrefixDefinitionInDB, UriUtils.UriNamespaceHasNoAssociatedPrefix {
        return this.doLoad(format, null, rdfFragment, props).stream();
    }

    @Procedure(name="n10s.validation.shacl.import.fetch", mode=Mode.WRITE)
    @Description(value="Imports SHACL shapes from a URL and compiles a validator into neo4j")
    public Stream<ConstraintComponent> importSHACLFromURL(@Name(value="url") String url, @Name(value="format") String format, @Name(value="params", defaultValue="{}") Map<String, Object> props) throws IOException, CommonProcedures.RDFImportBadParams, InvalidNamespacePrefixDefinitionInDB, UriUtils.UriNamespaceHasNoAssociatedPrefix {
        return this.doLoad(format, url, null, props).stream();
    }

    private List<ConstraintComponent> doLoad(String format, String url, String rdfFragment, Map<String, Object> props) throws IOException, CommonProcedures.RDFImportBadParams, InvalidNamespacePrefixDefinitionInDB, UriUtils.UriNamespaceHasNoAssociatedPrefix {
        InputStream is = rdfFragment != null ? new ByteArrayInputStream(rdfFragment.getBytes(Charset.defaultCharset())) : this.getInputStream(url, props);
        SHACLValidator validator = new SHACLValidator(this.tx, this.log);
        ValidatorConfig validatorConfig = validator.compileValidations(validator.parseConstraints(is, this.getFormat(format), props));
        validatorConfig.writeToDB(this.tx);
        return validatorConfig.getConstraintList();
    }

    @Procedure(name="n10s.validation.shacl.listShapes", mode=Mode.READ)
    @Description(value="n10s.validation.listShapes() - list SHACL shapes loaded in the Graph")
    public Stream<ConstraintComponent> listShapes() throws IOException, ClassNotFoundException {
        return new ValidatorConfig(this.tx).getConstraintList().stream();
    }

    @Procedure(name="n10s.validation.shacl.dropShapes", mode=Mode.WRITE)
    @Description(value="n10s.validation.dropShapes() - list SHACL shapes loaded in the Graph")
    public Stream<ConstraintComponent> dropShapes() throws IOException, ClassNotFoundException {
        this.tx.execute("MATCH (vc:_n10sValidatorConfig { _id: 1}) DELETE vc ");
        return Stream.empty();
    }

    @Procedure(name="n10s.validation.shacl.validate", mode=Mode.READ)
    @Description(value="n10s.validation.shacl.validate() - runs SHACL validation on the whole graph.")
    public Stream<ValidationResult> validateFromCompiled() throws IOException, ClassNotFoundException {
        ValidatorConfig vc = new ValidatorConfig(this.tx);
        return vc.generateRunnableQueries(this.tx, true, null).parallelStream().flatMap(x -> this.tx.execute(x, vc.getAllParams()).stream()).map(ValidationResult::new);
    }

    @Procedure(name="n10s.validation.shacl.validateSet", mode=Mode.READ)
    @Description(value="n10s.validation.shacl.validateSet([nodeList]) - runs SHACL validation on selected nodes")
    public Stream<ValidationResult> validateSetFromCompiled(@Name(value="nodeList", defaultValue="[]") List<Node> nodeList) throws IOException, ClassNotFoundException {
        ValidatorConfig vc = new ValidatorConfig(this.tx);
        vc.getAllParams().put("touchedNodes", nodeList);
        return vc.generateRunnableQueries(this.tx, false, nodeList).parallelStream().flatMap(x -> this.tx.execute(x, vc.getAllParams()).stream()).map(ValidationResult::new);
    }
}

