/*
 * Decompiled with CFR 0.152.
 */
package n10s.validation;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import n10s.graphconfig.GraphConfig;
import n10s.graphconfig.Params;
import n10s.utils.InvalidNamespacePrefixDefinitionInDB;
import n10s.utils.UriUtils;
import n10s.validation.ConstraintComponent;
import n10s.validation.ValidatorConfig;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.URIUtil;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.helpers.BasicParserSettings;
import org.eclipse.rdf4j.sail.memory.MemoryStore;
import org.neo4j.graphdb.Transaction;
import org.neo4j.logging.Log;

public class SHACLValidator {
    private static final String CYPHER_TX_INFIX = " focus in $touchedNodes AND ";
    private static final String CYPHER_MATCH_WHERE = "MATCH (focus:`%s`) WHERE ";
    private static final String CYPHER_MATCH_REL_WHERE = "MATCH (focus:`%s`)-[r:`%s`]->(x) WHERE ";
    private static final String CYPHER_WITH_PARAMS_MATCH_WHERE = "WITH $`%s` as params MATCH (focus:`%s`) WHERE ";
    private static final String BNODE_PREFIX = "bnode://id/";
    String PROP_CONSTRAINT_QUERY = "prefix sh: <http://www.w3.org/ns/shacl#> \nSELECT distinct ?ns ?ps ?path ?invPath ?rangeClass  ?rangeKind ?datatype ?severity \n?targetClass ?pattern ?maxCount ?minCount ?minInc ?minExc ?maxInc ?maxExc ?minStrLen \n?maxStrLen (GROUP_CONCAT (distinct ?hasValueUri; separator=\"---\") AS ?hasValueUris) \n(GROUP_CONCAT (distinct ?hasValueLiteral; separator=\"---\") AS ?hasValueLiterals) \n(GROUP_CONCAT (distinct ?in; separator=\"---\") AS ?ins) \n(isLiteral(?inFirst) as ?isliteralIns)\n{ ?ns a ?shapeOrNodeShape ;\n     sh:node?/sh:property ?ps .\n  filter ( ?shapeOrNodeShape = sh:Shape || ?shapeOrNodeShape = sh:NodeShape )\n\n  optional { ?ps sh:path/sh:inversePath ?invPath }\n  optional { ?ps sh:path  ?path }\n  optional { ?ps sh:class  ?rangeClass }\n  optional { ?ps sh:nodeKind  ?rangeKind }  \n  optional { ?ps sh:datatype  ?datatype }\n  optional { ?ps sh:severity  ?severity }\n  optional { \n    { ?ns sh:targetClass  ?targetClass }\n    union\n    { ?targetClass sh:property ?ps;\n          a rdfs:Class . }\n  }\n  optional { ?ps sh:pattern  ?pattern }\n  optional { ?ps sh:maxCount  ?maxCount }\n  \n    optional { ?ps sh:minCount  ?minCount }\n    optional { ?ps sh:minInclusive  ?minInc }\n  \n    optional { ?ps sh:maxInclusive  ?maxInc }\n    optional { ?ps sh:minExclusive  ?minExc }\n    optional { ?ps sh:maxExclusive  ?maxExc }  \n  optional { ?ps sh:minLength  ?minStrLen }\n  \n    optional { ?ps sh:minLength  ?minStrLen }\n    optional { ?ps sh:maxLength  ?maxStrLen }\n  \n   optional { ?ps sh:hasValue  ?hasValueUri . filter(isIRI(?hasValueUri)) } \n    optional { ?ps sh:hasValue  ?hasValueLiteral . filter(isLiteral(?hasValueLiteral)) } \n  \n    optional { ?ps sh:in/rdf:rest*/rdf:first ?in } \n    optional { ?ps sh:in/rdf:first ?inFirst }\n    optional { ?ps sh:minLength  ?minStrLen }\n  \n} group by \n?ns ?ps ?path ?invPath ?rangeClass  ?rangeKind ?datatype ?severity ?targetClass ?pattern ?maxCount ?minCount ?minInc ?minExc ?maxInc ?maxExc ?minStrLen ?maxStrLen ?inFirst";
    String NODE_CONSTRAINT_QUERY = "PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\nprefix sh: <http://www.w3.org/ns/shacl#>  \nSELECT ?ns ?targetClass (GROUP_CONCAT (distinct ?definedProp; separator=\"---\") AS ?definedProps)\n(GROUP_CONCAT (distinct ?ignored; separator=\"---\") AS ?ignoredProps)\n{ ?ns a sh:NodeShape ;\n    sh:closed true .\n  \n   optional { \n     ?ns sh:targetClass  ?targetClass \n   }\n   \n   optional { \n     ?targetClass a rdfs:Class . filter(?targetClass = ?ns)\n   }\n  \n  optional { ?ns sh:property [ sh:path ?definedProp ].  filter(isIRI(?definedProp)) }\n   optional { ?ns sh:ignoredProperties/rdf:rest*/rdf:first ?ignored }\n   \n} group by ?ns ?targetClass";
    String NODE_ADDITIONAL_CONSTRAINT_QUERY = "PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\nprefix sh: <http://www.w3.org/ns/shacl#>  \nSELECT ?ns ?targetClass (GROUP_CONCAT (distinct ?class; separator=\"---\") AS ?class)\n(GROUP_CONCAT (distinct ?disjointclass; separator=\"---\") AS ?disjointclass)\n{ ?ns a sh:NodeShape .\n  \n   optional { \n     ?ns sh:targetClass  ?targetClass \n   }\n   \n   optional { \n     ?targetClass a rdfs:Class . filter(?targetClass = ?ns)\n   }\n  \n  optional { ?ns sh:not [ sh:class ?disjointclass ].  filter(isIRI(?disjointclass)) }\n  optional { ?ns sh:class ?class .  filter(isIRI(?class)) }\n  filter(bound(?disjointclass) || bound(?class))\n} group by ?ns ?targetClass";
    private Transaction tx;
    private Log log;
    private GraphConfig gc;

    public SHACLValidator(Transaction transaction, Log l) {
        this.tx = transaction;
        this.log = l;
        try {
            this.gc = new GraphConfig(this.tx);
        }
        catch (GraphConfig.GraphConfigNotFound graphConfigNotFound) {
            this.gc = null;
        }
    }

    protected ValidatorConfig compileValidations(Iterator<Map<String, Object>> constraints) throws InvalidNamespacePrefixDefinitionInDB, UriUtils.UriNamespaceHasNoAssociatedPrefix {
        ValidatorConfig vc = new ValidatorConfig();
        while (constraints.hasNext()) {
            Map<String, Object> propConstraint = constraints.next();
            if (propConstraint.get("appliesToCat") == null) {
                this.log.debug("Only class-based targets (sh:targetClass) and implicit class targets are validated.");
                continue;
            }
            if (propConstraint.containsKey("item") && propConstraint.get("item").equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#type")) {
                this.log.debug("Constraints on rdf:type are ignored  (temporary solution until we figure out how can they be used).");
                continue;
            }
            this.processConstraint(propConstraint, vc);
            this.addPropertyConstraintsToList(propConstraint, vc);
        }
        return vc;
    }

    protected void processConstraint(Map<String, Object> theConstraint, ValidatorConfig vc) throws InvalidNamespacePrefixDefinitionInDB, UriUtils.UriNamespaceHasNoAssociatedPrefix {
        Map<String, Object> params;
        String paramSetId;
        List valueLiteralList;
        Map<String, Object> params2;
        String paramSetId2;
        List valueUriList;
        String severity;
        String focusLabel = UriUtils.translateUri((String)theConstraint.get("appliesToCat"), this.tx, this.gc);
        String propOrRel = theConstraint.containsKey("item") ? UriUtils.translateUri((String)theConstraint.get("item"), this.tx, this.gc) : null;
        String string = severity = theConstraint.containsKey("severity") ? (String)theConstraint.get("severity") : SHACL.VIOLATION.stringValue();
        if (theConstraint.get("dataType") != null) {
            this.addCypherToValidationScripts(vc, new ArrayList<String>(Arrays.asList(focusLabel)), this.getDataTypeViolationQuery(false), this.getDataTypeViolationQuery(true), focusLabel, propOrRel, this.getDatatypeCastExpressionPref((String)theConstraint.get("dataType")), this.getDatatypeCastExpressionSuff((String)theConstraint.get("dataType")), focusLabel, (String)theConstraint.get("propShapeUid"), propOrRel, propOrRel, severity, (String)theConstraint.get("dataType"));
            this.addCypherToValidationScripts(vc, Arrays.asList(focusLabel), this.getDataTypeViolationQuery2(false), this.getDataTypeViolationQuery2(true), focusLabel, propOrRel, focusLabel, (String)theConstraint.get("propShapeUid"), propOrRel, severity, propOrRel);
        }
        if (this.shallIUseUriInsteadOfId() && theConstraint.get("hasValueUri") != null && !(valueUriList = (List)theConstraint.get("hasValueUri")).isEmpty()) {
            paramSetId2 = theConstraint.get("propShapeUid") + "_" + SHACL.HAS_VALUE.stringValue();
            params2 = this.createNewSetOfParams(vc.getAllParams(), paramSetId2);
            params2.put("theHasValueUri", valueUriList);
            this.addCypherToValidationScripts(vc, new ArrayList<String>(Arrays.asList(focusLabel)), this.getHasValueUriViolationQuery(false), this.getHasValueUriViolationQuery(true), paramSetId2, focusLabel, propOrRel, focusLabel, (String)theConstraint.get("propShapeUid"), propOrRel, severity, propOrRel);
        }
        if (theConstraint.get("hasValueLiteral") != null && !(valueLiteralList = (List)theConstraint.get("hasValueLiteral")).isEmpty()) {
            paramSetId2 = theConstraint.get("propShapeUid") + "_" + SHACL.HAS_VALUE.stringValue();
            params2 = this.createNewSetOfParams(vc.getAllParams(), paramSetId2);
            params2.put("theHasValueLiteral", valueLiteralList);
            this.addCypherToValidationScripts(vc, new ArrayList<String>(Arrays.asList(focusLabel)), this.getHasValueLiteralViolationQuery(false), this.getHasValueLiteralViolationQuery(true), paramSetId2, focusLabel, propOrRel, focusLabel, (String)theConstraint.get("propShapeUid"), propOrRel, severity, propOrRel);
        }
        if (theConstraint.get("rangeKind") != null) {
            if (theConstraint.get("rangeKind").equals(SHACL.LITERAL.stringValue())) {
                this.addCypherToValidationScripts(vc, new ArrayList<String>(Arrays.asList(focusLabel)), this.getRangeIRIKindViolationQuery(false), this.getRangeIRIKindViolationQuery(true), focusLabel, propOrRel, focusLabel, (String)theConstraint.get("propShapeUid"), propOrRel, severity, propOrRel);
            } else if (theConstraint.get("rangeKind").equals(SHACL.BLANK_NODE_OR_IRI.stringValue())) {
                this.addCypherToValidationScripts(vc, new ArrayList<String>(Arrays.asList(focusLabel)), this.getRangeLiteralKindViolationQuery(false), this.getRangeLiteralKindViolationQuery(true), focusLabel, propOrRel, focusLabel, (String)theConstraint.get("propShapeUid"), propOrRel, severity, propOrRel);
            }
        }
        if (theConstraint.get("rangeType") != null && !theConstraint.get("rangeType").equals("")) {
            this.addCypherToValidationScripts(vc, new ArrayList<String>(Arrays.asList(focusLabel, UriUtils.translateUri((String)theConstraint.get("rangeType"), this.tx, this.gc))), this.getRangeType1ViolationQuery(false), this.getRangeType1ViolationQuery(true), focusLabel, propOrRel, UriUtils.translateUri((String)theConstraint.get("rangeType"), this.tx, this.gc), focusLabel, (String)theConstraint.get("propShapeUid"), propOrRel, severity, UriUtils.translateUri((String)theConstraint.get("rangeType"), this.tx, this.gc));
            this.addCypherToValidationScripts(vc, new ArrayList<String>(Arrays.asList(focusLabel, UriUtils.translateUri((String)theConstraint.get("rangeType"), this.tx, this.gc))), this.getRangeType2ViolationQuery(false), this.getRangeType2ViolationQuery(true), focusLabel, propOrRel, focusLabel, (String)theConstraint.get("propShapeUid"), propOrRel, severity, propOrRel);
        }
        if (theConstraint.get("inLiterals") != null && !(valueLiteralList = (List)theConstraint.get("inLiterals")).isEmpty()) {
            paramSetId2 = theConstraint.get("propShapeUid") + "_" + SHACL.IN.stringValue();
            params2 = this.createNewSetOfParams(vc.getAllParams(), paramSetId2);
            params2.put("theInLiterals", valueLiteralList);
            this.addCypherToValidationScripts(vc, new ArrayList<String>(Arrays.asList(focusLabel)), this.getInLiteralsViolationQuery(false), this.getInLiteralsViolationQuery(true), paramSetId2, focusLabel, propOrRel, focusLabel, (String)theConstraint.get("propShapeUid"), propOrRel, severity, propOrRel);
        }
        if (theConstraint.get("inUris") != null && !(valueLiteralList = (List)theConstraint.get("inUris")).isEmpty()) {
            paramSetId2 = theConstraint.get("propShapeUid") + "_" + SHACL.IN.stringValue();
            params2 = this.createNewSetOfParams(vc.getAllParams(), paramSetId2);
            params2.put("theInUris", valueLiteralList);
            this.addCypherToValidationScripts(vc, new ArrayList<String>(Arrays.asList(focusLabel)), this.getInUrisViolationQuery(false), this.getInUrisViolationQuery(true), paramSetId2, focusLabel, propOrRel, focusLabel, (String)theConstraint.get("propShapeUid"), propOrRel, severity, propOrRel);
        }
        if (theConstraint.get("pattern") != null) {
            paramSetId = theConstraint.get("propShapeUid") + "_" + SHACL.PATTERN.stringValue();
            params = this.createNewSetOfParams(vc.getAllParams(), paramSetId);
            params.put("theRegex", (String)theConstraint.get("pattern"));
            this.addCypherToValidationScripts(vc, new ArrayList<String>(Arrays.asList(focusLabel)), this.getRegexViolationQuery(false), this.getRegexViolationQuery(true), paramSetId, focusLabel, propOrRel, propOrRel, focusLabel, (String)theConstraint.get("propShapeUid"), propOrRel, severity);
        }
        if (theConstraint.get("minCount") != null) {
            paramSetId = theConstraint.get("propShapeUid") + "_" + SHACL.MIN_COUNT.stringValue();
            params = this.createNewSetOfParams(vc.getAllParams(), paramSetId);
            params.put("minCount", theConstraint.get("minCount"));
            if (!((Boolean)theConstraint.get("inverse")).booleanValue()) {
                this.addCypherToValidationScripts(vc, new ArrayList<String>(Arrays.asList(focusLabel)), this.getMinCardinality1ViolationQuery(false), this.getMinCardinality1ViolationQuery(true), paramSetId, focusLabel, " params.minCount <= ", propOrRel, propOrRel, focusLabel, (String)theConstraint.get("propShapeUid"), propOrRel, propOrRel, propOrRel, severity);
            } else {
                this.addCypherToValidationScripts(vc, new ArrayList<String>(Arrays.asList(focusLabel)), this.getMinCardinality1InverseViolationQuery(false), this.getMinCardinality1InverseViolationQuery(true), paramSetId, focusLabel, " params.minCount <= ", propOrRel, focusLabel, (String)theConstraint.get("propShapeUid"), propOrRel, propOrRel, severity);
            }
        }
        if (theConstraint.get("maxCount") != null) {
            paramSetId = theConstraint.get("propShapeUid") + "_" + SHACL.MAX_COUNT.stringValue();
            params = this.createNewSetOfParams(vc.getAllParams(), paramSetId);
            params.put("maxCount", theConstraint.get("maxCount"));
            if (!((Boolean)theConstraint.get("inverse")).booleanValue()) {
                this.addCypherToValidationScripts(vc, new ArrayList<String>(Arrays.asList(focusLabel)), this.getMaxCardinality1ViolationQuery(false), this.getMaxCardinality1ViolationQuery(true), paramSetId, focusLabel, propOrRel, propOrRel, " <= params.maxCount ", focusLabel, (String)theConstraint.get("propShapeUid"), propOrRel, propOrRel, propOrRel, severity);
            } else {
                this.addCypherToValidationScripts(vc, new ArrayList<String>(Arrays.asList(focusLabel)), this.getMaxCardinality1InverseViolationQuery(false), this.getMaxCardinality1InverseViolationQuery(true), paramSetId, focusLabel, propOrRel, " <= params.maxCount ", focusLabel, (String)theConstraint.get("propShapeUid"), propOrRel, propOrRel, severity);
            }
        }
        if (theConstraint.get("minStrLen") != null || theConstraint.get("maxStrLen") != null) {
            paramSetId = theConstraint.get("propShapeUid") + "_" + SHACL.MIN_LENGTH.stringValue();
            params = this.createNewSetOfParams(vc.getAllParams(), paramSetId);
            params.put("minStrLen", theConstraint.get("minStrLen"));
            params.put("maxStrLen", theConstraint.get("maxStrLen"));
            this.addCypherToValidationScripts(vc, new ArrayList<String>(Arrays.asList(focusLabel)), this.getStrLenViolationQuery(false), this.getStrLenViolationQuery(true), paramSetId, focusLabel, propOrRel, theConstraint.get("minStrLen") != null ? " params.minStrLen <= " : "", theConstraint.get("maxStrLen") != null ? " <= params.maxStrLen " : "", focusLabel, (String)theConstraint.get("propShapeUid"), propOrRel, propOrRel, severity);
        }
        if (theConstraint.get("minInc") != null || theConstraint.get("maxInc") != null || theConstraint.get("minExc") != null || theConstraint.get("maxExc") != null) {
            paramSetId = theConstraint.get("propShapeUid") + "_" + SHACL.MIN_EXCLUSIVE.stringValue();
            params = this.createNewSetOfParams(vc.getAllParams(), paramSetId);
            params.put("min", theConstraint.get("minInc") != null ? theConstraint.get("minInc") : theConstraint.get("minExc"));
            params.put("max", theConstraint.get("maxInc") != null ? theConstraint.get("maxInc") : theConstraint.get("maxExc"));
            String[] stringArray = new String[10];
            stringArray[0] = paramSetId;
            stringArray[1] = focusLabel;
            stringArray[2] = propOrRel;
            String string2 = theConstraint.get("minInc") != null ? " params.min <=" : (stringArray[3] = theConstraint.get("minExc") != null ? " params.min < " : "");
            stringArray[4] = theConstraint.get("maxInc") != null ? " <= params.max " : (theConstraint.get("maxExc") != null ? " < params.max " : "");
            stringArray[5] = focusLabel;
            stringArray[6] = (String)theConstraint.get("propShapeUid");
            stringArray[7] = propOrRel;
            stringArray[8] = propOrRel;
            stringArray[9] = severity;
            this.addCypherToValidationScripts(vc, new ArrayList<String>(Arrays.asList(focusLabel)), this.getValueRangeViolationQuery(false), this.getValueRangeViolationQuery(true), stringArray);
        }
        if (theConstraint.containsKey("constraintType") && theConstraint.get("constraintType").equals("closedDefinitionPropList")) {
            paramSetId = theConstraint.get("nodeShapeUid") + "_" + SHACL.CLOSED.stringValue();
            params = this.createNewSetOfParams(vc.getAllParams(), paramSetId);
            ArrayList<String> allowedPropsTranslated = new ArrayList<String>();
            for (String uri : (List)theConstraint.get("ignoredProps")) {
                if (uri.isEmpty()) continue;
                allowedPropsTranslated.add(UriUtils.translateUri(uri, this.tx, this.gc));
            }
            if (theConstraint.get("definedProps") != null) {
                for (String uri : (List)theConstraint.get("definedProps")) {
                    if (uri.isEmpty() || uri.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#type")) continue;
                    allowedPropsTranslated.add(UriUtils.translateUri(uri, this.tx, this.gc));
                }
            }
            params.put("allAllowedProps", allowedPropsTranslated);
            this.addCypherToValidationScripts(vc, new ArrayList<String>(Arrays.asList(focusLabel)), this.getNodeStructureViolationQuery(false), this.getNodeStructureViolationQuery(true), paramSetId, focusLabel, focusLabel, (String)theConstraint.get("nodeShapeUid"), "http://www.w3.org/ns/shacl#Violation");
        }
        if (theConstraint.get("disjointClass") != null) {
            for (String uri : (List)theConstraint.get("disjointClass")) {
                this.addCypherToValidationScripts(vc, new ArrayList<String>(Arrays.asList(focusLabel, UriUtils.translateUri(uri, this.tx, this.gc))), this.getDisjointClassesViolationQuery(false), this.getDisjointClassesViolationQuery(true), focusLabel, UriUtils.translateUri(uri, this.tx, this.gc), focusLabel, (String)theConstraint.get("nodeShapeUid"), UriUtils.translateUri(uri, this.tx, this.gc), "http://www.w3.org/ns/shacl#Violation", UriUtils.translateUri(uri, this.tx, this.gc));
            }
        }
    }

    void addPropertyConstraintsToList(Map<String, Object> propConstraint, ValidatorConfig vc) throws InvalidNamespacePrefixDefinitionInDB, UriUtils.UriNamespaceHasNoAssociatedPrefix {
        String propOrRel;
        String focusLabel = UriUtils.translateUri((String)propConstraint.get("appliesToCat"), this.tx, this.gc);
        String string = propOrRel = propConstraint.containsKey("item") ? UriUtils.translateUri((String)propConstraint.get("item"), this.tx, this.gc) : null;
        if (propConstraint.get("dataType") != null) {
            vc.addConstraintToList(new ConstraintComponent(focusLabel, propOrRel, (String)(this.shallIUseUriInsteadOfId() ? "sh:" + SHACL.DATATYPE.getLocalName() : SHACL.DATATYPE.getLocalName()), this.shallIUseUriInsteadOfId() ? propConstraint.get("dataType") : ((String)propConstraint.get("dataType")).substring(URIUtil.getLocalNameIndex((String)propConstraint.get("dataType")))));
        }
        if (propConstraint.get("hasValueUri") != null) {
            vc.addConstraintToList(new ConstraintComponent(focusLabel, propOrRel, (String)(this.shallIUseUriInsteadOfId() ? "sh:" + SHACL.HAS_VALUE.getLocalName() : SHACL.HAS_VALUE.getLocalName()), (List)propConstraint.get("hasValueUri")));
        }
        if (propConstraint.get("hasValueLiteral") != null) {
            vc.addConstraintToList(new ConstraintComponent(focusLabel, propOrRel, (String)(this.shallIUseUriInsteadOfId() ? "sh:" + SHACL.HAS_VALUE.getLocalName() : SHACL.HAS_VALUE.getLocalName()), (List)propConstraint.get("hasValueLiteral")));
        }
        if (propConstraint.get("rangeKind") != null) {
            vc.addConstraintToList(new ConstraintComponent(focusLabel, propOrRel, (String)(this.shallIUseUriInsteadOfId() ? "sh:" + SHACL.NODE_KIND.getLocalName() : SHACL.NODE_KIND.getLocalName()), this.shallIUseUriInsteadOfId() ? propConstraint.get("rangeKind") : ((String)propConstraint.get("rangeKind")).substring(URIUtil.getLocalNameIndex((String)propConstraint.get("rangeKind")))));
        }
        if (propConstraint.get("rangeType") != null && !propConstraint.get("rangeType").equals("")) {
            vc.addConstraintToList(new ConstraintComponent(focusLabel, propOrRel, (String)(this.shallIUseUriInsteadOfId() ? "sh:" + SHACL.CLASS.getLocalName() : SHACL.CLASS.getLocalName()), UriUtils.translateUri((String)propConstraint.get("rangeType"), this.tx, this.gc)));
        }
        if (propConstraint.get("inLiterals") != null) {
            vc.addConstraintToList(new ConstraintComponent(focusLabel, propOrRel, (String)(this.shallIUseUriInsteadOfId() ? "sh:" + SHACL.IN.getLocalName() : SHACL.IN.getLocalName()), (List)propConstraint.get("inLiterals")));
        }
        if (propConstraint.get("inUris") != null) {
            ArrayList inUrisRaw = (ArrayList)propConstraint.get("inUris");
            ArrayList inUrisLocal = new ArrayList();
            inUrisRaw.forEach(x -> inUrisLocal.add(x.substring(URIUtil.getLocalNameIndex(x))));
            vc.addConstraintToList(new ConstraintComponent(focusLabel, propOrRel, (String)(this.shallIUseUriInsteadOfId() ? "sh:" + SHACL.IN.getLocalName() : SHACL.IN.getLocalName()), this.shallIUseUriInsteadOfId() ? inUrisRaw : inUrisLocal));
        }
        if (propConstraint.get("pattern") != null) {
            vc.addConstraintToList(new ConstraintComponent(focusLabel, propOrRel, (String)(this.shallIUseUriInsteadOfId() ? "sh:" + SHACL.PATTERN.getLocalName() : SHACL.PATTERN.getLocalName()), propConstraint.get("pattern")));
        }
        if (propConstraint.get("minCount") != null) {
            vc.addConstraintToList(new ConstraintComponent(focusLabel, propOrRel, (String)(this.shallIUseUriInsteadOfId() ? "sh:" + SHACL.MIN_COUNT.getLocalName() : SHACL.MIN_COUNT.getLocalName()), propConstraint.get("minCount")));
        }
        if (propConstraint.get("maxCount") != null) {
            vc.addConstraintToList(new ConstraintComponent(focusLabel, propOrRel, (String)(this.shallIUseUriInsteadOfId() ? "sh:" + SHACL.MAX_COUNT.getLocalName() : SHACL.MAX_COUNT.getLocalName()), propConstraint.get("maxCount")));
        }
        if (propConstraint.get("minStrLen") != null) {
            vc.addConstraintToList(new ConstraintComponent(focusLabel, propOrRel, (String)(this.shallIUseUriInsteadOfId() ? "sh:" + SHACL.MIN_LENGTH.getLocalName() : SHACL.MIN_LENGTH.getLocalName()), propConstraint.get("minStrLen")));
        }
        if (propConstraint.get("maxStrLen") != null) {
            vc.addConstraintToList(new ConstraintComponent(focusLabel, propOrRel, (String)(this.shallIUseUriInsteadOfId() ? "sh:" + SHACL.MAX_LENGTH.getLocalName() : SHACL.MAX_LENGTH.getLocalName()), propConstraint.get("maxStrLen")));
        }
        if (propConstraint.get("minInc") != null) {
            vc.addConstraintToList(new ConstraintComponent(focusLabel, propOrRel, (String)(this.shallIUseUriInsteadOfId() ? "sh:" + SHACL.MIN_INCLUSIVE.getLocalName() : SHACL.MIN_INCLUSIVE.getLocalName()), propConstraint.get("minInc")));
        }
        if (propConstraint.get("maxInc") != null) {
            vc.addConstraintToList(new ConstraintComponent(focusLabel, propOrRel, (String)(this.shallIUseUriInsteadOfId() ? "sh:" + SHACL.MAX_INCLUSIVE.getLocalName() : SHACL.MAX_INCLUSIVE.getLocalName()), propConstraint.get("maxInc")));
        }
        if (propConstraint.get("minExc") != null) {
            vc.addConstraintToList(new ConstraintComponent(focusLabel, propOrRel, (String)(this.shallIUseUriInsteadOfId() ? "sh:" + SHACL.MIN_EXCLUSIVE.getLocalName() : SHACL.MIN_EXCLUSIVE.getLocalName()), propConstraint.get("minExc")));
        }
        if (propConstraint.get("maxExc") != null) {
            vc.addConstraintToList(new ConstraintComponent(focusLabel, propOrRel, (String)(this.shallIUseUriInsteadOfId() ? "sh:" + SHACL.MAX_EXCLUSIVE.getLocalName() : SHACL.MAX_EXCLUSIVE.getLocalName()), propConstraint.get("maxExc")));
        }
        if (propConstraint.containsKey("constraintType") && propConstraint.get("constraintType").equals("closedDefinitionPropList")) {
            List ignoredUrisRaw = (List)propConstraint.get("ignoredProps");
            ArrayList<String> ignoredUrisTranslated = new ArrayList<String>();
            for (String x2 : ignoredUrisRaw) {
                if (x2.isEmpty() || x2.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#type")) continue;
                ignoredUrisTranslated.add(UriUtils.translateUri(x2, this.tx, this.gc));
            }
            vc.addConstraintToList(new ConstraintComponent(focusLabel, propOrRel, (String)(this.shallIUseUriInsteadOfId() ? "sh:" + SHACL.IGNORED_PROPERTIES.getLocalName() : SHACL.IGNORED_PROPERTIES.getLocalName()), ignoredUrisTranslated));
        }
        if (propConstraint.get("disjointClass") != null) {
            List disjointClassesRaw = (List)propConstraint.get("disjointClass");
            for (String x3 : disjointClassesRaw) {
                vc.addConstraintToList(new ConstraintComponent(focusLabel, propOrRel, (String)(this.shallIUseUriInsteadOfId() ? "sh:" + SHACL.NOT.getLocalName() : SHACL.NOT.getLocalName()), UriUtils.translateUri(x3, this.tx, this.gc)));
            }
        }
    }

    private Map<String, Object> createNewSetOfParams(Map<String, Object> allParams, String id) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        allParams.put(id, params);
        return params;
    }

    protected Iterator<Map<String, Object>> parseConstraints(InputStream is, RDFFormat format, Map<String, Object> props) throws IOException {
        SailRepository repo = new SailRepository(new MemoryStore());
        ArrayList constraints = new ArrayList();
        try (RepositoryConnection conn = repo.getConnection();){
            BindingSet next;
            HashMap<String, Object> record;
            conn.getParserConfig().set((RioSetting)BasicParserSettings.VERIFY_URI_SYNTAX, (Object)(props.containsKey("verifyUriSyntax") ? (Boolean)props.get("verifyUriSyntax") : true));
            conn.begin();
            conn.add((Reader)new InputStreamReader(is), "http://neo4j.com/base/", format, new Resource[0]);
            conn.commit();
            TupleQuery tupleQuery = conn.prepareTupleQuery(QueryLanguage.SPARQL, this.PROP_CONSTRAINT_QUERY);
            TupleQueryResult queryResult = tupleQuery.evaluate();
            while (queryResult.hasNext()) {
                Value path;
                record = new HashMap<String, Object>();
                next = (BindingSet)queryResult.next();
                Value value = path = next.hasBinding("invPath") ? next.getValue("invPath") : next.getValue("path");
                if (path instanceof BNode) {
                    this.log.debug("current version only processes single property paths");
                    continue;
                }
                record.put("item", path.stringValue());
                record.put("inverse", next.hasBinding("invPath"));
                record.put("appliesToCat", next.hasBinding("targetClass") ? next.getValue("targetClass").stringValue() : null);
                record.put("rangeType", next.hasBinding("rangeClass") ? next.getValue("rangeClass").stringValue() : null);
                record.put("rangeKind", next.hasBinding("rangeKind") ? next.getValue("rangeKind").stringValue() : null);
                record.put("dataType", next.hasBinding("datatype") ? next.getValue("datatype").stringValue() : null);
                record.put("pattern", next.hasBinding("pattern") ? next.getValue("pattern").stringValue() : null);
                record.put("maxCount", next.hasBinding("maxCount") ? Integer.valueOf(((Literal)next.getValue("maxCount")).intValue()) : null);
                record.put("minCount", next.hasBinding("minCount") ? Integer.valueOf(((Literal)next.getValue("minCount")).intValue()) : null);
                record.put("minInc", next.hasBinding("minInc") ? Integer.valueOf(((Literal)next.getValue("minInc")).intValue()) : null);
                record.put("minExc", next.hasBinding("minExc") ? Integer.valueOf(((Literal)next.getValue("minExc")).intValue()) : null);
                record.put("maxInc", next.hasBinding("maxInc") ? Integer.valueOf(((Literal)next.getValue("maxInc")).intValue()) : null);
                record.put("maxExc", next.hasBinding("maxExc") ? Integer.valueOf(((Literal)next.getValue("maxExc")).intValue()) : null);
                if (next.hasBinding("hasValueLiterals") && !next.getValue("hasValueLiterals").stringValue().equals("")) {
                    List<String> hasValueLiterals = Arrays.asList(next.getValue("hasValueLiterals").stringValue().split("---"));
                    record.put("hasValueLiteral", hasValueLiterals);
                }
                if (next.hasBinding("hasValueUris") && !next.getValue("hasValueUris").stringValue().equals("")) {
                    List<String> hasValueUris = Arrays.asList(next.getValue("hasValueUris").stringValue().split("---"));
                    record.put("hasValueUri", hasValueUris);
                }
                if (next.hasBinding("isliteralIns")) {
                    List<String> inVals = Arrays.asList(next.getValue("ins").stringValue().split("---"));
                    Literal val = (Literal)next.getValue("isliteralIns");
                    if (val.booleanValue()) {
                        record.put("inLiterals", inVals);
                    } else {
                        record.put("inUris", inVals);
                    }
                }
                record.put("minStrLen", next.hasBinding("minStrLen") ? Integer.valueOf(((Literal)next.getValue("minStrLen")).intValue()) : null);
                record.put("maxStrLen", next.hasBinding("maxStrLen") ? Integer.valueOf(((Literal)next.getValue("maxStrLen")).intValue()) : null);
                Value value2 = next.getValue("ps");
                if (value2 instanceof BNode) {
                    record.put("propShapeUid", BNODE_PREFIX + value2.stringValue());
                } else {
                    record.put("propShapeUid", value2.stringValue());
                }
                record.put("severity", next.hasBinding("severity") ? next.getValue("severity").stringValue() : "http://www.w3.org/ns/shacl#Violation");
                constraints.add(record);
            }
            tupleQuery = conn.prepareTupleQuery(QueryLanguage.SPARQL, this.NODE_CONSTRAINT_QUERY);
            queryResult = tupleQuery.evaluate();
            while (queryResult.hasNext()) {
                record = new HashMap();
                next = (BindingSet)queryResult.next();
                record.put("constraintType", "closedDefinitionPropList");
                record.put("appliesToCat", next.getValue("targetClass").stringValue());
                record.put("nodeShapeUid", next.hasBinding("ns") ? next.getValue("ns").stringValue() : null);
                if (next.hasBinding("definedProps")) {
                    record.put("definedProps", Arrays.asList(next.getValue("definedProps").stringValue().split("---")));
                }
                if (next.hasBinding("ignoredProps")) {
                    record.put("ignoredProps", Arrays.asList(next.getValue("ignoredProps").stringValue().split("---")));
                }
                constraints.add(record);
            }
            tupleQuery = conn.prepareTupleQuery(QueryLanguage.SPARQL, this.NODE_ADDITIONAL_CONSTRAINT_QUERY);
            queryResult = tupleQuery.evaluate();
            while (queryResult.hasNext()) {
                record = new HashMap();
                next = (BindingSet)queryResult.next();
                record.put("appliesToCat", next.getValue("targetClass").stringValue());
                record.put("nodeShapeUid", next.hasBinding("ns") ? next.getValue("ns").stringValue() : null);
                if (next.hasBinding("class")) {
                    record.put("reqClass", Arrays.asList(next.getValue("class").stringValue().split("---")));
                }
                if (next.hasBinding("disjointclass")) {
                    record.put("disjointClass", Arrays.asList(next.getValue("disjointclass").stringValue().split("---")));
                }
                constraints.add(record);
            }
        }
        return constraints.iterator();
    }

    private String getDatatypeCastExpressionPref(String dataType) {
        if (dataType.equals(XMLSchema.BOOLEAN.stringValue())) {
            return "coalesce(toBoolean(toString(";
        }
        if (dataType.equals(XMLSchema.STRING.stringValue())) {
            return "coalesce(toString(";
        }
        if (dataType.equals(XMLSchema.INTEGER.stringValue())) {
            return "coalesce(toInteger(";
        }
        if (dataType.equals(XMLSchema.FLOAT.stringValue())) {
            return "coalesce(toFloat(";
        }
        if (dataType.equals(XMLSchema.DATE.stringValue())) {
            return "n10s.aux.dt.check('" + XMLSchema.DATE.stringValue() + "',";
        }
        if (dataType.equals(XMLSchema.DATETIME.stringValue())) {
            return "n10s.aux.dt.check('" + XMLSchema.DATETIME.stringValue() + "',";
        }
        if (dataType.equals(Params.WKTLITERAL_URI.stringValue())) {
            return "n10s.aux.dt.check('" + Params.WKTLITERAL_URI.stringValue() + "',";
        }
        if (dataType.equals(XMLSchema.ANYURI.stringValue())) {
            return "n10s.aux.dt.check('" + XMLSchema.ANYURI.stringValue() + "',";
        }
        return "";
    }

    private String getDatatypeCastExpressionSuff(String dataType) {
        if (dataType.equals(XMLSchema.BOOLEAN.stringValue())) {
            return ")) = x , false)";
        }
        if (dataType.equals(XMLSchema.STRING.stringValue())) {
            return ") = x , false)";
        }
        if (dataType.equals(XMLSchema.INTEGER.stringValue())) {
            return ") = x , false)";
        }
        if (dataType.equals(XMLSchema.FLOAT.stringValue())) {
            return ") = x , false)";
        }
        if (dataType.equals(XMLSchema.DATE.stringValue())) {
            return ")";
        }
        if (dataType.equals(XMLSchema.DATETIME.stringValue())) {
            return ")";
        }
        if (dataType.equals(Params.WKTLITERAL_URI.stringValue())) {
            return ")";
        }
        if (dataType.equals(XMLSchema.ANYURI.stringValue())) {
            return ")";
        }
        return "";
    }

    private void addCypherToValidationScripts(ValidatorConfig vc, List<String> triggers, String querystrGlobal, String querystrOnNodeset, String ... args) {
        vc.addQueryAndTriggers("Q_" + (vc.getIndividualGlobalQueries().size() + 1), String.format(querystrGlobal, args), String.format(querystrOnNodeset, args), triggers);
    }

    private String getDataTypeViolationQuery(boolean tx) {
        return this.getQuery(CYPHER_MATCH_WHERE, tx, this.CYPHER_DATATYPE_V_SUFF());
    }

    private String getDataTypeViolationQuery2(boolean tx) {
        return this.getQuery(CYPHER_MATCH_REL_WHERE, tx, this.CYPHER_DATATYPE2_V_SUFF());
    }

    private String getRangeIRIKindViolationQuery(boolean tx) {
        return this.getQuery(CYPHER_MATCH_WHERE, tx, this.CYPHER_IRI_KIND_V_SUFF());
    }

    private String getRangeLiteralKindViolationQuery(boolean tx) {
        return this.getQuery(CYPHER_MATCH_WHERE, tx, this.CYPHER_LITERAL_KIND_V_SUFF());
    }

    private String getRangeType1ViolationQuery(boolean tx) {
        return this.getQuery(CYPHER_MATCH_REL_WHERE, tx, this.CYPHER_RANGETYPE1_V_SUFF());
    }

    private String getRangeType2ViolationQuery(boolean tx) {
        return this.getQuery(CYPHER_MATCH_WHERE, tx, this.CYPHER_RANGETYPE2_V_SUFF());
    }

    private String getRegexViolationQuery(boolean tx) {
        return this.getQuery(CYPHER_WITH_PARAMS_MATCH_WHERE, tx, this.CYPHER_REGEX_V_SUFF());
    }

    private String getHasValueUriViolationQuery(boolean tx) {
        return this.getQuery(CYPHER_WITH_PARAMS_MATCH_WHERE, tx, this.CYPHER_HAS_VALUE_URI_V_SUFF());
    }

    private String getHasValueLiteralViolationQuery(boolean tx) {
        return this.getQuery(CYPHER_WITH_PARAMS_MATCH_WHERE, tx, this.CYPHER_HAS_VALUE_LITERAL_V_SUFF());
    }

    private String getInLiteralsViolationQuery(boolean tx) {
        return this.getQuery(CYPHER_WITH_PARAMS_MATCH_WHERE, tx, this.CYPHER_IN_LITERAL_V_SUFF());
    }

    private String getInUrisViolationQuery(boolean tx) {
        return this.getQuery(CYPHER_WITH_PARAMS_MATCH_WHERE, tx, this.CYPHER_IN_URI_V_SUFF());
    }

    private String getMinCardinality1ViolationQuery(boolean tx) {
        return this.getQuery(CYPHER_WITH_PARAMS_MATCH_WHERE, tx, this.CYPHER_MIN_CARDINALITY1_V_SUFF());
    }

    private String getMinCardinality1InverseViolationQuery(boolean tx) {
        return this.getQuery(CYPHER_WITH_PARAMS_MATCH_WHERE, tx, this.CYPHER_MIN_CARDINALITY1_INVERSE_V_SUFF());
    }

    private String getMaxCardinality1ViolationQuery(boolean tx) {
        return this.getQuery(CYPHER_WITH_PARAMS_MATCH_WHERE, tx, this.CYPHER_MAX_CARDINALITY1_V_SUFF());
    }

    private String getMaxCardinality1InverseViolationQuery(boolean tx) {
        return this.getQuery(CYPHER_WITH_PARAMS_MATCH_WHERE, tx, this.CYPHER_MAX_CARDINALITY1_INVERSE_V_SUFF());
    }

    private String getStrLenViolationQuery(boolean tx) {
        return this.getQuery(CYPHER_WITH_PARAMS_MATCH_WHERE, tx, this.CYPHER_STRLEN_V_SUFF());
    }

    private String getValueRangeViolationQuery(boolean tx) {
        return this.getQuery(CYPHER_WITH_PARAMS_MATCH_WHERE, tx, this.CYPHER_VALRANGE_V_SUFF());
    }

    private String getNodeStructureViolationQuery(boolean tx) {
        return this.getQuery(CYPHER_WITH_PARAMS_MATCH_WHERE, tx, this.CYPHER_NODE_STRUCTURE_V_SUFF());
    }

    private String getDisjointClassesViolationQuery(boolean tx) {
        return this.getQuery(CYPHER_MATCH_WHERE, tx, this.CYPHER_NODE_DISJOINT_WITH_V_SUFF());
    }

    private boolean shallIUseUriInsteadOfId() {
        return this.gc != null && (this.gc.getHandleVocabUris() == 0 || this.gc.getHandleVocabUris() == 1 || this.gc.getHandleVocabUris() == 3 || this.gc.getHandleVocabUris() == 4);
    }

    private boolean shallIShorten() {
        return this.gc != null && (this.gc.getHandleVocabUris() == 0 || this.gc.getHandleVocabUris() == 1 || this.gc.getHandleVocabUris() == 3);
    }

    private String getQuery(String pref, boolean tx, String suff) {
        return pref + (tx ? CYPHER_TX_INFIX : "") + suff;
    }

    private String CYPHER_DATATYPE_V_SUFF() {
        return " NOT all(x in [] +  focus.`%s` where %s x %s ) RETURN " + (this.shallIUseUriInsteadOfId() ? " focus.uri " : " id(focus) ") + " as nodeId, " + (this.shallIShorten() ? "n10s.rdf.fullUriFromShortForm('%s')" : " '%s' ") + " as nodeType, '%s' as shapeId, '" + SHACL.DATATYPE_CONSTRAINT_COMPONENT + "' as propertyShape, focus.`%s` as offendingValue, " + (this.shallIShorten() ? "n10s.rdf.fullUriFromShortForm('%s')" : " '%s' ") + " as propertyName, '%s' as severity, 'property value should be of type ' + " + (this.shallIUseUriInsteadOfId() ? " '%s' " : "n10s.rdf.getIRILocalName('%s')") + " as message ";
    }

    private String CYPHER_DATATYPE2_V_SUFF() {
        return " true RETURN " + (this.shallIUseUriInsteadOfId() ? " focus.uri " : " id(focus) ") + " as nodeId, " + (this.shallIShorten() ? "n10s.rdf.fullUriFromShortForm('%s')" : " '%s' ") + " as nodeType, '%s' as shapeId, '" + SHACL.DATATYPE_CONSTRAINT_COMPONENT + "' as propertyShape, " + (this.shallIUseUriInsteadOfId() ? " x.uri " : " 'node id: ' + id(x) ") + "as offendingValue, " + (this.shallIShorten() ? "n10s.rdf.fullUriFromShortForm('%s')" : " '%s' ") + " as propertyName, '%s' as severity, " + (this.shallIShorten() ? "n10s.rdf.fullUriFromShortForm('%s')" : " '%s' ") + " + ' should be a property, instead it  is a relationship' as message ";
    }

    private String CYPHER_IRI_KIND_V_SUFF() {
        return " (focus)-[:`%s`]->() RETURN " + (this.shallIUseUriInsteadOfId() ? " focus.uri " : " id(focus) ") + " as nodeId, " + (this.shallIShorten() ? "n10s.rdf.fullUriFromShortForm('%s')" : " '%s' ") + " as nodeType, '%s' as shapeId, '" + SHACL.NODE_KIND_CONSTRAINT_COMPONENT + "' as propertyShape, null as offendingValue, " + (this.shallIShorten() ? "n10s.rdf.fullUriFromShortForm('%s')" : " '%s' ") + " as propertyName, '%s' as severity," + (this.shallIShorten() ? "n10s.rdf.fullUriFromShortForm('%s')" : " '%s' ") + " + ' should be a property ' as message  ";
    }

    private String CYPHER_LITERAL_KIND_V_SUFF() {
        return " exists(focus.`%s`) RETURN " + (this.shallIUseUriInsteadOfId() ? " focus.uri " : " id(focus) ") + " as nodeId, " + (this.shallIShorten() ? "n10s.rdf.fullUriFromShortForm('%s')" : " '%s' ") + " as nodeType, '%s' as shapeId, '" + SHACL.NODE_KIND_CONSTRAINT_COMPONENT + "' as propertyShape, null as offendingValue, " + (this.shallIShorten() ? "n10s.rdf.fullUriFromShortForm('%s')" : " '%s' ") + " as propertyName, '%s' as severity," + (this.shallIShorten() ? "n10s.rdf.fullUriFromShortForm('%s')" : " '%s' ") + " + ' should be a relationship ' as message  ";
    }

    private String CYPHER_RANGETYPE1_V_SUFF() {
        return "NOT x:`%s` RETURN " + (this.shallIUseUriInsteadOfId() ? " focus.uri " : " id(focus) ") + " as nodeId, " + (this.shallIShorten() ? "n10s.rdf.fullUriFromShortForm('%s')" : " '%s' ") + " as nodeType, '%s' as shapeId, '" + SHACL.CLASS_CONSTRAINT_COMPONENT + "' as propertyShape, " + (this.shallIUseUriInsteadOfId() ? " x.uri " : " id(x) ") + " as offendingValue, " + (this.shallIShorten() ? "n10s.rdf.fullUriFromShortForm('%s')" : " '%s' ") + " as propertyName, '%s' as severity, 'value should be of type ' + " + (this.shallIShorten() ? "n10s.rdf.fullUriFromShortForm('%s')" : " '%s' ") + " as message  ";
    }

    private String CYPHER_RANGETYPE2_V_SUFF() {
        return "exists(focus.`%s`) RETURN " + (this.shallIUseUriInsteadOfId() ? " focus.uri " : " id(focus) ") + " as nodeId, " + (this.shallIShorten() ? "n10s.rdf.fullUriFromShortForm('%s')" : " '%s' ") + " as nodeType, '%s' as shapeId, '" + SHACL.CLASS_CONSTRAINT_COMPONENT + "' as propertyShape, null as offendingValue, " + (this.shallIShorten() ? "n10s.rdf.fullUriFromShortForm('%s')" : " '%s' ") + " as propertyName, '%s' as severity, '%s should be a relationship but it is a property' as message  ";
    }

    private String CYPHER_REGEX_V_SUFF() {
        return "NOT all(x in [] +  coalesce(focus.`%s`,[]) where toString(x) =~ params.theRegex )   UNWIND [x in [] +  coalesce(focus.`%s`,[]) where not toString(x) =~ params.theRegex ]  as offval RETURN " + (this.shallIUseUriInsteadOfId() ? " focus.uri " : " id(focus) ") + " as nodeId, " + (this.shallIShorten() ? "n10s.rdf.fullUriFromShortForm('%s')" : " '%s' ") + " as nodeType, '%s' as shapeId, '" + SHACL.PATTERN_CONSTRAINT_COMPONENT.stringValue() + "' as propertyShape, offval as offendingValue, " + (this.shallIShorten() ? "n10s.rdf.fullUriFromShortForm('%s')" : " '%s' ") + " as propertyName, '%s' as severity, '' as message  ";
    }

    private String CYPHER_HAS_VALUE_URI_V_SUFF() {
        return " true with params, focus unwind params.theHasValueUri as reqVal with focus, reqVal where not reqVal in [(focus)-[:`%s`]->(v) | v.uri ] RETURN " + (this.shallIUseUriInsteadOfId() ? " focus.uri " : " id(focus) ") + " as nodeId, " + (this.shallIShorten() ? "n10s.rdf.fullUriFromShortForm('%s')" : " '%s' ") + " as nodeType, '%s' as shapeId, '" + SHACL.HAS_VALUE_CONSTRAINT_COMPONENT.stringValue() + "' as propertyShape, null as offendingValue, " + (this.shallIShorten() ? "n10s.rdf.fullUriFromShortForm('%s')" : " '%s' ") + " as propertyName, '%s' as severity, 'The required value ' + reqVal  + ' could not be found as value of relationship ' + " + (this.shallIShorten() ? "n10s.rdf.fullUriFromShortForm('%s') " : " '%s' ") + " as message  ";
    }

    private String CYPHER_HAS_VALUE_LITERAL_V_SUFF() {
        return " true with params, focus unwind params.theHasValueLiteral as  reqVal with focus, reqVal where not reqVal in [] + focus.`%s` RETURN " + (this.shallIUseUriInsteadOfId() ? " focus.uri " : " id(focus) ") + " as nodeId, " + (this.shallIShorten() ? "n10s.rdf.fullUriFromShortForm('%s')" : " '%s' ") + " as nodeType, '%s' as shapeId, '" + SHACL.HAS_VALUE_CONSTRAINT_COMPONENT.stringValue() + "' as propertyShape, null as offendingValue, " + (this.shallIShorten() ? "n10s.rdf.fullUriFromShortForm('%s')" : " '%s' ") + " as propertyName, '%s' as severity, 'The required value \"'+ reqVal + '\" was not found in property ' + " + (this.shallIShorten() ? "n10s.rdf.fullUriFromShortForm('%s') " : " '%s' ") + " as message  ";
    }

    private String CYPHER_IN_LITERAL_V_SUFF() {
        return " true with params, focus unwind [] + focus.`%s` as val with focus, val where not val in params.theInLiterals RETURN " + (this.shallIUseUriInsteadOfId() ? " focus.uri " : " id(focus) ") + " as nodeId, " + (this.shallIShorten() ? "n10s.rdf.fullUriFromShortForm('%s')" : " '%s' ") + " as nodeType, '%s' as shapeId, '" + SHACL.IN_CONSTRAINT_COMPONENT.stringValue() + "' as propertyShape, val as offendingValue, " + (this.shallIShorten() ? "n10s.rdf.fullUriFromShortForm('%s')" : " '%s' ") + " as propertyName, '%s' as severity, 'The value \"'+ val + '\" in property ' + " + (this.shallIShorten() ? "n10s.rdf.fullUriFromShortForm('%s') " : " '%s'") + "+ 'is not in  the accepted list' as message  ";
    }

    private String CYPHER_IN_URI_V_SUFF() {
        return " true with params, focus unwind [(focus)-[:`%s`]->(x) | x ] as val with focus, val where not val.uri in params.theInUris RETURN " + (this.shallIUseUriInsteadOfId() ? " focus.uri " : " id(focus) ") + " as nodeId, " + (this.shallIShorten() ? "n10s.rdf.fullUriFromShortForm('%s')" : " '%s' ") + " as nodeType, '%s' as shapeId, '" + SHACL.IN_CONSTRAINT_COMPONENT.stringValue() + "' as propertyShape, " + (this.shallIUseUriInsteadOfId() ? "val.uri" : "id(val)") + " as offendingValue, " + (this.shallIShorten() ? "n10s.rdf.fullUriFromShortForm('%s')" : " '%s' ") + " as propertyName, '%s' as severity, 'The value \"'+ " + (this.shallIUseUriInsteadOfId() ? " val.uri " : " 'node id: '  + id(val) ") + " + '\" in property ' + " + (this.shallIShorten() ? "n10s.rdf.fullUriFromShortForm('%s') " : " '%s'") + "+ ' is not in  the accepted list' as message  ";
    }

    private String CYPHER_VALRANGE_V_SUFF() {
        return "NOT all(x in [] +  focus.`%s` where %s x %s ) RETURN " + (this.shallIUseUriInsteadOfId() ? " focus.uri " : " id(focus) ") + " as nodeId, " + (this.shallIShorten() ? "n10s.rdf.fullUriFromShortForm('%s')" : " '%s' ") + " as nodeType, '%s' as shapeId, '" + SHACL.MIN_EXCLUSIVE_CONSTRAINT_COMPONENT.stringValue() + "' as propertyShape, focus.`%s` as offendingValue, " + (this.shallIShorten() ? "n10s.rdf.fullUriFromShortForm('%s')" : " '%s' ") + " as propertyName, '%s' as severity, '' as message  ";
    }

    private String CYPHER_MIN_CARDINALITY1_V_SUFF() {
        return "NOT %s ( size((focus)-[:`%s`]->()) +  size([] + coalesce(focus.`%s`, [])) )  RETURN " + (this.shallIUseUriInsteadOfId() ? " focus.uri " : " id(focus) ") + " as nodeId, " + (this.shallIShorten() ? "n10s.rdf.fullUriFromShortForm('%s')" : " '%s' ") + " as nodeType, '%s' as shapeId, '" + SHACL.MIN_COUNT_CONSTRAINT_COMPONENT + "' as propertyShape,  'unnacceptable cardinality: ' + (coalesce(size((focus)-[:`%s`]->()),0) + coalesce(size([] + focus.`%s`),0))  as message, " + (this.shallIShorten() ? "n10s.rdf.fullUriFromShortForm('%s')" : " '%s' ") + " as propertyName, '%s' as severity, null as offendingValue  ";
    }

    private String CYPHER_MAX_CARDINALITY1_V_SUFF() {
        return "NOT (size((focus)-[:`%s`]->()) + size([] + coalesce(focus.`%s`,[]))) %s  RETURN " + (this.shallIUseUriInsteadOfId() ? " focus.uri " : " id(focus) ") + " as nodeId, " + (this.shallIShorten() ? "n10s.rdf.fullUriFromShortForm('%s')" : " '%s' ") + " as nodeType, '%s' as shapeId, '" + SHACL.MAX_COUNT_CONSTRAINT_COMPONENT + "' as propertyShape,  'unnacceptable  cardinality: ' + (coalesce(size((focus)-[:`%s`]->()),0) + coalesce(size([] + focus.`%s`),0)) as message, " + (this.shallIShorten() ? "n10s.rdf.fullUriFromShortForm('%s')" : " '%s' ") + " as propertyName, '%s' as severity, null as offendingValue  ";
    }

    private String CYPHER_MIN_CARDINALITY1_INVERSE_V_SUFF() {
        return "NOT %s size((focus)<-[:`%s`]-()) RETURN " + (this.shallIUseUriInsteadOfId() ? " focus.uri " : " id(focus) ") + " as nodeId, " + (this.shallIShorten() ? "n10s.rdf.fullUriFromShortForm('%s')" : " '%s' ") + " as nodeType, '%s' as shapeId, '" + SHACL.MIN_COUNT_CONSTRAINT_COMPONENT + "' as propertyShape,  'unnacceptable cardinality: ' + coalesce(size((focus)<-[:`%s`]-()),0) as message, " + (this.shallIShorten() ? "n10s.rdf.fullUriFromShortForm('%s')" : " '%s' ") + " as propertyName, '%s' as severity, null as offendingValue  ";
    }

    private String CYPHER_MAX_CARDINALITY1_INVERSE_V_SUFF() {
        return "NOT size((focus)<-[:`%s`]-()) %s RETURN " + (this.shallIUseUriInsteadOfId() ? " focus.uri " : " id(focus) ") + " as nodeId, " + (this.shallIShorten() ? "n10s.rdf.fullUriFromShortForm('%s')" : " '%s' ") + " as nodeType, '%s' as shapeId, '" + SHACL.MAX_COUNT_CONSTRAINT_COMPONENT + "' as propertyShape,  'unacceptable cardinality: ' + coalesce(size((focus)<-[:`%s`]-()),0) as message, " + (this.shallIShorten() ? "n10s.rdf.fullUriFromShortForm('%s')" : " '%s' ") + " as propertyName, '%s' as severity, null as offendingValue  ";
    }

    private String CYPHER_STRLEN_V_SUFF() {
        return "NOT all(x in [] +  focus.`%s` where %s size(toString(x)) %s ) RETURN " + (this.shallIUseUriInsteadOfId() ? " focus.uri " : " id(focus) ") + " as nodeId, " + (this.shallIShorten() ? "n10s.rdf.fullUriFromShortForm('%s')" : " '%s' ") + " as nodeType, '%s' as shapeId, '" + SHACL.MAX_LENGTH_CONSTRAINT_COMPONENT + "' as propertyShape, focus.`%s` as offendingValue, " + (this.shallIShorten() ? "n10s.rdf.fullUriFromShortForm('%s')" : " '%s' ") + " as propertyName, '%s' as severity, '' as message  ";
    }

    private String CYPHER_NODE_STRUCTURE_V_SUFF() {
        return " true \nUNWIND [ x in [(focus)-[r]->()| type(r)] where not x in params.allAllowedProps] + [ x in keys(focus) where " + (this.shallIUseUriInsteadOfId() ? " x <> 'uri' and " : "") + " not x in params.allAllowedProps] as noProp\nRETURN  " + (this.shallIUseUriInsteadOfId() ? " focus.uri " : " id(focus) ") + " as nodeId , " + (this.shallIShorten() ? "n10s.rdf.fullUriFromShortForm('%s')" : " '%s' ") + " as nodeType, '%s' as shapeId, '" + SHACL.CLOSED_CONSTRAINT_COMPONENT.stringValue() + "' as propertyShape, substring(reduce(result='', x in [] + coalesce(focus[noProp],[(focus)-[r]-(x) where type(r)=noProp | " + (this.shallIUseUriInsteadOfId() ? " x.uri " : " id(x) ") + "]) | result + ', ' + x ),2) as offendingValue, " + (this.shallIShorten() ? "n10s.rdf.fullUriFromShortForm(noProp)" : " noProp ") + " as propertyName, '%s' as severity, 'Closed type definition does not include this property/relationship' as message  ";
    }

    private String CYPHER_NODE_DISJOINT_WITH_V_SUFF() {
        return " focus:`%s` RETURN " + (this.shallIUseUriInsteadOfId() ? " focus.uri " : " id(focus) ") + " as nodeId, " + (this.shallIShorten() ? "n10s.rdf.fullUriFromShortForm('%s')" : " '%s' ") + " as nodeType, '%s' as shapeId, '" + SHACL.NOT_CONSTRAINT_COMPONENT + "' as propertyShape, '%s' as offendingValue,  '-' as propertyName, '%s' as severity,  'type not allowed: ' + '%s' as message  ";
    }
}

