/*
 * Decompiled with CFR 0.152.
 */
package n10s.result;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import n10s.Util;
import n10s.result.VirtualRelationship;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.internal.helpers.collection.FilteringIterable;
import org.neo4j.internal.helpers.collection.Iterables;

public class VirtualNode
implements Node {
    private static AtomicLong MIN_ID = new AtomicLong(-1L);
    private final Set<String> labels = new LinkedHashSet<String>();
    private final Map<String, Object> props = new HashMap<String, Object>();
    private final List<Relationship> rels = new ArrayList<Relationship>();
    private final long id;

    public VirtualNode(Label[] labels, Map<String, Object> props) {
        this.id = MIN_ID.getAndDecrement();
        this.addLabels(Arrays.asList(labels));
        this.props.putAll(props);
    }

    public VirtualNode(long nodeId, Label[] labels, Map<String, Object> props) {
        this.id = nodeId;
        this.addLabels(Arrays.asList(labels));
        this.props.putAll(props);
    }

    public VirtualNode(long nodeId) {
        this.id = nodeId;
    }

    public VirtualNode(Node node, List<String> propertyNames) {
        this.id = node.getId();
        this.labels.addAll(Util.labelStrings(node));
        String[] keys = propertyNames.toArray(new String[propertyNames.size()]);
        this.props.putAll(node.getProperties(keys));
    }

    public long getId() {
        return this.id;
    }

    public void delete() {
        for (Relationship rel : this.rels) {
            rel.delete();
        }
    }

    public Iterable<Relationship> getRelationships() {
        return this.rels;
    }

    public boolean hasRelationship() {
        return !this.rels.isEmpty();
    }

    public Iterable<Relationship> getRelationships(RelationshipType ... relationshipTypes) {
        return new FilteringIterable(this.rels, r -> this.isType((Relationship)r, relationshipTypes));
    }

    private boolean isType(Relationship r, RelationshipType ... relationshipTypes) {
        for (RelationshipType type : relationshipTypes) {
            if (!r.isType(type)) continue;
            return true;
        }
        return false;
    }

    public Iterable<Relationship> getRelationships(Direction direction, RelationshipType ... relationshipTypes) {
        return new FilteringIterable(this.rels, r -> this.isType((Relationship)r, relationshipTypes) && this.isDirection((Relationship)r, direction));
    }

    private boolean isDirection(Relationship r, Direction direction) {
        return direction == Direction.BOTH || direction == Direction.OUTGOING && r.getStartNode().equals(this) || direction == Direction.INCOMING && r.getEndNode().equals(this);
    }

    public boolean hasRelationship(RelationshipType ... relationshipTypes) {
        return this.getRelationships(relationshipTypes).iterator().hasNext();
    }

    public boolean hasRelationship(Direction direction, RelationshipType ... relationshipTypes) {
        return this.getRelationships(direction, relationshipTypes).iterator().hasNext();
    }

    public Iterable<Relationship> getRelationships(Direction direction) {
        return new FilteringIterable(this.rels, r -> this.isDirection((Relationship)r, direction));
    }

    public boolean hasRelationship(Direction direction) {
        return this.getRelationships(direction).iterator().hasNext();
    }

    public Relationship getSingleRelationship(RelationshipType relationshipType, Direction direction) {
        return (Relationship)Iterables.single(this.getRelationships(direction, relationshipType));
    }

    public VirtualRelationship createRelationshipTo(Node node, RelationshipType relationshipType) {
        VirtualRelationship rel = new VirtualRelationship(this, node, relationshipType);
        this.rels.add(rel);
        if (node instanceof VirtualNode) {
            VirtualNode target = (VirtualNode)node;
            if (!target.rels.contains(rel)) {
                target.rels.add(rel);
            }
        }
        return rel;
    }

    public VirtualRelationship createRelationshipFrom(Node start, RelationshipType relationshipType) {
        VirtualRelationship rel = new VirtualRelationship(start, this, relationshipType);
        this.rels.add(rel);
        if (start instanceof VirtualNode) {
            VirtualNode startVirtual = (VirtualNode)start;
            if (!startVirtual.rels.contains(rel)) {
                startVirtual.rels.add(rel);
            }
        }
        return rel;
    }

    public Iterable<RelationshipType> getRelationshipTypes() {
        return this.rels.stream().map(Relationship::getType).collect(Collectors.toList());
    }

    public int getDegree() {
        return this.rels.size();
    }

    public int getDegree(RelationshipType relationshipType) {
        return (int)Iterables.count(this.getRelationships(relationshipType));
    }

    public int getDegree(Direction direction) {
        return (int)Iterables.count(this.getRelationships(direction));
    }

    public int getDegree(RelationshipType relationshipType, Direction direction) {
        return (int)Iterables.count(this.getRelationships(direction, relationshipType));
    }

    public void addLabel(Label label) {
        this.labels.add(label.name());
    }

    public void addLabels(Iterable<Label> labels) {
        for (Label label : labels) {
            this.addLabel(label);
        }
    }

    public void removeLabel(Label label) {
        this.labels.remove(label.name());
    }

    public boolean hasLabel(Label label) {
        return this.labels.contains(label.name());
    }

    public Iterable<Label> getLabels() {
        return this.labels.stream().map(Label::label).collect(Collectors.toList());
    }

    public boolean hasProperty(String s) {
        return this.props.containsKey(s);
    }

    public Object getProperty(String s) {
        return this.props.get(s);
    }

    public Object getProperty(String s, Object o) {
        Object value = this.props.get(s);
        return value == null ? o : value;
    }

    public void setProperty(String s, Object o) {
        this.props.put(s, o);
    }

    public Object removeProperty(String s) {
        return this.props.remove(s);
    }

    public Iterable<String> getPropertyKeys() {
        return this.props.keySet();
    }

    public Map<String, Object> getProperties(String ... strings) {
        HashMap<String, Object> res = new HashMap<String, Object>(this.props);
        res.keySet().retainAll(Arrays.asList(strings));
        return res;
    }

    public Map<String, Object> getAllProperties() {
        return this.props;
    }

    void delete(Relationship rel) {
        this.rels.remove(rel);
    }

    public boolean equals(Object o) {
        return this == o || o instanceof Node && this.id == ((Node)o).getId();
    }

    public int hashCode() {
        return (int)(this.id ^ this.id >>> 32);
    }

    public String toString() {
        return "VirtualNode{labels=" + this.labels + ", props=" + this.props + ", rels=" + this.rels + "}";
    }
}

