/*
 * Decompiled with CFR 0.152.
 */
package n10s.rdf.load;

import java.util.Map;
import java.util.stream.Stream;
import n10s.rdf.RDFProcedures;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class RDFLoadProcedures
extends RDFProcedures {
    @Procedure(name="n10s.rdf.import.fetch", mode=Mode.WRITE)
    @Description(value="Imports RDF from an url (file or http) and stores it in Neo4j as a property graph. Requires a unique constraint on :Resource(uri)")
    public Stream<RDFProcedures.ImportResults> fetch(@Name(value="url") String url, @Name(value="format") String format, @Name(value="params", defaultValue="{}") Map<String, Object> props) {
        return Stream.of(this.doImport(format, url, null, props, null));
    }

    @Procedure(name="n10s.rdf.import.inline", mode=Mode.WRITE)
    @Description(value="Imports an RDF snippet passed as parameter and stores it in Neo4j as a property graph. Requires a unique constraint on :Resource(uri)")
    public Stream<RDFProcedures.ImportResults> inline(@Name(value="rdf") String rdfFragment, @Name(value="format") String format, @Name(value="params", defaultValue="{}") Map<String, Object> props) {
        return Stream.of(this.doImport(format, null, rdfFragment, props, null));
    }
}

