/*
 * Decompiled with CFR 0.152.
 */
package n10s.rdf.load;

import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.stream.Stream;
import n10s.CommonProcedures;
import n10s.graphconfig.GraphConfig;
import n10s.graphconfig.Params;
import n10s.rdf.RDFProcedures;
import n10s.rdf.load.DirectNodeAdder;
import n10s.rdf.load.DirectRelationshipAdder;
import n10s.result.NodeResult;
import n10s.result.RelationshipResult;
import n10s.utils.InvalidNamespacePrefixDefinitionInDB;
import n10s.utils.NsPrefixMap;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.util.URIUtil;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.values.storable.PointValue;

public class AddProcedures
extends RDFProcedures {
    @Procedure(name="n10s.add.node", mode=Mode.WRITE)
    @Description(value="creates a node in the graph following the existing GraphConfig.")
    public Stream<NodeResult> nodeAdd(@Name(value="uri") String uri, @Name(value="types") List<String> types, @Name(value="properties") List<Map<String, Object>> props) throws GraphConfig.GraphConfigNotFound, CommonProcedures.RDFImportPreRequisitesNotMet, IOException, InvalidNamespacePrefixDefinitionInDB, CommonProcedures.InvalidShortenedName, CommonProcedures.InvalidURI {
        StringBuilder rdfSerialization = new StringBuilder();
        IRI subject = SimpleValueFactory.getInstance().createIRI(uri);
        for (String string : types) {
            rdfSerialization.append('<').append(subject.stringValue()).append('>').append(' ').append('<').append(RDF.TYPE.stringValue()).append('>').append(' ').append('<').append(this.processTypeAsString(string)).append('>').append(' ').append('.').append('\n');
        }
        for (Map map : props) {
            if (!map.containsKey("key") || !map.containsKey("val")) continue;
            rdfSerialization.append('<').append(subject.stringValue()).append('>').append(' ').append('<').append(this.processPropKey(map.get("key"))).append('>').append(' ').append(this.processValue(map.get("val"), map.get("dt"), map.get("lan"))).append(' ').append('.').append('\n');
        }
        DirectNodeAdder nodeAdder = (DirectNodeAdder)this.doAdd(rdfSerialization.toString(), new HashMap<String, Object>(), RDFFormat.NTRIPLES, false);
        return Stream.of(nodeAdder.returnNode());
    }

    @Procedure(name="n10s.add.relationship.nodes", mode=Mode.WRITE)
    @Description(value="creates a relationship in the graph following the existing GraphConfig.")
    public Stream<RelationshipResult> relAdd(@Name(value="from") Node fromNode, @Name(value="type") String relType, @Name(value="properties") List<Map<String, Object>> props, @Name(value="to") Node toNode) throws GraphConfig.GraphConfigNotFound, CommonProcedures.RDFImportPreRequisitesNotMet, IOException, InvalidNamespacePrefixDefinitionInDB, CommonProcedures.InvalidShortenedName, CommonProcedures.InvalidURI, NodeIsNotResource {
        StringBuilder rdfSerialization = new StringBuilder();
        if (fromNode.hasProperty("uri") && fromNode.hasLabel(Label.label((String)"Resource")) && toNode.hasProperty("uri") && toNode.hasLabel(Label.label((String)"Resource"))) {
            String processedRelType = this.processTypeAsString(relType);
            IRI fromUri = SimpleValueFactory.getInstance().createIRI((String)fromNode.getProperty("uri"));
            IRI toUri = SimpleValueFactory.getInstance().createIRI((String)toNode.getProperty("uri"));
            rdfSerialization.append('<').append(fromUri.stringValue()).append('>').append(' ').append('<').append(processedRelType).append('>').append(' ').append('<').append(toUri.stringValue()).append('>').append(' ').append('.').append('\n');
            for (Map<String, Object> x : props) {
                if (!x.containsKey("key") || !x.containsKey("val")) continue;
                rdfSerialization.append('<').append('<').append(' ').append('<').append(fromUri.stringValue()).append('>').append(' ').append('<').append(processedRelType).append('>').append(' ').append('<').append(toUri.stringValue()).append('>').append(' ').append('>').append('>').append(' ').append('<').append(this.processPropKey(x.get("key"))).append('>').append(' ').append(this.processValue(x.get("val"), x.get("dt"), x.get("lan"))).append(' ').append('.').append('\n');
            }
            DirectRelationshipAdder relAdder = (DirectRelationshipAdder)this.doAdd(rdfSerialization.toString(), new HashMap<String, Object>(), RDFFormat.TURTLESTAR, true);
            return Stream.of(relAdder.returnRel());
        }
        throw new NodeIsNotResource("n10s.add.relationship cannot link nodes that are not resources (label 'Resource' and property 'uri'). Offending pair node <ids>: " + fromNode.getId() + ", " + toNode.getId());
    }

    @Procedure(name="n10s.add.relationship.uris", mode=Mode.WRITE)
    @Description(value="creates a relationship in the graph following the existing GraphConfig.")
    public Stream<RelationshipResult> relAdd(@Name(value="from") String fromNode, @Name(value="type") String relType, @Name(value="properties") List<Map<String, Object>> props, @Name(value="to") String toNode) throws GraphConfig.GraphConfigNotFound, CommonProcedures.RDFImportPreRequisitesNotMet, IOException, InvalidNamespacePrefixDefinitionInDB, CommonProcedures.InvalidShortenedName, CommonProcedures.InvalidURI {
        StringBuilder rdfSerialization = new StringBuilder();
        String processedRelType = this.processTypeAsString(relType);
        IRI fromUri = SimpleValueFactory.getInstance().createIRI(fromNode);
        IRI toUri = SimpleValueFactory.getInstance().createIRI(toNode);
        rdfSerialization.append('<').append(fromUri.stringValue()).append('>').append(' ').append('<').append(processedRelType).append('>').append(' ').append('<').append(toUri.stringValue()).append('>').append(' ').append('.').append('\n');
        for (Map<String, Object> x : props) {
            if (!x.containsKey("key") || !x.containsKey("val")) continue;
            rdfSerialization.append('<').append('<').append(' ').append('<').append(fromUri.stringValue()).append('>').append(' ').append('<').append(processedRelType).append('>').append(' ').append('<').append(toUri.stringValue()).append('>').append(' ').append('>').append('>').append(' ').append('<').append(this.processPropKey(x.get("key"))).append('>').append(' ').append(this.processValue(x.get("val"), x.get("dt"), x.get("lan"))).append(' ').append('.').append('\n');
        }
        DirectRelationshipAdder relAdder = (DirectRelationshipAdder)this.doAdd(rdfSerialization.toString(), new HashMap<String, Object>(), RDFFormat.TURTLESTAR, true);
        return Stream.of(relAdder.returnRel());
    }

    private String processValue(Object val, Object dt, Object lan) {
        if ((dt != null || lan != null) && dt instanceof String && (lan instanceof String || val instanceof String)) {
            return "\"" + val.toString().replace("\"", "\\\"") + "\"" + (lan != null && lan instanceof String ? "@@" + lan.toString() : "^^<" + dt.toString() + ">");
        }
        Literal typedLiteral = this.createTypedLiteral(val);
        return "\"" + typedLiteral.stringValue() + "\"^^<" + typedLiteral.getDatatype().stringValue() + ">";
    }

    protected Literal createTypedLiteral(Object value) {
        SimpleValueFactory vf = SimpleValueFactory.getInstance();
        Literal result = value instanceof String ? vf.createLiteral(((String)value).replace("\"", "\\\"")) : (value instanceof Integer ? vf.createLiteral((Integer)value) : (value instanceof Long ? vf.createLiteral((Long)value) : (value instanceof Float ? vf.createLiteral(((Float)value).floatValue()) : (value instanceof Double ? vf.createLiteral((Double)value) : (value instanceof Boolean ? vf.createLiteral((Boolean)value) : (value instanceof LocalDateTime ? vf.createLiteral(((LocalDateTime)value).format(DateTimeFormatter.ISO_LOCAL_DATE_TIME), XMLSchema.DATETIME) : (value instanceof LocalDate ? vf.createLiteral(((LocalDate)value).format(DateTimeFormatter.ISO_LOCAL_DATE), XMLSchema.DATE) : (value instanceof PointValue ? vf.createLiteral(this.pointValueToWTK((PointValue)value), Params.WKTLITERAL_URI) : vf.createLiteral(((String)value).replace("\"", "\\\""))))))))));
        return result;
    }

    private String pointValueToWTK(PointValue pv) {
        return "Point(" + pv.coordinate()[0] + " " + pv.coordinate()[1] + (String)(pv.getCRS().getCode() == 9157 ? " " + pv.coordinate()[2] : "") + ")";
    }

    private String processPropKey(Object key) throws CommonProcedures.InvalidShortenedName, InvalidNamespacePrefixDefinitionInDB, CommonProcedures.InvalidURI, GraphConfig.GraphConfigNotFound {
        return this.shortenToURIOrLeaveAsIs(key.toString());
    }

    private String shortenToURIOrLeaveAsIs(String str) throws CommonProcedures.InvalidShortenedName, InvalidNamespacePrefixDefinitionInDB, CommonProcedures.InvalidURI, GraphConfig.GraphConfigNotFound {
        Matcher m = Params.SHORTENED_URI_PATTERN.matcher(str);
        GraphConfig gc = new GraphConfig(this.tx);
        if (!m.matches()) {
            if (URIUtil.isValidURIReference(str)) {
                return str;
            }
            if (gc.getHandleVocabUris() == 2) {
                return "neo4j://graph.schema#" + str;
            }
            throw new CommonProcedures.InvalidURI(str + " is not a valid URI");
        }
        if (gc.getHandleVocabUris() == 1 || gc.getHandleVocabUris() == 0) {
            NsPrefixMap prefixDefs = new NsPrefixMap(this.tx, false);
            if (!prefixDefs.hasPrefix(m.group(1))) {
                throw new CommonProcedures.InvalidShortenedName("Prefix Undefined: " + str + " is using an undefined prefix.");
            }
            return prefixDefs.getNsForPrefix(m.group(1)) + m.group(2);
        }
        if (gc.getHandleVocabUris() == 2) {
            return "neo4j://graph.schema#" + str;
        }
        return str;
    }

    private String processTypeAsString(String str) throws InvalidNamespacePrefixDefinitionInDB, CommonProcedures.InvalidShortenedName, CommonProcedures.InvalidURI, GraphConfig.GraphConfigNotFound {
        return this.shortenToURIOrLeaveAsIs(str);
    }

    private class NodeIsNotResource
    extends Throwable {
        public NodeIsNotResource(String s) {
            super(s);
        }
    }
}

