/*
 * Decompiled with CFR 0.152.
 */
package n10s.rdf;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.stream.Stream;
import n10s.CommonProcedures;
import n10s.ConfiguredStatementHandler;
import n10s.RDFImportException;
import n10s.graphconfig.GraphConfig;
import n10s.graphconfig.Params;
import n10s.graphconfig.RDFParserConfig;
import n10s.rdf.delete.DirectStatementDeleter;
import n10s.rdf.load.DirectNodeAdder;
import n10s.rdf.load.DirectRelationshipAdder;
import n10s.rdf.load.DirectStatementLoader;
import n10s.rdf.preview.StatementPreviewer;
import n10s.rdf.stream.StarFormatStatementStreamer;
import n10s.rdf.stream.StatementStreamer;
import n10s.result.GraphResult;
import n10s.result.StreamedStatement;
import n10s.utils.InvalidNamespacePrefixDefinitionInDB;
import n10s.utils.NsPrefixMap;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.util.URIUtil;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.helpers.BasicParserSettings;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.UserFunction;

public class RDFProcedures
extends CommonProcedures {
    protected ImportResults doImport(String format, String url, String rdfFragment, Map<String, Object> props, GraphConfig overrideGC) {
        DirectStatementLoader statementLoader = null;
        RDFParserConfig conf = null;
        RDFFormat rdfFormat = null;
        ImportResults importResults = new ImportResults();
        try {
            this.checkConstraintExist();
            conf = new RDFParserConfig(props, overrideGC != null ? overrideGC : new GraphConfig(this.tx));
            rdfFormat = this.getFormat(format);
            statementLoader = new DirectStatementLoader(this.db, this.tx, conf, this.log);
        }
        catch (CommonProcedures.RDFImportPreRequisitesNotMet e) {
            importResults.setTerminationKO(e.getMessage());
        }
        catch (GraphConfig.GraphConfigNotFound e) {
            importResults.setTerminationKO("A Graph Config is required for RDF importing procedures to run");
        }
        catch (CommonProcedures.RDFImportBadParams e) {
            importResults.setTerminationKO(e.getMessage());
        }
        if (statementLoader != null) {
            try {
                this.parseRDFPayloadOrFromUrl(rdfFormat, url, rdfFragment, props, statementLoader);
                importResults.setTriplesLoaded(statementLoader.totalTriplesMapped);
                importResults.setTriplesParsed(statementLoader.totalTriplesParsed);
                importResults.setNamespaces(statementLoader.getNamespaces());
                importResults.setConfigSummary(props);
                importResults.setExtraInfo(statementLoader.getWarnings());
            }
            catch (IOException | RDFHandlerException | RDFParseException | QueryExecutionException e) {
                importResults.setTerminationKO(e.getMessage());
                importResults.setTriplesLoaded(statementLoader.totalTriplesMapped);
                importResults.setTriplesParsed(statementLoader.totalTriplesParsed);
                importResults.setConfigSummary(props);
            }
        }
        return importResults;
    }

    protected GraphResult doPreview(@Name(value="url") String url, @Name(value="rdf") String rdfFragment, @Name(value="format") String format, @Name(value="params", defaultValue="{}") Map<String, Object> props) throws RDFImportException {
        RDFParserConfig conf = null;
        RDFFormat rdfFormat = null;
        StatementPreviewer statementViewer = null;
        HashMap<String, Node> virtualNodes = new HashMap<String, Node>();
        ArrayList<Relationship> virtualRels = new ArrayList<Relationship>();
        try {
            conf = new RDFParserConfig(props, new GraphConfig(this.tx));
            rdfFormat = this.getFormat(format);
            statementViewer = new StatementPreviewer(this.db, this.tx, conf, virtualNodes, virtualRels, this.log);
        }
        catch (CommonProcedures.RDFImportBadParams e) {
            throw new RDFImportException(e.getMessage());
        }
        catch (GraphConfig.GraphConfigNotFound e) {
            throw new RDFImportException("A Graph Config is required for the RDF preview method to run");
        }
        if (statementViewer != null) {
            try {
                this.parseRDFPayloadOrFromUrl(rdfFormat, url, rdfFragment, props, statementViewer);
            }
            catch (ConfiguredStatementHandler.TripleLimitReached e) {
            }
            catch (IOException | RDFHandlerException | RDFParseException | QueryExecutionException e) {
                throw new RDFImportException(e.getMessage());
            }
        }
        return new GraphResult(new ArrayList<Node>(virtualNodes.values()), virtualRels);
    }

    protected Stream<StreamedStatement> doStream(@Name(value="url") String url, @Name(value="rdfFragment") String rdfFragment, @Name(value="format") String format, @Name(value="params", defaultValue="{}") Map<String, Object> props) throws RDFImportException {
        StatementStreamer statementStreamer = null;
        RDFFormat rdfFormat = null;
        RDFParserConfig conf = null;
        try {
            rdfFormat = this.getFormat(format);
            conf = new RDFParserConfig(props, new GraphConfig(new HashMap<String, Object>()));
            statementStreamer = rdfFormat.equals(RDFFormat.TURTLESTAR) || rdfFormat.equals(RDFFormat.TRIGSTAR) ? new StarFormatStatementStreamer(conf) : new StatementStreamer(conf);
        }
        catch (CommonProcedures.RDFImportBadParams e) {
            throw new RDFImportException(e.getMessage());
        }
        catch (GraphConfig.InvalidParamException e) {
            // empty catch block
        }
        try {
            this.parseRDFPayloadOrFromUrl(rdfFormat, url, rdfFragment, props, statementStreamer);
        }
        catch (ConfiguredStatementHandler.TripleLimitReached e) {
        }
        catch (IOException | RDFParseException | QueryExecutionException e) {
            throw new RDFImportException(e.getMessage());
        }
        return statementStreamer.getStatements().stream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DeleteResults doDelete(String format, String url, String rdfFragment, Map<String, Object> props) {
        DirectStatementDeleter statementDeleter = null;
        RDFParserConfig conf = null;
        RDFFormat rdfFormat = null;
        DeleteResults deleteResults = new DeleteResults();
        try {
            this.checkConstraintExist();
            conf = new RDFParserConfig(props, new GraphConfig(this.tx));
            rdfFormat = this.getFormat(format);
            statementDeleter = new DirectStatementDeleter(this.db, this.tx, conf, this.log);
        }
        catch (CommonProcedures.RDFImportPreRequisitesNotMet e) {
            deleteResults.setTerminationKO(e.getMessage());
        }
        catch (GraphConfig.GraphConfigNotFound e) {
            deleteResults.setTerminationKO("A Graph Config is required for RDF importing procedures to run");
        }
        catch (CommonProcedures.RDFImportBadParams e) {
            deleteResults.setTerminationKO(e.getMessage());
        }
        if (statementDeleter != null) {
            try {
                this.parseRDFPayloadOrFromUrl(rdfFormat, url, rdfFragment, props, statementDeleter);
            }
            catch (IOException | RDFHandlerException | RDFParseException | QueryExecutionException e) {
                deleteResults.setTerminationKO(e.getMessage());
                e.printStackTrace();
            }
            finally {
                deleteResults.setTriplesDeleted(statementDeleter.totalTriplesMapped - statementDeleter.getNotDeletedStatementCount());
                deleteResults.setExtraInfo(statementDeleter.getbNodeInfo());
                deleteResults.setNamespaces(statementDeleter.getNamespaces());
            }
        }
        return deleteResults;
    }

    protected DirectStatementLoader doAdd(String rdfFragment, Map<String, Object> props, RDFFormat format, boolean isRel) throws CommonProcedures.RDFImportPreRequisitesNotMet, IOException, GraphConfig.GraphConfigNotFound {
        DirectStatementLoader statementAdder = null;
        RDFParserConfig conf = null;
        ImportResults importResults = new ImportResults();
        this.checkConstraintExist();
        conf = new RDFParserConfig(props, new GraphConfig(this.tx));
        statementAdder = isRel ? new DirectRelationshipAdder(this.db, this.tx, conf, this.log) : new DirectNodeAdder(this.db, this.tx, conf, this.log);
        RDFParser rdfParser = Rio.createParser(format);
        rdfParser.set(BasicParserSettings.VERIFY_URI_SYNTAX, statementAdder.getParserConfig().isVerifyUriSyntax());
        rdfParser.setRDFHandler(statementAdder);
        rdfParser.parse(new ByteArrayInputStream(rdfFragment.getBytes(Charset.defaultCharset())), "http://neo4j.com/base/");
        return statementAdder;
    }

    @UserFunction
    @Description(value="Returns the XMLSchema or custom datatype of a property when present")
    public String getDataType(@Name(value="literal") Object literal) {
        String result;
        if (literal instanceof String) {
            Matcher matcherShortened = Params.DATATYPE_SHORTENED_PATTERN.matcher((String)literal);
            Matcher matcherRegular = Params.DATATYPE_REGULAR_PATTERN.matcher((String)literal);
            result = matcherShortened.matches() ? matcherShortened.group(2) : (matcherRegular.matches() ? matcherRegular.group(2) : XMLSchema.STRING.stringValue());
        } else {
            result = literal instanceof Long ? XMLSchema.LONG.stringValue() : (literal instanceof Double ? XMLSchema.DOUBLE.stringValue() : (literal instanceof Boolean ? XMLSchema.BOOLEAN.stringValue() : (literal instanceof LocalDateTime ? XMLSchema.DATETIME.stringValue() : (literal instanceof LocalDate ? XMLSchema.DATE.stringValue() : null))));
        }
        return result;
    }

    @UserFunction
    @Description(value="Returns the value of a datatype of a property after stripping out the datatype information when present")
    public String getValue(@Name(value="literal") String literal) {
        Matcher matcherShortened = Params.DATATYPE_SHORTENED_PATTERN.matcher(literal);
        Matcher matcherRegular = Params.DATATYPE_REGULAR_PATTERN.matcher(literal);
        Matcher matcherLanguageTagged = Params.LANGUAGE_TAGGED_VALUE_PATTERN.matcher(literal);
        String result = literal;
        if (matcherShortened.matches()) {
            result = matcherShortened.group(1);
        } else if (matcherRegular.matches()) {
            result = matcherRegular.group(1);
        } else if (matcherLanguageTagged.matches()) {
            result = matcherLanguageTagged.group(1);
        }
        return result;
    }

    @UserFunction
    @Description(value="Returns the local part of an IRI")
    public String getIRILocalName(@Name(value="url") String url) {
        return url.substring(URIUtil.getLocalNameIndex(url));
    }

    @UserFunction
    @Description(value="Returns the namespace part of an IRI")
    public String getIRINamespace(@Name(value="url") String url) {
        return url.substring(0, URIUtil.getLocalNameIndex(url));
    }

    @UserFunction
    @Description(value="Returns the true if string is a valid IRI")
    public Boolean isIRI(@Name(value="str") String str) {
        return URIUtil.isValidURIReference(str);
    }

    @UserFunction
    @Description(value="Returns the first value with the language tag passed as first argument or null if there's not a value for the provided tag")
    public String getLangValue(@Name(value="lang") String lang, @Name(value="values") Object values) {
        Matcher m;
        if (values instanceof List) {
            if (((List)values).get(0) instanceof String) {
                for (Object val : (List)values) {
                    Matcher m2 = Params.LANGUAGE_TAGGED_VALUE_PATTERN.matcher((String)val);
                    if (!m2.matches() || !m2.group(2).equals(lang)) continue;
                    return m2.group(1);
                }
            }
        } else if (values instanceof String[]) {
            String[] valuesAsArray = (String[])values;
            for (int i = 0; i < valuesAsArray.length; ++i) {
                Matcher m3 = Params.LANGUAGE_TAGGED_VALUE_PATTERN.matcher(valuesAsArray[i]);
                if (!m3.matches() || !m3.group(2).equals(lang)) continue;
                return m3.group(1);
            }
        } else if (values instanceof String && (m = Params.LANGUAGE_TAGGED_VALUE_PATTERN.matcher((String)values)).matches() && m.group(2).equals(lang)) {
            return m.group(1);
        }
        return null;
    }

    @UserFunction
    @Description(value="Returns the language tag of a value. Returns null if the value is not a string orif the string has no language tag")
    public String getLangTag(@Name(value="value") Object value) {
        Matcher m;
        if (value instanceof String && (m = Params.LANGUAGE_TAGGED_VALUE_PATTERN.matcher((String)value)).matches()) {
            return m.group(2);
        }
        return null;
    }

    @UserFunction
    @Description(value="Returns false if the value is not a string or if the string is not tagged with the  given language tag")
    public Boolean hasLangTag(@Name(value="lang") String lang, @Name(value="value") Object value) {
        if (value instanceof String) {
            Matcher m = Params.LANGUAGE_TAGGED_VALUE_PATTERN.matcher((String)value);
            return m.matches() && m.group(2).equals(lang);
        }
        return false;
    }

    @UserFunction
    @Description(value="Returns the expanded (full) IRI given a shortened one created in the load process with semantics.importRDF")
    public String fullUriFromShortForm(@Name(value="short") String str) throws InvalidNamespacePrefixDefinitionInDB, CommonProcedures.InvalidShortenedName {
        Matcher m = Params.SHORTENED_URI_PATTERN.matcher(str);
        if (!m.matches()) {
            throw new CommonProcedures.InvalidShortenedName("Wrong Syntax: " + str + " is not a valid n10s shortened schema name.");
        }
        NsPrefixMap prefixDefs = new NsPrefixMap(this.tx, false);
        if (!prefixDefs.hasPrefix(m.group(1))) {
            throw new CommonProcedures.InvalidShortenedName("Prefix Undefined: " + str + " is using an undefined prefix.");
        }
        return prefixDefs.getNsForPrefix(m.group(1)) + m.group(2);
    }

    @UserFunction
    @Description(value="Returns the shortened version of an IRI using the existing namespace definitions")
    public String shortFormFromFullUri(@Name(value="uri") String str) throws InvalidNamespacePrefixDefinitionInDB, CommonProcedures.InvalidShortenedName {
        NsPrefixMap prefixDefs = new NsPrefixMap(this.tx, false);
        IRI iri = SimpleValueFactory.getInstance().createIRI(str);
        if (!prefixDefs.hasNs(iri.getNamespace())) {
            throw new CommonProcedures.InvalidShortenedName("Prefix Undefined: No prefix defined for this namespace <" + str + "> .");
        }
        return prefixDefs.getPrefixForNs(iri.getNamespace()) + "__" + iri.getLocalName();
    }

    public static class DeleteResults {
        public String terminationStatus = "OK";
        public long triplesDeleted = 0L;
        public Map<String, String> namespaces;
        public String extraInfo = "";

        public void setTriplesDeleted(long triplesDeleted) {
            this.triplesDeleted = triplesDeleted;
        }

        public void setExtraInfo(String extraInfo) {
            this.extraInfo = extraInfo;
        }

        public void setNamespaces(Map<String, String> namespaces) {
            this.namespaces = namespaces;
        }

        public void setTerminationKO(String message) {
            this.terminationStatus = "KO";
            this.extraInfo = message;
        }
    }

    public static class ImportResults {
        public String terminationStatus = "OK";
        public long triplesLoaded = 0L;
        public long triplesParsed = 0L;
        public Map<String, String> namespaces;
        public String extraInfo = "";
        public Map<String, Object> callParams;

        public void setTriplesLoaded(long count) {
            this.triplesLoaded = count;
        }

        public void setTriplesParsed(long count) {
            this.triplesParsed = count;
        }

        public void setConfigSummary(Map<String, Object> summary) {
            this.callParams = summary;
        }

        public void setNamespaces(Map<String, String> namespaces) {
            this.namespaces = namespaces;
        }

        public void setTerminationKO(String message) {
            this.terminationStatus = "KO";
            this.extraInfo = message;
        }

        public void setExtraInfo(String message) {
            this.extraInfo = message;
        }
    }
}

