/*
 * Decompiled with CFR 0.152.
 */
package n10s.nsprefixes;

import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import n10s.result.NamespacePrefixesResult;
import n10s.utils.InvalidNamespacePrefixDefinitionInDB;
import n10s.utils.NamespacePrefixConflictException;
import n10s.utils.NsPrefixMap;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class NsPrefixDefProcedures {
    @Context
    public GraphDatabaseService db;
    @Context
    public Transaction tx;
    @Context
    public Log log;

    @Procedure(mode=Mode.WRITE)
    @Description(value="Adds namespace - prefix pair definition")
    public Stream<NamespacePrefixesResult> add(@Name(value="prefix") String prefix, @Name(value="ns") String ns) throws InvalidNamespacePrefixDefinitionInDB, NamespacePrefixConflictException {
        NsPrefixMap map = new NsPrefixMap(this.tx, true);
        map.add(prefix, ns);
        map.flushToDB(this.tx);
        return map.getPrefixToNs().entrySet().stream().map(n -> new NamespacePrefixesResult((String)n.getKey(), (String)n.getValue()));
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="removes namespace prefix (by prefix)")
    public Stream<NamespacePrefixesResult> remove(@Name(value="prefix") String prefix) throws InvalidNamespacePrefixDefinitionInDB, NsPrefixOperationNotAllowed {
        if (!this.graphIsEmpty()) {
            throw new NsPrefixOperationNotAllowed("A namespace prefix definition cannot be removed when the graph is non-empty.");
        }
        if (this.mappingsDefinedOnNamespace(prefix)) {
            throw new NsPrefixOperationNotAllowed("This namespace prefix definition cannot be removed because mapping definitions based on it exist. Remove mappings first and try again.");
        }
        NsPrefixMap map = new NsPrefixMap(this.tx, true);
        map.removePrefix(prefix);
        map.flushToDB(this.tx);
        return map.getPrefixToNs().entrySet().stream().map(n -> new NamespacePrefixesResult((String)n.getKey(), (String)n.getValue()));
    }

    private boolean mappingsDefinedOnNamespace(String prefix) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("prefix", prefix);
        return (Long)this.tx.execute("MATCH (n:`_MapNs` { _prefix: $prefix }) RETURN count(n) as ct", params).next().get("ct") > 0L;
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="removes all namespace prefixes")
    public Stream<NamespacePrefixesResult> removeAll() throws InvalidNamespacePrefixDefinitionInDB, NsPrefixOperationNotAllowed {
        if (!this.graphIsEmpty()) {
            throw new NsPrefixOperationNotAllowed("Namespace prefix definitions cannot be removed when the graph is non-empty.");
        }
        ResourceIterator namespacePrefixDefinitionNodes = this.tx.findNodes(Label.label((String)"_NsPrefDef"));
        if (namespacePrefixDefinitionNodes.hasNext()) {
            ((Node)namespacePrefixDefinitionNodes.next()).delete();
        }
        return Stream.empty();
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="Adds namespaces from a prefix declaration header fragment")
    public Stream<NamespacePrefixesResult> addFromText(@Name(value="prefix") String textFragment) throws InvalidNamespacePrefixDefinitionInDB, NamespacePrefixConflictException {
        Pattern turtleNamespaceDefinitionRegex = Pattern.compile("(?i)@prefix (\\S+)\\:\\s+<(\\S*)>", 8);
        if (this.tryExtractNsDefinitions(textFragment, turtleNamespaceDefinitionRegex)) {
            return this.list();
        }
        Pattern rdfxmlNamespaceDefinitionRegex = Pattern.compile("xmlns:(\\S+)\\s*=\\s*\\\"(\\S*)\\\"", 8);
        if (this.tryExtractNsDefinitions(textFragment, rdfxmlNamespaceDefinitionRegex)) {
            return this.list();
        }
        Pattern sparqlNamespaceDefinitionRegex = Pattern.compile("(?i)prefix\\s+(\\S+)\\:\\s+<(\\S*)>", 8);
        if (this.tryExtractNsDefinitions(textFragment, sparqlNamespaceDefinitionRegex)) {
            return this.list();
        }
        return this.list();
    }

    private boolean tryExtractNsDefinitions(@Name(value="prefix") String textFragment, Pattern pattern) throws InvalidNamespacePrefixDefinitionInDB, NamespacePrefixConflictException {
        Matcher m = pattern.matcher(textFragment);
        while (m.find()) {
            this.add(m.group(1).replace("-", "_"), m.group(2));
        }
        return m.matches();
    }

    @Procedure(mode=Mode.READ)
    @Description(value="Lists all existing namespace prefix definitions")
    public Stream<NamespacePrefixesResult> list() {
        return this.tx.execute("MATCH (n:_NsPrefDef) \nUNWIND keys(n) AS prefix\nRETURN prefix, n[prefix] AS namespace").stream().map(n -> new NamespacePrefixesResult((String)n.get("prefix"), (String)n.get("namespace")));
    }

    private boolean graphIsEmpty() {
        return !this.tx.execute("match (r:Resource) return id(r) limit 1").hasNext();
    }

    private class NsPrefixOperationNotAllowed
    extends Exception {
        public NsPrefixOperationNotAllowed(String message) {
            super(message);
        }
    }
}

