/*
 * Decompiled with CFR 0.152.
 */
package n10s.graphconfig;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import n10s.graphconfig.GraphConfig;

public class RDFParserConfig {
    private static final long DEFAULT_COMMIT_SIZE = 25000L;
    private static final long DEFAULT_NODE_CACHE_SIZE = 10000L;
    private static final int DEFAULT_STREAM_TRIPLE_LIMIT = 1000;
    private final Set<String> predicateExclusionList;
    private final boolean verifyUriSyntax;
    private final long nodeCacheSize;
    private final String languageFilter;
    private long commitSize;
    private long streamTripleLimit;
    private boolean abortOnError;
    private GraphConfig graphConf;
    private boolean strictDataTypeCheck;

    public RDFParserConfig(Map<String, Object> props, GraphConfig gc) {
        this.graphConf = gc;
        Set<Object> set = this.predicateExclusionList = props.containsKey("predicateExclusionList") ? ((List)props.get("predicateExclusionList")).stream().collect(Collectors.toSet()) : null;
        this.commitSize = props.containsKey("commitSize") ? ((Long)props.get("commitSize") > 0L ? (Long)props.get("commitSize") : 25000L) : 25000L;
        this.nodeCacheSize = props.containsKey("nodeCacheSize") ? (Long)props.get("nodeCacheSize") : 10000L;
        this.languageFilter = props.containsKey("languageFilter") ? (String)props.get("languageFilter") : null;
        this.verifyUriSyntax = props.containsKey("verifyUriSyntax") ? (Boolean)props.get("verifyUriSyntax") : true;
        this.streamTripleLimit = props.containsKey("limit") ? (Long)props.get("limit") : 1000L;
        this.abortOnError = props.containsKey("abortOnError") ? (Boolean)props.get("abortOnError") : true;
        this.strictDataTypeCheck = props.containsKey("strictDataTypeCheck") ? (Boolean)props.get("strictDataTypeCheck") : true;
    }

    public Set<String> getPredicateExclusionList() {
        return this.predicateExclusionList;
    }

    public boolean isVerifyUriSyntax() {
        return this.verifyUriSyntax;
    }

    public long getCommitSize() {
        return this.commitSize;
    }

    public void setCommitSize(long commitSize) {
        this.commitSize = commitSize;
    }

    public long getNodeCacheSize() {
        return this.nodeCacheSize;
    }

    public String getLanguageFilter() {
        return this.languageFilter;
    }

    public GraphConfig getGraphConf() {
        return this.graphConf;
    }

    public long getStreamTripleLimit() {
        return this.streamTripleLimit;
    }

    public boolean isAbortOnError() {
        return this.abortOnError;
    }

    public boolean isStrictDataTypeCheck() {
        return this.strictDataTypeCheck;
    }

    public Map<String, Object> getConfigSummary() {
        HashMap<String, Object> summary = new HashMap<String, Object>();
        if (this.predicateExclusionList != null) {
            summary.put("predicateExclusionList", this.predicateExclusionList);
        }
        if (this.commitSize != 25000L) {
            summary.put("commitSize", this.commitSize);
        }
        if (this.nodeCacheSize != 10000L) {
            summary.put("nodeCacheSize", this.nodeCacheSize);
        }
        if (this.languageFilter != null) {
            summary.put("languageFilter", this.languageFilter);
        }
        if (!this.verifyUriSyntax) {
            summary.put("verifyUriSyntax", this.verifyUriSyntax);
        }
        if (!this.abortOnError) {
            summary.put("abortOnError", this.abortOnError);
        }
        if (this.streamTripleLimit != 1000L) {
            summary.put("limit", this.streamTripleLimit);
        }
        return summary;
    }
}

