/*
 * Decompiled with CFR 0.152.
 */
package n10s;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import n10s.ConfiguredStatementHandler;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.io.IOUtils;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.helpers.BasicParserSettings;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.ConstraintType;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Name;

public class CommonProcedures {
    public static final String UNIQUENESS_CONSTRAINT_ON_URI = "n10s_unique_uri";
    protected static RDFFormat[] availableParsers = new RDFFormat[]{RDFFormat.RDFXML, RDFFormat.JSONLD, RDFFormat.TURTLE, RDFFormat.NTRIPLES, RDFFormat.TRIG, RDFFormat.NQUADS, RDFFormat.TURTLESTAR, RDFFormat.TRIGSTAR};
    @Context
    public GraphDatabaseService db;
    @Context
    public Transaction tx;
    @Context
    public Log log;

    protected void checkConstraintExist() throws RDFImportPreRequisitesNotMet {
        boolean constraintExists = this.isConstraintOnResourceUriPresent();
        if (!constraintExists) {
            throw new RDFImportPreRequisitesNotMet("The following constraint is required for importing RDF. Please run 'CREATE CONSTRAINT n10s_unique_uri ON (r:Resource) ASSERT r.uri IS UNIQUE' and try again.");
        }
    }

    protected boolean isConstraintOnResourceUriPresent() {
        for (ConstraintDefinition constraintDef : this.tx.schema().getConstraints()) {
            if (!constraintDef.isConstraintType(ConstraintType.UNIQUENESS) || !constraintDef.getLabel().equals(Label.label((String)"Resource")) || !this.sizeOneAndNameUri(constraintDef.getPropertyKeys().iterator())) continue;
            return true;
        }
        return false;
    }

    protected boolean sizeOneAndNameUri(Iterator<String> iterator) {
        return iterator.hasNext() && iterator.next().equals("uri") && !iterator.hasNext();
    }

    protected void checkIndexExist() throws RDFImportPreRequisitesNotMet {
        if (this.isConstraintOnResourceUriPresent() || this.missingIndexOnResourceUri()) {
            throw new RDFImportPreRequisitesNotMet("An index on :Resource(uri) is required for importing RDF Quads. Please run 'CREATE INDEX ON :Resource(uri)' and try again. Note that uniqueness constraint needs to be dropped if existing");
        }
    }

    protected boolean missingIndexOnResourceUri() {
        for (IndexDefinition indexDef : this.tx.schema().getIndexes()) {
            if (indexDef.isCompositeIndex() || !indexDef.isNodeIndex() || !indexDef.getLabels().iterator().hasNext() || !((Label)indexDef.getLabels().iterator().next()).name().equals("Resource") || !indexDef.getPropertyKeys().iterator().hasNext() || !((String)indexDef.getPropertyKeys().iterator().next()).equals("uri")) continue;
            return false;
        }
        return true;
    }

    protected void parseRDFPayloadOrFromUrl(RDFFormat format, String url, String rdfFragment, Map<String, Object> props, ConfiguredStatementHandler statementLoader) throws IOException {
        if (rdfFragment != null) {
            this.instantiateAndKickOffParser(new ByteArrayInputStream(rdfFragment.getBytes(Charset.defaultCharset())), "http://neo4j.com/base/", format, statementLoader);
        } else {
            this.instantiateAndKickOffParser(this.getInputStream(url, props), url, format, statementLoader);
        }
    }

    protected void instantiateAndKickOffParser(InputStream inputStream, @Name(value="url") String url, @Name(value="format") RDFFormat format, ConfiguredStatementHandler handler) throws IOException {
        RDFParser rdfParser = Rio.createParser(format);
        rdfParser.set(BasicParserSettings.VERIFY_URI_SYNTAX, handler.getParserConfig().isVerifyUriSyntax());
        rdfParser.setRDFHandler(handler);
        rdfParser.parse(inputStream, url);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected InputStream getInputStream(String url, Map<String, Object> props) throws IOException {
        String newUrl;
        URLConnection urlConn;
        if (url.contains(".zip") || url.contains(".tgz") || url.contains(".gz") || url.contains(".bz2")) {
            ZipEntry zipEntry;
            String zipFileName = null;
            if (url.contains("!")) {
                String[] tokens = url.split("!");
                url = tokens[0];
                zipFileName = tokens[1];
                if (zipFileName.equals("")) {
                    throw new IllegalArgumentException("filename can't be empty");
                }
                if (!(url.endsWith(".tar.gz") || url.endsWith(".tgz") || url.endsWith(".zip"))) {
                    throw new IllegalArgumentException("'!' notation for filenames can only be used with zip or tgz files");
                }
            }
            urlConn = new URL(url).openConnection();
            if (url.endsWith(".zip")) {
                ZipInputStream zip = new ZipInputStream(urlConn.getInputStream());
                if (zipFileName == null) throw new IllegalArgumentException("Filename is required for zip files (use '!' notation)");
                while ((zipEntry = zip.getNextEntry()) != null) {
                    if (zipEntry.isDirectory() || !zipEntry.getName().equals(zipFileName)) continue;
                    return new ByteArrayInputStream(IOUtils.toByteArray(zip));
                }
            } else if (url.endsWith(".tar.gz") || url.endsWith(".tgz")) {
                TarArchiveInputStream tgz = new TarArchiveInputStream((InputStream)new GZIPInputStream(urlConn.getInputStream()));
                if (zipFileName == null) return tgz;
                while ((zipEntry = tgz.getNextEntry()) != null) {
                    if (zipEntry.isDirectory() || !zipEntry.getName().equals(zipFileName)) continue;
                    return new ByteArrayInputStream(IOUtils.toByteArray((InputStream)tgz));
                }
            } else {
                if (url.endsWith(".gz")) {
                    return new GZIPInputStream(urlConn.getInputStream());
                }
                if (url.endsWith(".bz2")) {
                    return new BZip2CompressorInputStream(urlConn.getInputStream());
                }
            }
        } else {
            urlConn = new URL(url).openConnection();
        }
        if (props.containsKey("headerParams")) {
            Map headerParams = (Map)props.get("headerParams");
            Object method = headerParams.get("method");
            if (method != null && urlConn instanceof HttpURLConnection) {
                HttpURLConnection http = (HttpURLConnection)urlConn;
                http.setRequestMethod(method.toString());
            }
            headerParams.forEach((k, v) -> urlConn.setRequestProperty((String)k, (String)v));
        }
        if (props.containsKey("payload")) {
            urlConn.setDoOutput(true);
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(urlConn.getOutputStream(), "UTF-8"));
            writer.write(props.get("payload").toString());
            writer.close();
        }
        if ((newUrl = CommonProcedures.handleRedirect(urlConn, url)) == null || url.equals(newUrl)) return urlConn.getInputStream();
        urlConn.getInputStream().close();
        return this.getInputStream(newUrl, props);
    }

    private static String handleRedirect(URLConnection con, String url) throws IOException {
        if (!(con instanceof HttpURLConnection)) {
            return url;
        }
        if (!CommonProcedures.isRedirect((HttpURLConnection)con)) {
            return url;
        }
        return con.getHeaderField("Location");
    }

    public static boolean isRedirect(HttpURLConnection con) throws IOException {
        boolean isRedirectCode;
        int code = con.getResponseCode();
        boolean bl = isRedirectCode = code >= 300 && code < 400;
        if (isRedirectCode) {
            URL location = new URL(con.getHeaderField("Location"));
            String oldProtocol = con.getURL().getProtocol();
            String protocol = location.getProtocol();
            if (!protocol.equals(oldProtocol) && !protocol.startsWith(oldProtocol)) {
                throw new RuntimeException("The redirect URI has a different protocol: " + location.toString());
            }
        }
        return isRedirectCode;
    }

    protected RDFFormat getFormat(String format) throws RDFImportBadParams {
        if (format != null) {
            for (RDFFormat parser : availableParsers) {
                if (!parser.getName().equals(format)) continue;
                return parser;
            }
        }
        throw new RDFImportBadParams("Unrecognized serialization format: " + format);
    }

    public class InvalidShortenedName
    extends Exception {
        public InvalidShortenedName(String s) {
            super(s);
        }
    }

    public class InvalidURI
    extends Exception {
        public InvalidURI(String message) {
            super(message);
        }
    }

    public class RDFImportBadParams
    extends Exception {
        public RDFImportBadParams(String message) {
            super(message);
        }
    }

    public class RDFImportPreRequisitesNotMet
    extends Exception {
        public RDFImportPreRequisitesNotMet(String message) {
            super(message);
        }
    }
}

