/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.util.Objects;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.storageengine.api.StoreId;

public class LogHeader {
    static final int LOG_HEADER_VERSION_SIZE = 8;
    private final byte logFormatVersion;
    private final long logVersion;
    private final long lastCommittedTxId;
    private final StoreId storeId;
    private final LogPosition startPosition;
    private final int segmentBlockSize;
    private final int previousLogFileChecksum;

    public LogHeader(byte logFormatVersion, LogPosition startPosition, long lastCommittedTxId, StoreId storeId, int segmentBlockSize, int previousLogFileChecksum) {
        this.logFormatVersion = logFormatVersion;
        this.startPosition = Objects.requireNonNull(startPosition);
        this.logVersion = startPosition.getLogVersion();
        this.lastCommittedTxId = lastCommittedTxId;
        this.storeId = storeId;
        this.segmentBlockSize = segmentBlockSize;
        this.previousLogFileChecksum = previousLogFileChecksum;
    }

    public LogHeader(LogHeader logHeader, long version) {
        this(logHeader.getLogFormatVersion(), new LogPosition(version, logHeader.getStartPosition().getByteOffset()), logHeader.getLastCommittedTxId(), logHeader.getStoreId(), logHeader.getSegmentBlockSize(), logHeader.getPreviousLogFileChecksum());
    }

    public LogPosition getStartPosition() {
        return this.startPosition;
    }

    public byte getLogFormatVersion() {
        return this.logFormatVersion;
    }

    public long getLogVersion() {
        return this.logVersion;
    }

    public long getLastCommittedTxId() {
        return this.lastCommittedTxId;
    }

    public StoreId getStoreId() {
        return this.storeId;
    }

    public int getSegmentBlockSize() {
        return this.segmentBlockSize;
    }

    public int getPreviousLogFileChecksum() {
        return this.previousLogFileChecksum;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogHeader logHeader = (LogHeader)o;
        return this.logFormatVersion == logHeader.logFormatVersion && this.logVersion == logHeader.logVersion && this.lastCommittedTxId == logHeader.lastCommittedTxId && Objects.equals(this.storeId, logHeader.storeId) && Objects.equals(this.startPosition, logHeader.startPosition) && this.segmentBlockSize == logHeader.segmentBlockSize && this.previousLogFileChecksum == logHeader.previousLogFileChecksum;
    }

    public int hashCode() {
        return Objects.hash(this.logFormatVersion, this.logVersion, this.lastCommittedTxId, this.storeId, this.startPosition, this.segmentBlockSize, this.previousLogFileChecksum);
    }

    public String toString() {
        return "LogHeader{logFormatVersion=" + this.logFormatVersion + ", logVersion=" + this.logVersion + ", lastCommittedTxId=" + this.lastCommittedTxId + ", storeId=" + this.storeId + ", startPosition=" + this.startPosition + ", segmentBlockSize=" + this.segmentBlockSize + ", previousLogFileChecksum=" + this.previousLogFileChecksum + "}";
    }
}

