/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.io.IOException;
import org.neo4j.io.fs.ChecksumMismatchException;
import org.neo4j.io.fs.ReadableChecksumChannel;

public class ByteReversingReadableChecksumChannel
implements ReadableChecksumChannel {
    private final ReadableChecksumChannel delegate;

    public ByteReversingReadableChecksumChannel(ReadableChecksumChannel delegate) {
        this.delegate = delegate;
    }

    public byte get() throws IOException {
        return this.delegate.get();
    }

    public short getShort() throws IOException {
        return Short.reverseBytes(this.delegate.getShort());
    }

    public int getInt() throws IOException {
        return Integer.reverseBytes(this.delegate.getInt());
    }

    public long getLong() throws IOException {
        return Long.reverseBytes(this.delegate.getLong());
    }

    public float getFloat() throws IOException {
        return this.delegate.getFloat();
    }

    public double getDouble() throws IOException {
        return this.delegate.getDouble();
    }

    public void get(byte[] bytes, int length) throws IOException {
        this.delegate.get(bytes, length);
    }

    public void beginChecksum() {
        this.delegate.beginChecksum();
    }

    public int getChecksum() {
        return this.delegate.getChecksum();
    }

    public int endChecksumAndValidate() throws IOException {
        int checksum;
        int calculatedChecksum = this.getChecksum();
        if (calculatedChecksum != (checksum = this.getInt())) {
            throw new ChecksumMismatchException((long)checksum, (long)calculatedChecksum);
        }
        this.beginChecksum();
        return calculatedChecksum;
    }

    public void close() throws IOException {
        this.delegate.close();
    }
}

