/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files;

import java.nio.file.DirectoryStream;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.log.files.LogVersionVisitor;

public class TransactionLogFilesHelper {
    public static final String DEFAULT_NAME = "neostore.transaction.db";
    public static final String CHECKPOINT_FILE_PREFIX = "checkpoint";
    static final DirectoryStream.Filter<Path> DEFAULT_FILENAME_FILTER = new LogicalLogFilenameFilter(Pattern.quote("neostore.transaction.db"), Pattern.quote("checkpoint"));
    public static final Predicate<String> DEFAULT_FILENAME_PREDICATE = file -> file.startsWith(DEFAULT_NAME) || file.startsWith(CHECKPOINT_FILE_PREFIX);
    private static final String VERSION_SUFFIX = ".";
    private static final String REGEX_VERSION_SUFFIX = "\\.";
    private static final Path[] EMPTY_FILES_ARRAY = new Path[0];
    private final Path logBaseName;
    private final FileSystemAbstraction fileSystem;
    private final DirectoryStream.Filter<Path> filenameFilter;

    public TransactionLogFilesHelper(FileSystemAbstraction fileSystem, Path directory) {
        this(fileSystem, directory, DEFAULT_NAME);
    }

    public TransactionLogFilesHelper(FileSystemAbstraction fileSystem, Path directory, String name) {
        this.fileSystem = fileSystem;
        this.logBaseName = directory.resolve(name);
        this.filenameFilter = new LogicalLogFilenameFilter(Pattern.quote(name));
    }

    public Path getLogFileForVersion(long version) {
        return Path.of(this.logBaseName.toAbsolutePath().toString() + VERSION_SUFFIX + version, new String[0]);
    }

    public long getLogVersion(Path historyLogFile) {
        String historyLogFilename = historyLogFile.getFileName().toString();
        int index = historyLogFilename.lastIndexOf(VERSION_SUFFIX);
        if (index == -1) {
            throw new RuntimeException("Invalid log file '" + historyLogFilename + "'");
        }
        return Long.parseLong(historyLogFilename.substring(index + VERSION_SUFFIX.length()));
    }

    DirectoryStream.Filter<Path> getLogFilenameFilter() {
        return this.filenameFilter;
    }

    public Path[] getMatchedFiles() {
        Path[] files = this.fileSystem.listFiles(this.logBaseName.getParent(), this.getLogFilenameFilter());
        if (files.length == 0) {
            return EMPTY_FILES_ARRAY;
        }
        return files;
    }

    public void accept(LogVersionVisitor visitor) {
        for (Path file : this.getMatchedFiles()) {
            visitor.visit(file, this.getLogVersion(file));
        }
    }

    private static final class LogicalLogFilenameFilter
    implements DirectoryStream.Filter<Path> {
        private final Pattern[] patterns;

        LogicalLogFilenameFilter(String ... logFileNameBase) {
            Objects.requireNonNull(logFileNameBase);
            this.patterns = (Pattern[])Arrays.stream(logFileNameBase).map(name -> Pattern.compile(name + "\\..*")).toArray(Pattern[]::new);
        }

        @Override
        public boolean accept(Path entry) {
            for (Pattern pattern : this.patterns) {
                if (!pattern.matcher(entry.getFileName().toString()).matches()) continue;
                return true;
            }
            return false;
        }
    }
}

