/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import org.eclipse.collections.impl.map.mutable.primitive.ByteObjectHashMap;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParserSet;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParserSetVersion;
import org.neo4j.kernel.impl.transaction.log.entry.UnsupportedLogVersionException;
import org.neo4j.util.Preconditions;

public abstract class LogVersionSelector {
    private final ByteObjectHashMap<LogEntryParserSet> sets;
    private final byte latestVersion;

    protected LogVersionSelector(byte latestVersion) {
        this.latestVersion = latestVersion;
        this.sets = new ByteObjectHashMap();
    }

    protected void register(LogEntryParserSet set) {
        byte version = set.versionByte();
        Preconditions.checkState((!this.sets.containsKey(version) ? 1 : 0) != 0, (String)"Conflicting version %d", (Object[])new Object[]{version});
        this.sets.put(version, (Object)set);
    }

    public LogEntryParserSet select(byte version) {
        LogEntryParserSet set = (LogEntryParserSet)this.sets.get(version);
        if (set != null) {
            return set;
        }
        if (version > this.latestVersion) {
            throw new UnsupportedLogVersionException(String.format("Log file contains entries with prefix %d, and the highest supported prefix is %d. This indicates that the log files originates from a newer version of neo4j.", version, this.latestVersion));
        }
        throw new UnsupportedLogVersionException(String.format("Log file contains entries with prefix %d, and the lowest supported prefix is %d. This indicates that the log files originates from an older version of neo4j, which we don't support migrations from.", version, this.sets.keySet().min()));
    }

    public LogEntryParserSet select(LogEntryParserSetVersion parserSetVersion) {
        return this.select(parserSetVersion.getVersionByte());
    }

    public boolean moreRecentVersionExists(byte version) {
        return version < this.latestVersion;
    }
}

