/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry.legacy;

import java.io.IOException;
import org.neo4j.io.fs.ReadableChannel;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntrySerializer;
import org.neo4j.kernel.impl.transaction.log.entry.legacy.LegacyInlinedCheckPoint;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.CommandReaderFactory;

public class InlineCheckpointLogEntrySerializer
extends LogEntrySerializer<LegacyInlinedCheckPoint> {
    private final boolean haveChecksum;

    public InlineCheckpointLogEntrySerializer(boolean haveChecksum) {
        super((byte)7);
        this.haveChecksum = haveChecksum;
    }

    @Override
    public LegacyInlinedCheckPoint parse(KernelVersion version, ReadableChannel channel, LogPositionMarker marker, CommandReaderFactory commandReaderFactory, MemoryTracker memoryTracker) throws IOException {
        long logVersion = channel.getLong();
        long byteOffset = channel.getLong();
        if (this.haveChecksum) {
            channel.getInt();
        }
        return new LegacyInlinedCheckPoint(new LogPosition(logVersion, byteOffset));
    }

    @Override
    public int write(WritableChannel channel, LegacyInlinedCheckPoint logEntry) {
        throw new UnsupportedOperationException("Unable to write inline checkpoints");
    }
}

