/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.enveloped;

import java.io.IOException;
import java.nio.file.Path;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderReader;
import org.neo4j.kernel.impl.transaction.log.enveloped.PruneStrategy;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;

class LogPruningByEntryStrategy
implements PruneStrategy {
    private final FileSystemAbstraction fs;
    private final long entriesToKeep;

    public LogPruningByEntryStrategy(FileSystemAbstraction fs, long entriesToKeep) {
        this.fs = fs;
        this.entriesToKeep = entriesToKeep;
    }

    @Override
    public PruneStrategy.PruneConstraint newConstraint(long currentEntry, long currentOffset, Path currentLogFile) throws IOException {
        long lastAppendIndex = LogHeaderReader.readLogHeader(this.fs, currentLogFile, (MemoryTracker)EmptyMemoryTracker.INSTANCE).getLastAppendIndex();
        long entriesToKeep = this.entriesToKeep - (currentEntry - lastAppendIndex);
        return new LogPruningByEntry(this.fs, entriesToKeep, lastAppendIndex);
    }

    static class LogPruningByEntry
    implements PruneStrategy.PruneConstraint {
        private final FileSystemAbstraction fs;
        private long entriesLeft;
        private long lastIndex;

        LogPruningByEntry(FileSystemAbstraction fs, long entriesLeft, long lastIndex) {
            this.fs = fs;
            this.entriesLeft = entriesLeft;
            this.lastIndex = lastIndex;
        }

        @Override
        public boolean shouldPrune(Path path) throws IOException {
            long prev = this.lastIndex;
            this.lastIndex = LogHeaderReader.readLogHeader(this.fs, path, (MemoryTracker)EmptyMemoryTracker.INSTANCE).getLastAppendIndex();
            if (prev == -1L) {
                return false;
            }
            boolean shouldPrune = this.entriesLeft <= 0L;
            this.entriesLeft -= prev - this.lastIndex;
            return shouldPrune;
        }
    }
}

