/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.enveloped;

import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Path;
import org.neo4j.collection.RawIterator;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderReader;
import org.neo4j.kernel.impl.transaction.log.enveloped.LogChannelContext;
import org.neo4j.kernel.impl.transaction.log.enveloped.LogFileMetadata;
import org.neo4j.kernel.impl.transaction.log.enveloped.LogsRepository;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;

public class LogFilesMetadata
implements RawIterator<LogFileMetadata, IOException> {
    private final LogsRepository logsRepository;
    private final long[] versions;
    private int currentVersionIndex = -1;
    private LogFileMetadata nextMetadata = null;

    LogFilesMetadata(LogsRepository logsRepository) throws IOException {
        this.logsRepository = logsRepository;
        this.versions = logsRepository.logVersions(false);
    }

    public boolean hasNext() {
        return this.versions.length != 0 && (this.currentVersionIndex == -1 || this.nextMetadata != null);
    }

    public LogFileMetadata next() throws IOException {
        if (!this.hasNext()) {
            throw new IllegalStateException("No more versions available");
        }
        LogFileMetadata currentMetadata = this.nextMetadata;
        this.setNext();
        if (this.currentVersionIndex == 0) {
            return this.next();
        }
        return currentMetadata;
    }

    private void setNext() throws IOException {
        if (++this.currentVersionIndex != this.versions.length) {
            long version = this.versions[this.currentVersionIndex];
            LogChannelContext<StoreChannel> logChannel = this.logsRepository.openReadChannel(version);
            Path currentPath = logChannel.path();
            LogHeader logHeader = LogHeaderReader.readLogHeader((ReadableByteChannel)logChannel.channel(), true, null, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            if (logHeader != null) {
                this.nextMetadata = new LogFileMetadata(logHeader, version, currentPath);
                return;
            }
        }
        this.nextMetadata = null;
    }
}

