/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry.vGloriousFuture;

import java.io.IOException;
import org.neo4j.io.fs.ReadableChannel;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.entry.BadLogEntryException;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntrySerializer;
import org.neo4j.kernel.impl.transaction.log.entry.vGloriousFuture.LogEntryStartVGloriousFuture;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.CommandReaderFactory;

public class StartLogEntrySerializerVGloriousFuture
extends LogEntrySerializer<LogEntryStartVGloriousFuture> {
    public StartLogEntrySerializerVGloriousFuture() {
        super((byte)1);
    }

    @Override
    public LogEntryStartVGloriousFuture parse(KernelVersion version, ReadableChannel channel, LogPositionMarker marker, CommandReaderFactory commandReaderFactory, MemoryTracker memoryTracker) throws IOException {
        long timeWritten = channel.getLong();
        long latestCommittedTxWhenStarted = channel.getLong();
        long appendIndex = channel.getAppendIndex();
        int additionalHeaderLength = channel.getInt();
        if (additionalHeaderLength > 8) {
            throw new BadLogEntryException("Additional header length limit(8) exceeded. Parsed length is " + additionalHeaderLength);
        }
        byte[] additionalHeader = new byte[additionalHeaderLength];
        channel.get(additionalHeader, additionalHeaderLength);
        return new LogEntryStartVGloriousFuture(version, timeWritten, latestCommittedTxWhenStarted, appendIndex, additionalHeader);
    }

    @Override
    public int write(WritableChannel channel, LogEntryStartVGloriousFuture logEntry) throws IOException {
        channel.beginChecksumForWriting();
        StartLogEntrySerializerVGloriousFuture.writeLogEntryHeader(logEntry.kernelVersion(), (byte)1, channel);
        byte[] additionalHeaderData = logEntry.getAdditionalHeader();
        channel.putLong(logEntry.getTimeWritten()).putLong(logEntry.getLastCommittedTxWhenTransactionStarted()).putAppendIndex(logEntry.getAppendIndex()).putInt(additionalHeaderData.length).put(additionalHeaderData, additionalHeaderData.length);
        return 0;
    }
}

