/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.util.Arrays;
import org.neo4j.hashing.HashFunction;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.AnyValue;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.NumberType;
import org.neo4j.values.storable.NumberValues;
import org.neo4j.values.storable.PrimitiveArrayWriting;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueRepresentation;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.storable.Values;

public final class BooleanArray
extends ArrayValue {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(BooleanArray.class);
    private final boolean[] value;

    BooleanArray(boolean[] value) {
        assert (value != null);
        this.value = value;
    }

    @Override
    public int length() {
        return this.value.length;
    }

    public boolean booleanValue(int offset) {
        return this.value[offset];
    }

    @Override
    public String getTypeName() {
        return "BooleanArray";
    }

    @Override
    public boolean equals(Value other) {
        return other.equals(this.value);
    }

    @Override
    public boolean equals(boolean[] x) {
        return Arrays.equals(this.value, x);
    }

    @Override
    protected int computeHashToMemoize() {
        return NumberValues.hash(this.value);
    }

    @Override
    public long updateHash(HashFunction hashFunction, long hash) {
        hash = hashFunction.update(hash, (long)this.value.length);
        hash = hashFunction.update(hash, (long)this.hashCode());
        return hash;
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapBooleanArray(this);
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        PrimitiveArrayWriting.writeTo(writer, this.value);
    }

    public boolean[] asObjectCopy() {
        return Arrays.copyOf(this.value, this.value.length);
    }

    @Deprecated
    public boolean[] asObject() {
        return this.value;
    }

    @Override
    protected int unsafeCompareTo(Value otherValue) {
        return NumberValues.compareBooleanArrays(this, (BooleanArray)otherValue);
    }

    @Override
    public ValueRepresentation valueRepresentation() {
        return ValueRepresentation.BOOLEAN_ARRAY;
    }

    @Override
    public NumberType numberType() {
        return NumberType.NO_NUMBER;
    }

    @Override
    public String prettyPrint() {
        return Arrays.toString(this.value);
    }

    @Override
    public AnyValue value(int position) {
        return Values.booleanValue(this.booleanValue(position));
    }

    public String toString() {
        return String.format("%s%s", this.getTypeName(), Arrays.toString(this.value));
    }

    public long estimatedHeapUsage() {
        return SHALLOW_SIZE + HeapEstimator.sizeOf((boolean[])this.value);
    }

    @Override
    public boolean hasCompatibleType(AnyValue value) {
        return value instanceof BooleanValue;
    }

    @Override
    public ArrayValue copyWithAppended(AnyValue added) {
        assert (this.hasCompatibleType(added)) : "Incompatible types";
        boolean[] newArray = Arrays.copyOf(this.value, this.value.length + 1);
        newArray[this.value.length] = ((BooleanValue)added).booleanValue();
        return new BooleanArray(newArray);
    }

    @Override
    public ArrayValue copyWithPrepended(AnyValue prepended) {
        assert (this.hasCompatibleType(prepended)) : "Incompatible types";
        boolean[] newArray = new boolean[this.value.length + 1];
        newArray[0] = ((BooleanValue)prepended).booleanValue();
        System.arraycopy(this.value, 0, newArray, 1, this.value.length);
        return new BooleanArray(newArray);
    }

    @Override
    public boolean equals(SequenceValue other) {
        if (other instanceof ArrayValue) {
            ArrayValue otherArray = (ArrayValue)other;
            return otherArray.equals(this.value);
        }
        return super.equals(other);
    }
}

