/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.utils;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.neo4j.exceptions.CypherTypeException;
import org.neo4j.exceptions.InvalidSemanticsException;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.values.AnyValue;
import org.neo4j.values.AnyValues;
import org.neo4j.values.Comparison;
import org.neo4j.values.Equality;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.utils.InCache;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualPathValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;
import org.neo4j.values.virtual.VirtualValues;

public final class ValueBooleanLogic {
    private static final BooleanMapper BOOLEAN_MAPPER = new BooleanMapper();

    private ValueBooleanLogic() {
        throw new UnsupportedOperationException("Do not instantiate");
    }

    public static BooleanValue xor(BooleanValue lhs, BooleanValue rhs) {
        return lhs == Values.TRUE ^ rhs == Values.TRUE ? Values.TRUE : Values.FALSE;
    }

    public static Value not(AnyValue in) {
        assert (in == Values.NO_VALUE || in == Values.TRUE || in == Values.FALSE);
        return in == Values.NO_VALUE ? Values.NO_VALUE : (in != Values.TRUE ? Values.TRUE : Values.FALSE);
    }

    public static Value equals(AnyValue lhs, AnyValue rhs) {
        Equality compare = lhs.ternaryEquals(rhs);
        return switch (compare) {
            default -> throw new IncompatibleClassChangeError();
            case Equality.TRUE -> Values.TRUE;
            case Equality.FALSE -> Values.FALSE;
            case Equality.UNDEFINED -> Values.NO_VALUE;
        };
    }

    public static Value notEquals(AnyValue lhs, AnyValue rhs) {
        Equality compare = lhs.ternaryEquals(rhs);
        return switch (compare) {
            default -> throw new IncompatibleClassChangeError();
            case Equality.TRUE -> Values.FALSE;
            case Equality.FALSE -> Values.TRUE;
            case Equality.UNDEFINED -> Values.NO_VALUE;
        };
    }

    public static BooleanValue regex(TextValue lhs, TextValue rhs) {
        assert (lhs != Values.NO_VALUE && rhs != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        String regexString = rhs.stringValue();
        try {
            boolean matches = Pattern.compile(regexString).matcher(lhs.stringValue()).matches();
            return matches ? Values.TRUE : Values.FALSE;
        }
        catch (PatternSyntaxException e) {
            throw new InvalidSemanticsException("Invalid Regex: " + e.getMessage(), null);
        }
    }

    public static BooleanValue regex(TextValue text, Pattern pattern) {
        assert (text != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        boolean matches = pattern.matcher(text.stringValue()).matches();
        return matches ? Values.TRUE : Values.FALSE;
    }

    public static Value lessThan(AnyValue lhs, AnyValue rhs) {
        if (AnyValue.isNanAndNumber(lhs, rhs)) {
            return Values.FALSE;
        }
        Comparison comparison = AnyValues.TERNARY_COMPARATOR.ternaryCompare(lhs, rhs);
        return switch (comparison) {
            default -> throw new IncompatibleClassChangeError();
            case Comparison.EQUAL -> {
                if (lhs.isIncomparableType()) {
                    yield Values.NO_VALUE;
                }
                yield Values.FALSE;
            }
            case Comparison.GREATER_THAN -> Values.FALSE;
            case Comparison.SMALLER_THAN -> Values.TRUE;
            case Comparison.UNDEFINED -> Values.NO_VALUE;
        };
    }

    public static Value lessThanOrEqual(AnyValue lhs, AnyValue rhs) {
        if (AnyValue.isNanAndNumber(lhs, rhs)) {
            return Values.FALSE;
        }
        Comparison comparison = AnyValues.TERNARY_COMPARATOR.ternaryCompare(lhs, rhs);
        return switch (comparison) {
            default -> throw new IncompatibleClassChangeError();
            case Comparison.GREATER_THAN -> Values.FALSE;
            case Comparison.EQUAL, Comparison.SMALLER_THAN -> Values.TRUE;
            case Comparison.UNDEFINED -> Values.NO_VALUE;
        };
    }

    public static Value greaterThan(AnyValue lhs, AnyValue rhs) {
        if (AnyValue.isNanAndNumber(lhs, rhs)) {
            return Values.FALSE;
        }
        Comparison comparison = AnyValues.TERNARY_COMPARATOR.ternaryCompare(lhs, rhs);
        return switch (comparison) {
            default -> throw new IncompatibleClassChangeError();
            case Comparison.GREATER_THAN -> Values.TRUE;
            case Comparison.EQUAL -> {
                if (lhs.isIncomparableType()) {
                    yield Values.NO_VALUE;
                }
                yield Values.FALSE;
            }
            case Comparison.SMALLER_THAN -> Values.FALSE;
            case Comparison.UNDEFINED -> Values.NO_VALUE;
        };
    }

    public static Value greaterThanOrEqual(AnyValue lhs, AnyValue rhs) {
        if (AnyValue.isNanAndNumber(lhs, rhs)) {
            return Values.FALSE;
        }
        Comparison comparison = AnyValues.TERNARY_COMPARATOR.ternaryCompare(lhs, rhs);
        return switch (comparison) {
            default -> throw new IncompatibleClassChangeError();
            case Comparison.EQUAL, Comparison.GREATER_THAN -> Values.TRUE;
            case Comparison.SMALLER_THAN -> Values.FALSE;
            case Comparison.UNDEFINED -> Values.NO_VALUE;
        };
    }

    public static Value coerceToBoolean(AnyValue value) {
        return value.map(BOOLEAN_MAPPER);
    }

    public static Value in(AnyValue findMe, AnyValue lookIn) {
        if (lookIn == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        ListValue list = VirtualValues.asList(lookIn);
        if (list.isEmpty()) {
            return BooleanValue.FALSE;
        }
        if (findMe == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        return list.ternaryContains(findMe);
    }

    public static Value in(AnyValue findMe, AnyValue lookIn, InCache cache, MemoryTracker memoryTracker) {
        if (lookIn == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        return cache.check(findMe, VirtualValues.asList(lookIn), memoryTracker);
    }

    private static final class BooleanMapper
    implements ValueMapper<Value> {
        private BooleanMapper() {
        }

        @Override
        public Value mapPath(VirtualPathValue value) {
            return value.size() > 0 ? Values.TRUE : Values.FALSE;
        }

        @Override
        public Value mapNode(VirtualNodeValue value) {
            throw new CypherTypeException("Don't know how to treat that as a boolean: " + value);
        }

        @Override
        public Value mapRelationship(VirtualRelationshipValue value) {
            throw new CypherTypeException("Don't know how to treat that as a boolean: " + value);
        }

        @Override
        public Value mapMap(MapValue value) {
            throw new CypherTypeException("Don't know how to treat that as a boolean: " + value);
        }

        @Override
        public Value mapNoValue() {
            return Values.NO_VALUE;
        }

        @Override
        public Value mapSequence(SequenceValue value) {
            return value.intSize() > 0 ? Values.TRUE : Values.FALSE;
        }

        @Override
        public Value mapText(TextValue value) {
            throw new CypherTypeException("Don't know how to treat that as a boolean: " + value);
        }

        @Override
        public Value mapBoolean(BooleanValue value) {
            return value;
        }

        @Override
        public Value mapNumber(NumberValue value) {
            throw new CypherTypeException("Don't know how to treat that as a boolean: " + value);
        }

        @Override
        public Value mapDateTime(DateTimeValue value) {
            throw new CypherTypeException("Don't know how to treat that as a boolean: " + value);
        }

        @Override
        public Value mapLocalDateTime(LocalDateTimeValue value) {
            throw new CypherTypeException("Don't know how to treat that as a boolean: " + value);
        }

        @Override
        public Value mapDate(DateValue value) {
            throw new CypherTypeException("Don't know how to treat that as a boolean: " + value);
        }

        @Override
        public Value mapTime(TimeValue value) {
            throw new CypherTypeException("Don't know how to treat that as a boolean: " + value);
        }

        @Override
        public Value mapLocalTime(LocalTimeValue value) {
            throw new CypherTypeException("Don't know how to treat that as a boolean: " + value);
        }

        @Override
        public Value mapDuration(DurationValue value) {
            throw new CypherTypeException("Don't know how to treat that as a boolean: " + value);
        }

        @Override
        public Value mapPoint(PointValue value) {
            throw new CypherTypeException("Don't know how to treat that as a boolean: " + value);
        }
    }
}

