/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.FloatingPointValue;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.ScalarValue;
import org.neo4j.values.storable.Value;

public abstract class NumberValue
extends ScalarValue {
    static long castToLong(String name, AnyValue value) {
        if (value == null) {
            return 0L;
        }
        if (value instanceof IntegralValue) {
            IntegralValue integralValue = (IntegralValue)value;
            return integralValue.longValue();
        }
        throw new IllegalArgumentException(name + " must be an integral value, but was a " + value.getClass().getSimpleName());
    }

    static double safeCastFloatingPoint(String name, AnyValue value, double defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (!(value instanceof NumberValue)) {
            throw new IllegalArgumentException(name + " must be a number value, but was a " + value.getClass().getSimpleName());
        }
        NumberValue numberValue = (NumberValue)value;
        return numberValue.doubleValue();
    }

    public abstract long longValue();

    public abstract float floatValue();

    public abstract double doubleValue();

    public abstract int compareTo(IntegralValue var1);

    public abstract int compareTo(FloatingPointValue var1);

    @Override
    protected int unsafeCompareTo(Value otherValue) {
        if (otherValue instanceof IntegralValue) {
            IntegralValue integralValue = (IntegralValue)otherValue;
            return this.compareTo(integralValue);
        }
        if (otherValue instanceof FloatingPointValue) {
            FloatingPointValue floatingPointValue = (FloatingPointValue)otherValue;
            return this.compareTo(floatingPointValue);
        }
        throw new IllegalArgumentException("Cannot compare different values");
    }

    @Override
    public abstract Number asObjectCopy();

    @Override
    public Number asObject() {
        return this.asObjectCopy();
    }

    @Override
    public final boolean equals(boolean x) {
        return false;
    }

    @Override
    public final boolean equals(char x) {
        return false;
    }

    @Override
    public final boolean equals(String x) {
        return false;
    }

    public abstract NumberValue minus(long var1);

    public abstract NumberValue minus(double var1);

    public abstract NumberValue plus(long var1);

    public abstract NumberValue plus(double var1);

    public abstract NumberValue times(long var1);

    public abstract NumberValue times(double var1);

    public abstract NumberValue dividedBy(long var1);

    public abstract NumberValue dividedBy(double var1);

    public NumberValue minus(NumberValue numberValue) {
        if (numberValue instanceof IntegralValue) {
            return this.minus(numberValue.longValue());
        }
        if (numberValue instanceof FloatingPointValue) {
            return this.minus(numberValue.doubleValue());
        }
        throw new IllegalArgumentException("Cannot subtract " + numberValue);
    }

    public NumberValue plus(NumberValue numberValue) {
        if (numberValue instanceof IntegralValue) {
            return this.plus(numberValue.longValue());
        }
        if (numberValue instanceof FloatingPointValue) {
            return this.plus(numberValue.doubleValue());
        }
        throw new IllegalArgumentException("Cannot subtract " + numberValue);
    }

    public NumberValue times(NumberValue numberValue) {
        if (numberValue instanceof IntegralValue) {
            return this.times(numberValue.longValue());
        }
        if (numberValue instanceof FloatingPointValue) {
            return this.times(numberValue.doubleValue());
        }
        throw new IllegalArgumentException("Cannot multiply with " + numberValue);
    }

    public NumberValue divideBy(NumberValue numberValue) {
        if (numberValue instanceof IntegralValue) {
            return this.dividedBy(numberValue.longValue());
        }
        if (numberValue instanceof FloatingPointValue) {
            return this.dividedBy(numberValue.doubleValue());
        }
        throw new IllegalArgumentException("Cannot divide by " + numberValue);
    }
}

